/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_;
import org.knowm.xchart.internal.chartpart.RenderableSeries;
import org.knowm.xchart.internal.series.MarkerSeries;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.lines.SeriesLines;

public class Legend_Marker<ST extends Styler, S extends MarkerSeries>
extends Legend_<ST, S> {
    private final ST axesChartStyler;

    public Legend_Marker(Chart<ST, S> chart) {
        super(chart);
        this.axesChartStyler = chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g) {
        double startx = this.xOffset + (double)((Styler)this.chart.getStyler()).getLegendPadding();
        double starty = this.yOffset + (double)((Styler)this.chart.getStyler()).getLegendPadding();
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Map map = this.chart.getSeriesMap();
        for (MarkerSeries series : map.values()) {
            double x;
            if (!series.isShowInLegend() || !series.isEnabled()) continue;
            Map<String, Rectangle2D> seriesTextBounds = this.getSeriesTextBounds(series);
            float legendEntryHeight = this.getLegendEntryHeight(seriesTextBounds, series.getLegendRenderType() == RenderableSeries.LegendRenderType.Line || series.getLegendRenderType() == RenderableSeries.LegendRenderType.Scatter ? ((Styler)this.axesChartStyler).getMarkerSize() : 20);
            if (series.getLegendRenderType() == RenderableSeries.LegendRenderType.Line || series.getLegendRenderType() == RenderableSeries.LegendRenderType.Scatter) {
                if (series.getLegendRenderType() == RenderableSeries.LegendRenderType.Line && series.getLineStyle() != SeriesLines.NONE) {
                    g.setColor(series.getLineColor());
                    g.setStroke(series.getLineStyle());
                    Line2D.Double line = new Line2D.Double(startx, starty + (double)legendEntryHeight / 2.0, startx + (double)((Styler)this.chart.getStyler()).getLegendSeriesLineLength(), starty + (double)legendEntryHeight / 2.0);
                    g.draw(line);
                }
                if (series.getMarker() != null) {
                    g.setColor(series.getMarkerColor());
                    series.getMarker().paint(g, startx + (double)((Styler)this.chart.getStyler()).getLegendSeriesLineLength() / 2.0, starty + (double)legendEntryHeight / 2.0, ((Styler)this.axesChartStyler).getMarkerSize());
                }
            } else {
                Rectangle2D.Double rectSmall = new Rectangle2D.Double(startx, starty, 20.0, 20.0);
                g.setColor(series.getFillColor());
                g.fill(rectSmall);
                if (series.getLegendRenderType() != RenderableSeries.LegendRenderType.BoxNoOutline) {
                    g.setColor(series.getLineColor());
                    BasicStroke existingLineStyle = series.getLineStyle();
                    BasicStroke newLineStyle = new BasicStroke(Math.min(existingLineStyle.getLineWidth(), 2.5f), existingLineStyle.getEndCap(), existingLineStyle.getLineJoin(), existingLineStyle.getMiterLimit(), existingLineStyle.getDashArray(), existingLineStyle.getDashPhase());
                    g.setPaint(series.getLineColor());
                    g.setStroke(newLineStyle);
                    Path2D.Double outlinePath = new Path2D.Double();
                    double lineOffset = (double)existingLineStyle.getLineWidth() * 0.5;
                    outlinePath.moveTo(startx + lineOffset, starty + lineOffset);
                    outlinePath.lineTo(startx + lineOffset, starty + 20.0 - lineOffset);
                    outlinePath.lineTo(startx + 20.0 - lineOffset, starty + 20.0 - lineOffset);
                    outlinePath.lineTo(startx + 20.0 - lineOffset, starty + lineOffset);
                    outlinePath.closePath();
                    g.draw(outlinePath);
                }
            }
            if (series.getLegendRenderType() == RenderableSeries.LegendRenderType.Line || series.getLegendRenderType() == RenderableSeries.LegendRenderType.Scatter) {
                x = startx + (double)((Styler)this.chart.getStyler()).getLegendSeriesLineLength() + (double)((Styler)this.chart.getStyler()).getLegendPadding();
                this.paintSeriesText(g, seriesTextBounds, ((Styler)this.axesChartStyler).getMarkerSize(), x, starty);
            } else {
                x = startx + 20.0 + (double)((Styler)this.chart.getStyler()).getLegendPadding();
                this.paintSeriesText(g, seriesTextBounds, 20, x, starty);
            }
            if (((Styler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
                starty += (double)(legendEntryHeight + (float)((Styler)this.chart.getStyler()).getLegendPadding());
                continue;
            }
            int markerWidth = 20;
            if (series.getLegendRenderType() == RenderableSeries.LegendRenderType.Line) {
                markerWidth = ((Styler)this.chart.getStyler()).getLegendSeriesLineLength();
            }
            float legendEntryWidth = this.getLegendEntryWidth(seriesTextBounds, markerWidth);
            startx += (double)(legendEntryWidth + (float)((Styler)this.chart.getStyler()).getLegendPadding());
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    @Override
    public double getSeriesLegendRenderGraphicHeight(S series) {
        return ((Series)series).getLegendRenderType() == RenderableSeries.LegendRenderType.Box || ((Series)series).getLegendRenderType() == RenderableSeries.LegendRenderType.BoxNoOutline ? 20.0 : (double)((Styler)this.axesChartStyler).getMarkerSize();
    }
}

