/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.event;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import java.io.IOException;
import org.eclipse.jdi.TimeoutException;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.event.EventSetImpl;
import org.eclipse.jdi.internal.event.VMDisconnectEventImpl;
import org.eclipse.jdi.internal.jdwp.JdwpCommandPacket;
import org.eclipse.jdi.internal.request.RequestID;

public class EventQueueImpl
extends MirrorImpl
implements EventQueue {
    private boolean genereatedVMDisconnectEvent = false;

    public EventQueueImpl(VirtualMachineImpl vmImpl) {
        super("EventQueue", vmImpl);
    }

    @Override
    public EventSet remove() throws InterruptedException {
        return this.remove(-1L);
    }

    @Override
    public EventSet remove(long timeout) throws InterruptedException {
        try {
            EventSetImpl set;
            do {
                JdwpCommandPacket packet = this.getCommandVM(16484, timeout);
                this.initJdwpEventSet(packet);
                set = EventSetImpl.read(this, packet.dataInStream());
                this.handledJdwpEventSet(null);
            } while (set.isEmpty());
            return set;
        }
        catch (TimeoutException e) {
            this.handledJdwpEventSet(e);
            return null;
        }
        catch (IOException e) {
            this.handledJdwpEventSet(e);
            this.defaultIOExceptionHandler(e);
            return null;
        }
        catch (VMDisconnectedException e) {
            this.handledJdwpEventSet(e);
            if (!this.genereatedVMDisconnectEvent) {
                this.genereatedVMDisconnectEvent = true;
                return new EventSetImpl(this.virtualMachineImpl(), new VMDisconnectEventImpl(this.virtualMachineImpl(), RequestID.nullID));
            }
            throw e;
        }
    }
}

