/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.parser.ast.regex;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.setext.parser.ast.regex.RegEx;
import org.eclipse.escet.setext.parser.ast.regex.RegExChar;

public class RegExSeq
extends RegEx {
    public final List<RegEx> sequence;

    public RegExSeq(List<RegEx> sequence) {
        super(null);
        this.sequence = sequence;
        Assert.check((sequence.size() >= 2 ? 1 : 0) != 0);
    }

    @Override
    public boolean acceptsEmptyString() {
        for (RegEx part : this.sequence) {
            if (part.acceptsEmptyString()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Integer> getCodePoints() {
        Set rslt = null;
        for (RegEx part : this.sequence) {
            Set partRslt = part.getCodePoints();
            Set set = rslt = rslt == null ? partRslt : Sets.union(rslt, partRslt);
        }
        return rslt;
    }

    @Override
    public Set<RegExChar> getChars() {
        Set rslt = null;
        for (RegEx part : this.sequence) {
            Set partRslt = part.getChars();
            Set set = rslt = rslt == null ? partRslt : Sets.union(rslt, partRslt);
        }
        return rslt;
    }

    @Override
    public boolean isDescriptionText() {
        for (RegEx child : this.sequence) {
            if (child.isDescriptionText()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDescriptionText() {
        StringBuilder txt = new StringBuilder();
        for (RegEx child : this.sequence) {
            String childTxt = child.getDescriptionText();
            if (childTxt == null) {
                return null;
            }
            txt.append(childTxt);
        }
        return txt.toString();
    }

    @Override
    public int getBindingStrength() {
        return 1;
    }

    @Override
    public String toString() {
        int myStrength = this.getBindingStrength();
        StringBuilder rslt = new StringBuilder();
        boolean first = true;
        for (RegEx part : this.sequence) {
            String partTxt = part.toString();
            int partStrength = part.getBindingStrength();
            if (myStrength > partStrength || myStrength == partStrength && !first) {
                rslt.append("(" + partTxt + ")");
            } else {
                rslt.append(partTxt);
            }
            first = false;
        }
        return rslt.toString();
    }
}

