/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators.io;

import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.escet.cif.plcgen.generators.io.IoAddress;
import org.eclipse.escet.common.java.Strings;

public class DefaultIoAddress
implements IoAddress {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile(" *%([IQM])([XBWDL]?)([0-9]+(\\.[0-9]+)*) *");
    public final String memType;
    public final String sizeType;
    public final String[] numericParts;

    public DefaultIoAddress(String memType, String sizeType, String[] numericParts) {
        this.memType = memType;
        this.sizeType = sizeType;
        this.numericParts = numericParts;
    }

    @Override
    public boolean supportsInput() {
        return "I".equals(this.memType) || "M".equals(this.memType);
    }

    @Override
    public boolean supportsOutput() {
        return "Q".equals(this.memType) || "M".equals(this.memType);
    }

    @Override
    public int size() {
        return switch (this.sizeType) {
            case "", "X" -> 1;
            case "B" -> 8;
            case "W" -> 16;
            case "D" -> 32;
            case "L" -> 64;
            default -> throw new AssertionError((Object)("Unknown size type: " + this.sizeType));
        };
    }

    public static DefaultIoAddress parseAddress(String addressText) {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressText = addressText.toUpperCase(Locale.US));
        if (!matcher.matches()) {
            return null;
        }
        String[] numericParts = matcher.group(3).split("\\.");
        return new DefaultIoAddress(matcher.group(1), matcher.group(2), numericParts);
    }

    @Override
    public String getAddress() {
        String numericAddress = String.join((CharSequence)".", this.numericParts);
        return Strings.fmt((String)"%%%s%s%s", (Object[])new Object[]{this.memType, this.sizeType, numericAddress});
    }

    @Override
    public String toString() {
        return this.getAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void da;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultIoAddress)) {
            return false;
        }
        DefaultIoAddress defaultIoAddress = (DefaultIoAddress)obj;
        return this.memType.equals(da.memType) && this.sizeType.equals(da.sizeType) && Arrays.equals(this.numericParts, da.numericParts);
    }

    @Override
    public int hashCode() {
        return this.memType.hashCode() + this.sizeType.hashCode() + Arrays.hashCode(this.numericParts);
    }
}

