/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;

public class MultiTextSelection
implements IMultiTextSelection {
    private final IDocument fDocument;
    private final IRegion[] fRegions;
    private final int fLength;
    private final int fStartLine;
    private final int fLastLine;
    private final String fText;

    public MultiTextSelection(IDocument document, IRegion[] regions) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)regions);
        this.fDocument = document;
        this.fRegions = Arrays.copyOf(regions, regions.length);
        Arrays.sort(this.fRegions, Comparator.comparingInt(IRegion::getOffset).thenComparingInt(IRegion::getLength));
        if (this.fRegions != null && this.fRegions.length > 0) {
            IRegion lastRegion = this.fRegions[this.fRegions.length - 1];
            this.fLength = lastRegion.getOffset() + lastRegion.getLength() - this.fRegions[0].getOffset();
            this.fStartLine = MultiTextSelection.getLineOfOffset(document, this.fRegions[0].getOffset());
            this.fLastLine = MultiTextSelection.getLineOfOffset(document, lastRegion.getOffset() + lastRegion.getLength());
            this.fText = Arrays.stream(this.fRegions).map(region -> {
                try {
                    return this.fDocument.get(region.getOffset(), region.getLength());
                }
                catch (BadLocationException e) {
                    return e.getMessage();
                }
            }).collect(Collectors.joining());
        } else {
            this.fLength = 0;
            this.fStartLine = 0;
            this.fLastLine = 0;
            this.fText = null;
        }
    }

    private static int getLineOfOffset(IDocument document, int offset) {
        try {
            return document.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    @Override
    public int getOffset() {
        if (this.fRegions.length > 0) {
            return this.fRegions[0].getOffset();
        }
        return 0;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getStartLine() {
        return this.fStartLine;
    }

    @Override
    public int getEndLine() {
        return this.fLastLine;
    }

    @Override
    public String getText() {
        return this.fText;
    }

    public boolean isEmpty() {
        return Arrays.stream(this.fRegions).allMatch(region -> region.getLength() == 0);
    }

    @Override
    public IRegion[] getRegions() {
        return this.fRegions;
    }
}

