/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;

public class GenericTextHover
implements IAnnotationHover,
ITextHover,
ITextHoverExtension2 {
    private final ISourceViewer sourceViewer;

    public GenericTextHover(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        if (lineNumber < 0) {
            return null;
        }
        return this.getHoverInfo(lineNumber, -1);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo2(textViewer, hoverRegion);
    }

    public String getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        int offset = hoverRegion.getOffset();
        Assert.check((offset >= 0 ? 1 : 0) != 0);
        return this.getHoverInfo(-1, offset);
    }

    private String getHoverInfo(int lineNumber, int offset) {
        List<Annotation> annos = this.getAnnotations(lineNumber, offset);
        if (annos == null) {
            return null;
        }
        TreeSet<String> messages = new TreeSet<String>();
        for (Annotation annotation : annos) {
            String message = annotation.getText();
            if (message == null) continue;
            messages.add(message);
        }
        if (messages.size() == 0) {
            return null;
        }
        if (messages.size() == 1) {
            return (String)messages.iterator().next();
        }
        String header = lineNumber == -1 ? "Multiple problems at this position:" : "Multiple problems at this line:";
        return this.formatMessages(header, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Annotation> getAnnotations(int lineNumber, int offset) {
        IAnnotationModel annoModel;
        IAnnotationModel iAnnotationModel = annoModel = this.sourceViewer instanceof ISourceViewerExtension2 ? ((ISourceViewerExtension2)this.sourceViewer).getVisualAnnotationModel() : this.sourceViewer.getAnnotationModel();
        if (annoModel == null) {
            return null;
        }
        IAnnotationModel lockObject = annoModel instanceof ISynchronizable ? ((ISynchronizable)annoModel).getLockObject() : annoModel;
        List annos = Lists.list();
        IAnnotationModel iAnnotationModel2 = lockObject;
        synchronized (iAnnotationModel2) {
            Iterator iterator = annoModel.getAnnotationIterator();
            this.getAnnotations(iterator, annoModel, annos, lineNumber, offset);
        }
        return annos;
    }

    private void getAnnotations(Iterator<Annotation> annoIter, IAnnotationModel annoModel, List<Annotation> annos, int lineNumber, int offset) {
        while (annoIter.hasNext()) {
            Position position;
            Annotation annotation = annoIter.next();
            if (this.excludeAnnoByType(annotation) || (position = annoModel.getPosition(annotation)) == null) continue;
            if (lineNumber != -1) {
                int line;
                IDocument doc = this.sourceViewer.getDocument();
                try {
                    line = doc.getLineOfOffset(position.getOffset());
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
                if (line != lineNumber) {
                    continue;
                }
            } else if (offset != -1) {
                int start = position.getOffset();
                int end = start + position.getLength();
                if (offset < start || end <= offset) continue;
            }
            if (annotation instanceof AnnotationBag) {
                this.getAnnotations(((AnnotationBag)annotation).iterator(), annoModel, annos, -1, -1);
                continue;
            }
            annos.add(annotation);
        }
    }

    protected boolean excludeAnnoByType(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            return false;
        }
        if (annotation instanceof SpellingAnnotation) {
            return false;
        }
        return !(annotation instanceof AnnotationBag);
    }

    protected String formatMessages(String header, TreeSet<String> messages) {
        StringBuilder rslt = new StringBuilder();
        rslt.append(header);
        for (String message : messages) {
            rslt.append("\n");
            rslt.append(" - " + message);
        }
        return rslt.toString();
    }
}

