/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output;

import java.util.EnumSet;
import org.eclipse.escet.cif.simulator.options.ProfilingOption;
import org.eclipse.escet.cif.simulator.output.DebugOutputOption;
import org.eclipse.escet.cif.simulator.output.NormalOutputType;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.EnumSetOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.OutputMode;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class NormalOutputOption
extends EnumSetOption<NormalOutputType> {
    public static final EnumSet<NormalOutputType> DEFAULTS = NormalOutputOption.getDefaults();

    public NormalOutputOption() {
        super("Normal output", NormalOutputOption.getCmdLineDescription(), Character.valueOf('o'), "output", "OUTPUT", DEFAULTS, true, "Indicate which output should be printed to the console, for the \"normal\" and \"debug\" output modes.", NormalOutputType.class);
    }

    public static EnumSet<NormalOutputType> getOutputTypes() {
        return (EnumSet)Options.get(NormalOutputOption.class);
    }

    public static boolean doPrint(NormalOutputType type) {
        return NormalOutputOption.getOutputTypes().contains((Object)type);
    }

    public void postProcessValue(EnumSet<NormalOutputType> value) {
        if (((Boolean)Options.get(ProfilingOption.class)).booleanValue()) {
            this.clear();
        }
        if (OutputModeOption.getOutputMode() != OutputMode.NORMAL && OutputModeOption.getOutputMode() != OutputMode.DEBUG && DebugOutputOption.getDebugTypes().isEmpty()) {
            this.clear();
        }
    }

    private static EnumSet<NormalOutputType> getDefaults() {
        return EnumSet.of(NormalOutputType.STATE_INIT, new NormalOutputType[]{NormalOutputType.STATE_TARGET, NormalOutputType.STATE_ALG_VARS, NormalOutputType.STATE_DERIVS, NormalOutputType.TRANS_DEFAULT, NormalOutputType.CHOSEN_TRANS, NormalOutputType.INTERRUPTED_TRANS, NormalOutputType.SIM_RSLT, NormalOutputType.SEEDS, NormalOutputType.PRINT});
    }

    public String getDialogText(NormalOutputType literal) {
        return "The " + literal.description;
    }

    private static String getCmdLineDescription() {
        StringBuilder b = new StringBuilder();
        b.append("Specify comma separated names of the desired types of console output, for the \"normal\" and \"debug\" output modes. Specify ");
        NormalOutputType[] literals = (NormalOutputType[])NormalOutputType.class.getEnumConstants();
        Assert.check((literals.length > 1 ? 1 : 0) != 0);
        int i = 0;
        while (i < literals.length - 1) {
            if (i > 0) {
                b.append(", ");
            }
            NormalOutputType literal = literals[i];
            String litTxt = NormalOutputOption.getCmdLineDescription(literal);
            b.append(litTxt);
            ++i;
        }
        b.append(", and/or ");
        b.append(NormalOutputOption.getCmdLineDescription(literals[literals.length - 1]));
        b.append(". Prefix a name with \"+\" to add it on top of the defaults, or with \"-\" to remove it from the defaults.");
        return b.toString();
    }

    private static String getCmdLineDescription(NormalOutputType literal) {
        String valueTxt = EnumOption.getOptionValue((Enum)literal);
        boolean isDefault = DEFAULTS.contains((Object)literal);
        return Strings.fmt((String)"\"%s\" %sto print the %s", (Object[])new Object[]{valueTxt, isDefault ? "(default) " : "", literal.description});
    }
}

