/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.model;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeAutomaton;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEdge;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSimpleEdge;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSyncEdge;

public abstract class RuntimeSimpleAutomaton<S extends RuntimeState>
extends RuntimeAutomaton<S> {
    public final String[] locNames;
    public final int[][][] edgeData;
    public final boolean[] monitorData;
    public final RuntimeSyncEdge<S> monitorEdge;

    public RuntimeSimpleAutomaton(boolean[] monitorData, RuntimeSyncEdge<S> monitorEdge, String className, ClassLoader classLoader) {
        this.locNames = RuntimeSimpleAutomaton.loadLocNames(className, classLoader);
        this.edgeData = RuntimeSimpleAutomaton.loadEdgeData(className, classLoader);
        this.monitorData = monitorData;
        this.monitorEdge = monitorEdge;
    }

    @Override
    public int getLocCount() {
        return this.locNames.length;
    }

    @Override
    public String getLocName(int idx) {
        return this.locNames[idx];
    }

    private static String[] loadLocNames(String className, ClassLoader classLoader) {
        String resName = CifCompilerContext.getLocNamesResourcePath(className);
        InputStream stream = classLoader.getResourceAsStream(resName);
        if (stream == null) {
            String msg = "Failed to load loc names resource: " + resName;
            throw new RuntimeException(msg);
        }
        try {
            stream = new BufferedInputStream(stream);
            DataInputStream data = new DataInputStream(stream);
            int len = data.readInt();
            String[] rslt = new String[len];
            int i = 0;
            while (i < len) {
                int len2 = data.readInt();
                StringBuilder b = new StringBuilder(len2);
                int j = 0;
                while (j < len2) {
                    char c = data.readChar();
                    b.append(c);
                    ++j;
                }
                rslt[i] = b.toString();
                ++i;
            }
            String[] stringArray = rslt;
            return stringArray;
        }
        catch (IOException e) {
            String msg = "Failed to read loc names resource: " + resName;
            throw new RuntimeException(msg, e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                String msg = "Failed to close loc names resource: " + resName;
                throw new RuntimeException(msg, e);
            }
        }
    }

    private static int[][][] loadEdgeData(String className, ClassLoader classLoader) {
        String resName = CifCompilerContext.getEdgeDataResourcePath(className);
        InputStream stream = classLoader.getResourceAsStream(resName);
        if (stream == null) {
            String msg = "Failed to load edge data resource: " + resName;
            throw new RuntimeException(msg);
        }
        try {
            stream = new BufferedInputStream(stream);
            DataInputStream data = new DataInputStream(stream);
            int len1 = data.readInt();
            int[][][] rslt = new int[len1][][];
            int i = 0;
            while (i < len1) {
                int len2 = data.readInt();
                int[][] rslt2 = new int[len2][];
                rslt[i] = rslt2;
                int j = 0;
                while (j < len2) {
                    int[] rslt3 = new int[2];
                    rslt2[j] = rslt3;
                    rslt3[0] = data.readInt();
                    rslt3[1] = data.readInt();
                    ++j;
                }
                ++i;
            }
            int[][][] nArrayArray = rslt;
            return nArrayArray;
        }
        catch (IOException e) {
            String msg = "Failed to read edge data resource: " + resName;
            throw new RuntimeException(msg, e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                String msg = "Failed to close edge data resource: " + resName;
                throw new RuntimeException(msg, e);
            }
        }
    }

    protected static <S extends RuntimeState> void fillSyncData(RuntimeSimpleAutomaton<S> aut, int eventIdx, List<RuntimeEdge<S>> edges, int locIdx) {
        int[][] locEdges;
        int[][] nArray = locEdges = aut.edgeData[locIdx];
        int n = locEdges.length;
        int n2 = 0;
        while (n2 < n) {
            int[] locEdge = nArray[n2];
            if (locEdge[0] == eventIdx) {
                int targetIdx = locEdge[1];
                if (locIdx == targetIdx) {
                    edges.add(aut.monitorEdge);
                } else {
                    edges.add(new RuntimeSimpleEdge<S>(aut, locEdge[1]));
                }
            }
            ++n2;
        }
        if (edges.isEmpty() && aut.monitorData[eventIdx]) {
            edges.add(aut.monitorEdge);
        }
    }

    protected abstract void updateLocPointerValue(S var1, int var2);
}

