/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers;

import java.util.Objects;
import org.eclipse.escet.cif.checkers.CifCheckViolationContext;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifCheckViolation {
    private final PositionObject reportObject;
    private final String message;
    private final String specLine;

    public CifCheckViolation(PositionObject reportObject, String message, String specLine) {
        Assert.notNull((Object)reportObject);
        Assert.notNull((Object)reportObject.getPosition());
        Assert.notNull((Object)message);
        Assert.areEqual((Object)(reportObject instanceof Specification), (Object)(specLine == null ? 1 : 0));
        this.reportObject = reportObject;
        this.message = message;
        this.specLine = specLine;
    }

    public PositionObject getReportObject() {
        return this.reportObject;
    }

    public CifCheckViolationContext getContext() {
        boolean entireSpec = this.reportObject instanceof Specification;
        PositionObject contextObject = entireSpec ? null : CifTextUtils.getNamedAncestor((PositionObject)this.reportObject);
        return new CifCheckViolationContext(entireSpec, contextObject);
    }

    public String getMessage() {
        return this.message;
    }

    public String getSpecLine() {
        return this.specLine;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CifCheckViolation)) {
            return false;
        }
        CifCheckViolation that = (CifCheckViolation)obj;
        return this.reportObject == that.reportObject && this.message.equals(that.message);
    }

    public int hashCode() {
        return Objects.hash(this.reportObject, this.message);
    }

    public String toString() {
        Position position = this.reportObject.getPosition();
        String positionText = PositionUtils.pos2str((Position)position);
        return Strings.fmt((String)"%s: %s.", (Object[])new Object[]{positionText, this.message});
    }
}

