/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.typeinfos;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;

public class TypeInfoHelper {
    private TypeInfoHelper() {
    }

    public static ExprCode convertBinaryExpressionPattern(BinaryExpression expr, String target, Destination dest, CodeContext ctxt) {
        ExprCode leftCode = ctxt.exprToTarget(expr.getLeft(), null);
        ExprCode rightCode = ctxt.exprToTarget(expr.getRight(), null);
        return TypeInfoHelper.convertBinaryExpressionPattern(leftCode, rightCode, target, dest, ctxt);
    }

    public static ExprCode convertBinaryExpressionPattern(ExprCode leftCode, ExprCode rightCode, String target, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.add(leftCode);
        result.add(rightCode);
        target = TypeInfoHelper.convertBinaryExpressionValues(leftCode.getRawDataValue(), rightCode.getRawDataValue(), target);
        result.setDestination(dest);
        result.setDataValue(ctxt.makeDataValue(target));
        return result;
    }

    public static String convertBinaryExpressionValues(DataValue leftValue, DataValue rightValue, String template) {
        template = TypeInfoHelper.tryReplaceValue(template, "${left-value}", leftValue);
        template = TypeInfoHelper.tryReplaceValue(template, "${right-value}", rightValue);
        template = TypeInfoHelper.tryReplaceReference(template, "${left-ref}", leftValue);
        template = TypeInfoHelper.tryReplaceReference(template, "${right-ref}", rightValue);
        return template;
    }

    private static String tryReplaceValue(String target, String pattern, DataValue value) {
        if (target.contains(pattern)) {
            return target.replace(pattern, value.getData());
        }
        return target;
    }

    private static String tryReplaceReference(String target, String pattern, DataValue value) {
        if (target.contains(pattern)) {
            return target.replace(pattern, value.getReference());
        }
        return target;
    }

    public static ExprCode convertFunctionCallPattern(String pattern, List<Expression> args, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        StringBuilder argsList = new StringBuilder();
        boolean first = true;
        for (Expression arg : args) {
            ExprCode argCode = ctxt.exprToTarget(arg, null);
            result.add(argCode);
            if (!first) {
                argsList.append(", ");
            }
            first = false;
            argsList.append(argCode.getData());
        }
        pattern = pattern.replace("${args}", argsList.toString());
        result.setDestination(dest);
        result.setDataValue(ctxt.makeDataValue(pattern));
        return result;
    }
}

