/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;

public class HistoryStore {
    private IDialogSettings settingsManager;
    private int historySize;
    private List<String> history;
    private String sectionName;

    public HistoryStore(IDialogSettings settingsManager, String sectionName, int historySize) {
        this.settingsManager = settingsManager;
        this.historySize = historySize;
        this.loadSection(sectionName);
    }

    public Iterable<String> get() {
        return this.history;
    }

    public String get(int index) {
        return this.history.get(index);
    }

    public void add(String historyItem) {
        if (this.sectionName == null) {
            throw new IllegalStateException("No section loaded");
        }
        if (historyItem != null && !historyItem.isEmpty()) {
            this.history.add(0, historyItem);
        }
        this.writeHistory();
    }

    public void remove(String historyItem) {
        int indexInHistory = this.history.indexOf(historyItem);
        if (indexInHistory >= 0) {
            this.history.remove(indexInHistory);
        }
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    private void loadSection(String newSectionName) {
        this.sectionName = newSectionName;
        this.history = new ArrayList<String>();
        String[] newHistoryEntries = this.settingsManager.getArray(newSectionName);
        if (newHistoryEntries != null) {
            this.history.addAll(Arrays.asList(newHistoryEntries));
        }
    }

    private void writeHistory() {
        int itemCount = this.history.size();
        HashSet<String> distinctItems = new HashSet<String>(itemCount);
        int i = 0;
        while (i < itemCount) {
            String item = this.history.get(i);
            if (distinctItems.contains(item)) {
                this.history.remove(i--);
                --itemCount;
            } else {
                distinctItems.add(item);
            }
            ++i;
        }
        while (this.history.size() > this.historySize) {
            this.history.remove(this.historySize);
        }
        String[] names = new String[this.history.size()];
        this.history.toArray(names);
        this.settingsManager.put(this.sectionName, names);
    }

    public int indexOf(String entry) {
        return this.history.indexOf(entry);
    }

    public int size() {
        return this.history.size();
    }
}

