/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.seq;

import java.util.List;
import org.eclipse.escet.chi.codegen.statements.seq.Seq;
import org.eclipse.escet.chi.codegen.statements.seq.SeqList;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SeqSelect
extends Seq {
    public final List<SelectAlternative> alternatives;

    public SeqSelect(List<SelectAlternative> alternatives, PositionObject stat) {
        super(stat);
        this.alternatives = alternatives;
    }

    @Override
    public Box boxify() {
        VBox vb = new VBox(0);
        for (SelectAlternative sa : this.alternatives) {
            for (Seq seq : sa.createCode) {
                vb.add(seq.boxify());
            }
        }
        vb.add("choice = sim->selectAlternative(selectList);");
        vb.add("switch (choice) {");
        for (SelectAlternative sa : this.alternatives) {
            VBox caseText = new VBox(4);
            caseText.add(Strings.fmt((String)"case %d:", (Object[])new Object[]{sa.number}));
            VBox child = new VBox(4);
            if (sa.code != null) {
                child.add(sa.code.boxify());
            }
            child.add("break;");
            caseText.add((Box)child);
            vb.add((Box)caseText);
        }
        vb.add("}");
        return vb;
    }

    public static class SelectAlternative {
        public final int number;
        public final List<Seq> createCode;
        public final SeqList code;
        public final List<VariableDeclaration> varParms;

        public SelectAlternative(int number, List<Seq> createCode, SeqList code, List<VariableDeclaration> varParms) {
            this.number = number;
            this.createCode = createCode;
            this.code = code;
            this.varParms = varParms;
        }
    }
}

