/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.Constants;
import org.eclipse.escet.chi.codegen.expressions.CodeExpression;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.types.PrimitiveTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.RealNumber;
import org.eclipse.escet.chi.metamodel.chi.TimeLiteral;
import org.eclipse.escet.chi.metamodel.chi.UnaryExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class RealTypeID
extends PrimitiveTypeID {
    public RealTypeID() {
        super(TypeID.TypeKind.REAL);
    }

    @Override
    public String getTypeText() {
        return "real";
    }

    @Override
    public String getJavaType() {
        return "double";
    }

    @Override
    public String getJavaClassType() {
        return "Double";
    }

    @Override
    public String getStaticReadFuncName() {
        return "org.eclipse.escet.chi.runtime.IoFunctions.readReal";
    }

    @Override
    public String getWriteName(String stream, String val, JavaFile jf) {
        Assert.check((boolean)this.isPrintable());
        jf.addImport("org.eclipse.escet.chi.runtime.IoFunctions.writeReal", true);
        return Strings.fmt((String)"%s(%s, %s);", (Object[])new Object[]{Constants.getClassname("org.eclipse.escet.chi.runtime.IoFunctions.writeReal"), stream, val});
    }

    @Override
    public String getToString(String val, JavaFile jf) {
        return Strings.fmt((String)"String.valueOf(%s)", (Object[])new Object[]{val});
    }

    @Override
    public String getHashCodeName(String val, JavaFile jf) {
        return "(int)Double.doubleToLongBits(" + val + ")";
    }

    @Override
    public String getEmptyValue(JavaFile jf) {
        return "0.0";
    }

    @Override
    public String getSimplestJavaValue() {
        return "0.0";
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        if (expr instanceof RealNumber) {
            RealNumber num = (RealNumber)expr;
            String text = Double.valueOf(num.getValue()).toString();
            return new SimpleExpression(text, (PositionObject)num);
        }
        if (expr instanceof TimeLiteral) {
            return new SimpleExpression("chiCoordinator.getCurrentTime()", (PositionObject)expr);
        }
        if (expr instanceof BinaryExpression) {
            String text;
            BinaryExpression binexpr = (BinaryExpression)expr;
            ExpressionBase left = ExpressionBase.convertExpression(binexpr.getLeft(), ctxt, currentFile);
            ExpressionBase right = ExpressionBase.convertExpression(binexpr.getRight(), ctxt, currentFile);
            String lv = left.getValue();
            String rv = right.getValue();
            switch (binexpr.getOp()) {
                case ADDITION: {
                    text = Strings.fmt((String)"(%s) + (%s)", (Object[])new Object[]{lv, rv});
                    break;
                }
                case DIVISION: {
                    TypeID ltid = TypeIDCreation.createTypeID(binexpr.getLeft().getType(), ctxt);
                    String lcast = ltid.kind != TypeID.TypeKind.REAL ? "(double)" : "";
                    TypeID rtid = TypeIDCreation.createTypeID(binexpr.getRight().getType(), ctxt);
                    String rcast = rtid.kind != TypeID.TypeKind.REAL ? "(double)" : "";
                    text = Strings.fmt((String)"(%s%s) / (%s%s)", (Object[])new Object[]{lcast, lv, rcast, rv});
                    break;
                }
                case MULTIPLICATION: {
                    text = Strings.fmt((String)"(%s) * (%s)", (Object[])new Object[]{lv, rv});
                    break;
                }
                case POWER: {
                    TypeID rtid = TypeIDCreation.createTypeID(binexpr.getRight().getType(), ctxt);
                    if (rtid.kind == TypeID.TypeKind.INT) {
                        String s = "org.eclipse.escet.chi.runtime.ArithmeticFunctions.intPower";
                        currentFile.addImport(s, true);
                        text = Strings.fmt((String)"intPower(%s, %s)", (Object[])new Object[]{lv, rv});
                        break;
                    }
                    currentFile.addImport("java.lang.Math.pow", true);
                    text = Strings.fmt((String)"Math.pow(%s, %s)", (Object[])new Object[]{lv, rv});
                    break;
                }
                case SUBTRACTION: {
                    text = Strings.fmt((String)"(%s) - (%s)", (Object[])new Object[]{lv, rv});
                    break;
                }
                default: {
                    Assert.fail((Object)("Unexpected binary operator " + binexpr.getOp().toString() + " in RealTypeID.convertExprNode"));
                    return null;
                }
            }
            if (!left.getCode().isEmpty() || !right.getCode().isEmpty()) {
                List lines = Lists.list();
                lines.addAll(left.getCode());
                lines.addAll(right.getCode());
                return new CodeExpression(lines, text, (PositionObject)expr);
            }
            return new SimpleExpression(text, (PositionObject)expr);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression unexpr = (UnaryExpression)expr;
            switch (unexpr.getOp()) {
                case NEGATE: {
                    Expression child = unexpr.getChild();
                    ExpressionBase chExpr = ExpressionBase.convertExpression(child, ctxt, currentFile);
                    return ExpressionBase.makeExpression(chExpr.getCode(), "-(" + chExpr.getValue() + ")", (PositionObject)expr);
                }
                case PLUS: {
                    return ExpressionBase.convertExpression(unexpr.getChild(), ctxt, currentFile);
                }
            }
            Assert.fail((Object)("Unexpected unary operator " + unexpr.getOp().toString() + " in RealTypeID.convertExprNode"));
            return null;
        }
        Assert.fail((Object)("Unexpected expression in convertExprNode(" + expr.toString() + "): kind=" + this.kind.toString()));
        return null;
    }
}

