/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.types.PlcArrayType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructField;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.common.java.Strings;

public class PlcVarExpression
extends PlcExpression {
    public final PlcBasicVariable variable;
    public final List<PlcProjection> projections;

    public PlcVarExpression(PlcBasicVariable variable, PlcProjection ... projections) {
        this(variable, Arrays.asList(projections));
    }

    public PlcVarExpression(PlcBasicVariable variable, List<PlcProjection> projections) {
        super(PlcVarExpression.computeType(variable.type, projections));
        this.variable = variable;
        this.projections = Collections.unmodifiableList(projections);
    }

    private static PlcType computeType(PlcType resultType, List<PlcProjection> projections) {
        for (PlcProjection proj : projections) {
            resultType = proj.getProjectedType(resultType);
        }
        return resultType;
    }

    @Override
    public String toString() {
        String s = this.projections.stream().map(p -> p.toString()).collect(Collectors.joining());
        return "PlcVarExpression(\"" + this.variable.varName + "\"" + s + ")";
    }

    public static class PlcArrayProjection
    extends PlcProjection {
        public final PlcExpression indexExpression;

        public PlcArrayProjection(PlcExpression indexExpression) {
            this.indexExpression = indexExpression;
        }

        @Override
        public PlcType getProjectedType(PlcType unprojectedType) {
            if (unprojectedType instanceof PlcArrayType) {
                PlcArrayType arayType = (PlcArrayType)unprojectedType;
                return arayType.elemType;
            }
            throw new AssertionError((Object)("Cannot compute projection on non-array type \"" + String.valueOf(unprojectedType) + "\"."));
        }

        @Override
        public String toString() {
            return "[" + this.indexExpression.toString() + "]";
        }
    }

    public static abstract class PlcProjection {
        protected abstract PlcType getProjectedType(PlcType var1);

        public abstract String toString();
    }

    public static class PlcStructProjection
    extends PlcProjection {
        public final String fieldName;

        public PlcStructProjection(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public PlcType getProjectedType(PlcType unprojectedType) {
            if (unprojectedType instanceof PlcStructType) {
                PlcStructType structType = (PlcStructType)unprojectedType;
                for (PlcStructField field : structType.fields) {
                    if (!field.fieldName.equals(this.fieldName)) continue;
                    return field.type;
                }
                throw new AssertionError((Object)Strings.fmt((String)"Struct type \"%s\" has no field \"%s\".", (Object[])new Object[]{structType.getName(), this.fieldName}));
            }
            throw new AssertionError((Object)("Cannot compute projection on non-struct type \"" + String.valueOf(unprojectedType) + "\"."));
        }

        @Override
        public String toString() {
            return ".\"" + this.fieldName + "\"";
        }
    }
}

