/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.properties;

import java.io.File;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.InvalidTemplateParameterException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;
import org.eclipse.gendoc.tags.handlers.IPropertiesService;
import org.eclipse.gendoc.tags.handlers.impl.AbstractServicesTagHandler;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;

public class PropertiesTagHandler
extends AbstractServicesTagHandler {
    @Override
    public String doRun(ITag tag) throws GenDocException {
        super.doRun(tag);
        return "";
    }

    @Override
    protected String runAttributes(ITag tag, String value) throws GenDocException {
        super.runAttributes(tag, value);
        IPropertiesService propertiesService = (IPropertiesService)GendocServices.getDefault().getService(IPropertiesService.class);
        for (String key : tag.getAttributes().keySet()) {
            if (!RegisteredTags.PROPERTIES_PATH.equalsIgnoreCase(key)) continue;
            String path = this.replaceParameters((String)tag.getAttributes().get(key));
            File f = new File(path.replaceAll("\\\\", "/"));
            if (!f.exists()) {
                IGendocDiagnostician logger = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                logger.addDiagnostic(4, "file containing properties : " + path + " does not exist", null);
                continue;
            }
            propertiesService.setPropertiesFile(f);
        }
        return value;
    }

    private String replaceParameters(String path) throws InvalidTemplateParameterException {
        IConfigurationService configService = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
        return configService.replaceParameters(path);
    }
}

