/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.ActionManager;
import org.eclipse.gmf.runtime.common.ui.action.IActionWithProgress;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractActionDelegate
implements IPartListener,
IActionWithProgress {
    private boolean setup;
    private IAction action = null;
    private IWorkbenchPart workbenchPart = null;
    private IWorkbenchWindow workbenchWindow = null;

    protected AbstractActionDelegate() {
        this.setSetup(false);
    }

    protected final IAction getAction() {
        return this.action;
    }

    protected final void setAction(IAction action) {
        this.action = action;
    }

    protected final IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    protected final void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        this.workbenchPart = workbenchPart;
    }

    protected final IWorkbenchWindow getWorkbenchWindow() {
        return this.workbenchWindow;
    }

    protected final void setWorkbenchWindow(IWorkbenchWindow workbenchWindow) {
        this.workbenchWindow = workbenchWindow;
    }

    protected ActionManager getActionManager() {
        ActionManager manager;
        IWorkbenchPart wbp = this.getWorkbenchPart();
        if (wbp != null && (manager = (ActionManager)wbp.getAdapter(ActionManager.class)) != null) {
            return manager;
        }
        return ActionManager.getDefault();
    }

    protected IOperationHistory getOperationHistory() {
        return this.getActionManager().getOperationHistory();
    }

    protected ISelection getSelection() {
        ISelectionProvider selectionProvider;
        IWorkbenchPartSite wbps;
        ISelection selection = null;
        IWorkbenchPart wbp = this.getWorkbenchPart();
        if (wbp != null && (wbps = wbp.getSite()) != null && (selectionProvider = wbps.getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) != null) {
            return selection;
        }
        return StructuredSelection.EMPTY;
    }

    protected IStructuredSelection getStructuredSelection() {
        ISelectionProvider selectionProvider;
        IStructuredSelection selection = null;
        IWorkbenchPart wbp = this.getWorkbenchPart();
        if (wbp != null && (selectionProvider = wbp.getSite().getSelectionProvider()) != null && selectionProvider.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)selectionProvider.getSelection()) != null) {
            return selection;
        }
        return StructuredSelection.EMPTY;
    }

    public void run(IAction act) {
        this.getActionManager().run(this);
    }

    public void selectionChanged(IAction act, ISelection selection) {
        this.setAction(act);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setAction(action);
        this.setWorkbenchPart((IWorkbenchPart)targetEditor);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setAction(action);
        this.setWorkbenchPart(targetPart);
    }

    public void partActivated(IWorkbenchPart part) {
        this.setWorkbenchPart(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (this.getWorkbenchPart() == part) {
            this.setWorkbenchPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void init(IViewPart view) {
        this.setWorkbenchPart((IWorkbenchPart)view);
    }

    public void dispose() {
        if (this.getWorkbenchWindow() != null) {
            this.getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        }
        this.setWorkbenchPart(null);
        this.setWorkbenchWindow(null);
        this.setAction(null);
    }

    public void init(IWorkbenchWindow window) {
        this.setWorkbenchWindow(window);
        if (window.getActivePage() != null) {
            this.setWorkbenchPart(window.getActivePage().getActivePart());
        }
        window.getPartService().addPartListener((IPartListener)this);
    }

    public String getLabel() {
        return this.getAction().getText();
    }

    public boolean isRunnable() {
        return this.getAction().isEnabled();
    }

    public void refresh() {
    }

    public void run(IProgressMonitor progressMonitor) {
        if (this.isSetup() || !this.needsSetup()) {
            try {
                this.doRun(progressMonitor);
            }
            catch (Exception e) {
                this.handle(e);
            }
        } else {
            throw new IllegalStateException("action must be setup before it is run");
        }
        this.setSetup(false);
    }

    protected boolean needsSetup() {
        return false;
    }

    protected void handle(Exception exception) {
        Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"handle", (Throwable)exception);
        Status status = new Status(4, CommonUIPlugin.getPluginId(), 3, String.valueOf(exception.getMessage()), (Throwable)exception);
        Log.log((Plugin)CommonUIPlugin.getDefault(), (IStatus)status);
        this.openErrorDialog((IStatus)status);
    }

    protected void openErrorDialog(final IStatus status) {
        final Display display = DisplayUtils.getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            ErrorDialog.openError((Shell)display.getActiveShell(), (String)Action.removeMnemonics((String)this.getLabel()), null, (IStatus)status);
        } else {
            display.asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)display.getActiveShell(), (String)Action.removeMnemonics((String)AbstractActionDelegate.this.getLabel()), null, (IStatus)status);
                }
            });
        }
    }

    protected abstract void doRun(IProgressMonitor var1);

    public IActionWithProgress.WorkIndicatorType getWorkIndicatorType() {
        return IActionWithProgress.WorkIndicatorType.BUSY;
    }

    public boolean setup() {
        this.setSetup(true);
        return true;
    }

    public boolean isSetup() {
        return this.setup;
    }

    protected void setSetup(boolean setup) {
        this.setup = setup;
    }

    public void init(IAction anAction) {
        this.setAction(anAction);
    }

    public void runWithEvent(IAction anAction, Event event) {
        this.run(anAction);
    }
}

