/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs;

import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.DialogBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.JPSOptionsDialog;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintDestination;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

class PrinterBlock
extends DialogBlock {
    private final DataBindingContext bindings;
    private final PrintOptions options;
    private List<PrintDestination> destinations = new ArrayList<PrintDestination>();
    private ComboViewer combo;

    PrinterBlock(DialogBlock.IDialogUnitConverter dluConverter, DataBindingContext bindings, PrintOptions options) {
        super(dluConverter);
        this.bindings = bindings;
        this.options = options;
    }

    public Control createContents(Composite parent) {
        Realm realm = this.bindings.getValidationRealm();
        Group result = this.group(parent, DiagramUIPrintingMessages.JPSPrintDialog_Printer);
        PrinterBlock.layout((Composite)result, 3);
        this.label((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_Name);
        this.combo = this.combo((Composite)result);
        this.layoutFillHorizontal(this.combo.getControl());
        Button propertiesButton = this.button((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_Properties);
        propertiesButton.setEnabled(true);
        propertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrinterBlock.this.openPrintOptionsDialog();
            }
        });
        IObservableValue destination = BeansObservables.observeValue((Realm)realm, (Object)this.options, (String)PrintOptions.PROPERTY_DESTINATION);
        this.bindings.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.combo), destination, null, null);
        this.initializePrinters();
        return result;
    }

    private void initializePrinters() {
        PrintService[] printServices;
        PrintService[] printServiceArray = printServices = PrintServiceLookup.lookupPrintServices(null, null);
        int n = printServices.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService printService = printServiceArray[n2];
            this.destinations.add(new PrintDestination(printService.getName()));
            ++n2;
        }
        this.combo.setContentProvider((IContentProvider)new PrinterContentProvider());
        this.combo.setLabelProvider((IBaseLabelProvider)new PrinterLabelProvider());
        PrintDestination defaultPrintDestination = null;
        PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
        if (defaultPrintService != null) {
            defaultPrintDestination = this.getPrinterByName(defaultPrintService.getName());
        } else if (this.destinations.size() > 0) {
            defaultPrintDestination = this.destinations.get(0);
        }
        this.combo.setInput(this.destinations);
        if (defaultPrintDestination != null) {
            this.combo.setSelection((ISelection)new StructuredSelection((Object)defaultPrintDestination));
        }
    }

    private PrintDestination getPrinterByName(String name) {
        PrintDestination result = null;
        for (PrintDestination printDestination : this.destinations) {
            if (!printDestination.getName().equals(name)) continue;
            result = printDestination;
            break;
        }
        return result;
    }

    private void openPrintOptionsDialog() {
        JPSOptionsDialog dlg = new JPSOptionsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.bindings, this.options);
        dlg.open();
    }

    public void dispose() {
    }

    private class PrinterContentProvider
    implements IStructuredContentProvider {
        private PrinterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PrinterBlock.this.destinations.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class PrinterLabelProvider
    extends LabelProvider {
        private PrinterLabelProvider() {
        }

        public String getText(Object element) {
            return ((PrintDestination)element).getName();
        }
    }
}

