/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.ui.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.AndGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Circuit;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.FlowContainer;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.OrGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticPackage;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.XORGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.util.LogicSemanticType;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TreeContainerEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TreeDiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TreeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.editor.FileDiagramEditorWithFlyoutPalette;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class LogicNotationEditor
extends FileDiagramEditorWithFlyoutPalette {
    private static final String EDITING_DOMAIN_ID = "org.eclipse.gmf.examples.runtime.diagram.logicEditingDomain";
    private static final List SUPPORTED_DRAG_DROP_ECLASSES = new ArrayList();

    static {
        SUPPORTED_DRAG_DROP_ECLASSES.add(SemanticPackage.eINSTANCE.getLED());
        SUPPORTED_DRAG_DROP_ECLASSES.add(SemanticPackage.eINSTANCE.getAndGate());
        SUPPORTED_DRAG_DROP_ECLASSES.add(SemanticPackage.eINSTANCE.getOrGate());
        SUPPORTED_DRAG_DROP_ECLASSES.add(SemanticPackage.eINSTANCE.getXORGate());
        SUPPORTED_DRAG_DROP_ECLASSES.add(SemanticPackage.eINSTANCE.getCircuit());
    }

    protected String getEditingDomainID() {
        return EDITING_DOMAIN_ID;
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new DiagramDropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer(), (Transfer)LocalTransfer.getInstance()){

            protected List getObjectsBeingDropped() {
                TransferData[] data = this.getCurrentEvent().dataTypes;
                ArrayList eObjects = new ArrayList();
                int i = 0;
                while (i < data.length) {
                    if (LocalTransfer.getInstance().isSupportedType(data[i])) {
                        IStructuredSelection selection = (IStructuredSelection)LocalTransfer.getInstance().nativeToJava(data[i]);
                        eObjects.addAll(selection.toList());
                    }
                    ++i;
                }
                return eObjects;
            }

            public boolean isEnabled(DropTargetEvent event) {
                Object modelObj;
                if (super.isEnabled(event) && (modelObj = this.getViewer().getContents().getModel()) instanceof EObject) {
                    List eObjects = this.getDropObjectsRequest().getObjects();
                    if (eObjects == null) {
                        return false;
                    }
                    for (Object o : eObjects) {
                        if (!(o instanceof EObject)) {
                            return false;
                        }
                        if (SUPPORTED_DRAG_DROP_ECLASSES.contains(((EObject)o).eClass())) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    protected EditPartFactory getOutlineViewEditPartFactory() {
        return new EditPartFactory(){

            public EditPart createEditPart(EditPart context, Object model) {
                if (model instanceof Diagram) {
                    return new TreeDiagramEditPart(model);
                }
                if (model instanceof View && ViewType.GROUP.equals(((View)model).getType())) {
                    return new TreeContainerEditPart(model);
                }
                return new TreeEditPart(model){

                    protected String getText() {
                        EObject element = ((View)this.getModel()).getElement();
                        if (element != null) {
                            if (element instanceof LED) {
                                return LogicSemanticType.LED.getDisplayName();
                            }
                            if (element instanceof Circuit) {
                                return LogicSemanticType.CIRCUIT.getDisplayName();
                            }
                            if (element instanceof FlowContainer) {
                                return LogicSemanticType.FLOWCONTAINER.getDisplayName();
                            }
                            if (element instanceof AndGate) {
                                return LogicSemanticType.ANDGATE.getDisplayName();
                            }
                            if (element instanceof OrGate) {
                                return LogicSemanticType.ORGATE.getDisplayName();
                            }
                            if (element instanceof XORGate) {
                                return LogicSemanticType.XORGATE.getDisplayName();
                            }
                        }
                        return super.getText();
                    }
                };
            }
        };
    }
}

