/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.adapter;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.adapter.DefaultContentAdapter;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.ICorrespondingElementProvider;
import org.eclipse.handly.model.impl.support.SimpleElement;

public class DefaultContentAdapterTest
extends TestCase {
    private IContentAdapter adapter = DefaultContentAdapter.INSTANCE;

    protected void setUp() throws Exception {
        super.setUp();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)AdapterFactory.INSTANCE, IntWrapper.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)AdapterFactory.INSTANCE, TestElement.class);
    }

    protected void tearDown() throws Exception {
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)AdapterFactory.INSTANCE);
        super.tearDown();
    }

    public void test1() {
        IntWrapper o = new IntWrapper(333);
        DefaultContentAdapterTest.assertEquals((Object)((Object)o), (Object)this.adapter.getCorrespondingElement(this.adapter.adapt((Object)o)));
    }

    public void test2() {
        TestElement e = new TestElement(777);
        DefaultContentAdapterTest.assertEquals((Object)((Object)e), (Object)this.adapter.adapt(this.adapter.getCorrespondingElement((IElement)e)));
    }

    private static class AdapterFactory
    implements IAdapterFactory,
    ICorrespondingElementProvider {
        static final AdapterFactory INSTANCE = new AdapterFactory();
        private static final Class<?>[] ADAPTER_LIST = new Class[]{IElement.class, ICorrespondingElementProvider.class};

        private AdapterFactory() {
        }

        public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
            if (adapterType == ICorrespondingElementProvider.class) {
                return (T)this;
            }
            if (adaptableObject instanceof IntWrapper && adapterType == IElement.class) {
                return (T)((Object)new TestElement(((IntWrapper)((Object)adaptableObject)).i));
            }
            return null;
        }

        public Class<?>[] getAdapterList() {
            return ADAPTER_LIST;
        }

        public IAdaptable getCorrespondingElement(IElement element) {
            if (element instanceof TestElement) {
                return new IntWrapper(Integer.valueOf(((TestElement)element).getName_()));
            }
            return null;
        }
    }

    private static class IntWrapper
    extends PlatformObject {
        final int i;

        IntWrapper(int i) {
            this.i = i;
        }

        public int hashCode() {
            return this.i;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            return this.i == ((IntWrapper)((Object)obj)).i;
        }

        public String toString() {
            return "IntWrapper: " + this.i;
        }
    }

    private static class TestElement
    extends SimpleElement {
        TestElement(int i) {
            super(null, Integer.toString(i), null);
        }
    }
}

