/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import jakarta.validation.Configuration;
import jakarta.validation.Validation;
import jakarta.validation.ValidationProviderResolver;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.bootstrap.GenericBootstrap;
import jakarta.validation.bootstrap.ProviderSpecificBootstrap;
import jakarta.validation.spi.ValidationProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.beanvalidation.tck.common.TCKValidationProvider;
import org.hibernate.beanvalidation.tck.common.TCKValidatorConfiguration;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ValidationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ValidationTest.webArchiveBuilder().withTestClass(ValidationTest.class)).withClasses(TCKValidationProvider.class, TCKValidatorConfiguration.class)).build();
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-validation", id="a")
    public void testBuildDefaultValidatorFactory() {
        ValidatorFactory defaultFactory = Validation.buildDefaultValidatorFactory();
        Assert.assertNotNull((Object)defaultFactory, (String)"We should be able to get a factory.");
        ValidatorFactory defaultProviderFactory = Validation.byDefaultProvider().configure().buildValidatorFactory();
        Assert.assertNotNull((Object)defaultProviderFactory, (String)"We should be able to get a factory.");
        Assert.assertEquals((Object)defaultFactory.getClass(), (Object)defaultFactory.getClass(), (String)"The factories have to be identical.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-validation", id="b"), @SpecAssertion(section="validationapi-bootstrapping-validation", id="e")})
    public void testCustomValidationProviderResolution() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                ArrayList list = new ArrayList();
                list.add(new TCKValidationProvider());
                return list;
            }
        };
        GenericBootstrap bootstrap = Validation.byDefaultProvider();
        Configuration config = bootstrap.providerResolver(resolver).configure();
        ValidatorFactory factory = config.buildValidatorFactory();
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-validation", id="c"), @SpecAssertion(section="validationapi-bootstrapping-validation", id="e")})
    public void testSpecificValidationProvider() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                ArrayList list = new ArrayList();
                list.add(new TCKValidationProvider());
                return list;
            }
        };
        ProviderSpecificBootstrap bootstrap = Validation.byProvider(TCKValidationProvider.class);
        Configuration config = bootstrap.providerResolver(resolver).configure();
        ValidatorFactory factory = config.buildValidatorFactory();
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory));
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-validation", id="d")
    public void testVerifyMethodsOfValidationObjects() {
        Field[] validationFields;
        Method[] validationMethods;
        Class<Validation> validatorClass = Validation.class;
        ArrayList<Method> expectedValidationMethods = new ArrayList<Method>();
        Method buildDefaultValidatorFactoryMethod = null;
        try {
            buildDefaultValidatorFactoryMethod = validatorClass.getMethod("buildDefaultValidatorFactory", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)"Validation class is missing bootstrap method.");
        }
        expectedValidationMethods.add(buildDefaultValidatorFactoryMethod);
        Method byDefaultProviderMethod = null;
        try {
            byDefaultProviderMethod = validatorClass.getMethod("byDefaultProvider", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)"Validation class is missing bootstrap method.");
        }
        expectedValidationMethods.add(byDefaultProviderMethod);
        Method byProviderMethod = null;
        try {
            byProviderMethod = validatorClass.getMethod("byProvider", Class.class);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)"Validation class is missing bootstrap method.");
        }
        expectedValidationMethods.add(byProviderMethod);
        for (Method m : validationMethods = validatorClass.getMethods()) {
            if (expectedValidationMethods.contains(m) || m.getDeclaringClass() != validatorClass || !Modifier.isPublic(m.getModifiers()) && !Modifier.isProtected(m.getModifiers())) continue;
            Assert.fail((String)("Validation cannot have a non private method on top of the specified ones. " + m.getName() + " not allowed."));
        }
        for (Field f : validationFields = validatorClass.getFields()) {
            if (f.getDeclaringClass() != validatorClass || !Modifier.isPublic(f.getModifiers()) && !Modifier.isProtected(f.getModifiers())) continue;
            Assert.fail((String)("Validation cannot have a non private field. " + f.getName() + " not allowed."));
        }
    }
}

