/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util.annotated;

import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import org.jboss.cdi.tck.util.annotated.AnnotatedCallableWraper;
import org.jboss.cdi.tck.util.annotated.AnnotatedTypeWrapper;

public class AnnotatedConstructorWrapper<X>
extends AnnotatedCallableWraper<X>
implements AnnotatedConstructor<X> {
    private AnnotatedConstructor<X> delegate;
    private List<AnnotatedParameter<X>> parameters;

    public AnnotatedConstructorWrapper(AnnotatedConstructor<X> delegate, AnnotatedTypeWrapper<X> declaringType, boolean keepOriginalAnnotations, Annotation ... annotations) {
        super(delegate, declaringType, keepOriginalAnnotations, annotations);
        this.delegate = delegate;
        this.parameters = delegate.getParameters();
    }

    @Override
    public Constructor<X> getJavaMember() {
        return this.delegate.getJavaMember();
    }

    @Override
    public List<AnnotatedParameter<X>> getParameters() {
        return this.parameters;
    }

    @Override
    public AnnotatedTypeWrapper<X> getDeclaringType() {
        return super.getDeclaringType();
    }

    @Override
    public boolean isStatic() {
        return this.delegate.isStatic();
    }

    @Override
    public AnnotatedConstructorWrapper<X> replaceParameters(AnnotatedParameter<X> ... parameters) {
        this.parameters = Arrays.asList(parameters);
        return this;
    }

    public AnnotatedParameter<X> getParameter(int position) {
        for (AnnotatedParameter<X> parameter : this.parameters) {
            if (parameter.getPosition() != position) continue;
            return parameter;
        }
        return null;
    }
}

