/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.api.jakarta.websocket.clientendpointconfig;

import com.sun.ts.tests.websocket.api.jakarta.websocket.clientendpointconfig.TCKConfigurator;
import com.sun.ts.tests.websocket.common.TCKExtension;
import com.sun.ts.tests.websocket.common.util.BooleanDecoder;
import com.sun.ts.tests.websocket.common.util.BooleanEncoder;
import com.sun.ts.tests.websocket.common.util.ByteDecoder;
import com.sun.ts.tests.websocket.common.util.ErrorEncoder;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Test;

public class WSClientIT {
    private static final System.Logger logger = System.getLogger(WSClientIT.class.getName());

    @Test
    public void constructortest() throws Exception {
        boolean passed = true;
        try {
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().build();
            List tmp = dcc.getDecoders();
            if (tmp != null) {
                logger.log(System.Logger.Level.TRACE, "getDecoders() return non-null List");
                if (!tmp.isEmpty()) {
                    logger.log(System.Logger.Level.ERROR, "getDecoders() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = dcc.getEncoders()) != null) {
                logger.log(System.Logger.Level.TRACE, "getEncoders() return non-null List");
                if (!tmp.isEmpty()) {
                    logger.log(System.Logger.Level.ERROR, "getEncoders() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = dcc.getExtensions()) != null) {
                logger.log(System.Logger.Level.TRACE, "getExtensions() return non-null List");
                if (!tmp.isEmpty()) {
                    logger.log(System.Logger.Level.ERROR, "getExtensions() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = dcc.getPreferredSubprotocols()) != null) {
                logger.log(System.Logger.Level.TRACE, "getPreferredSubprotocols() return non-null List");
                if (!tmp.isEmpty()) {
                    logger.log(System.Logger.Level.ERROR, "getPreferredSubprotocols() return non-empty List with size " + tmp.size() + "|");
                    passed = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, e.getMessage());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    @Test
    public void preferredSubprotocolsTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        try {
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().preferredSubprotocols(expected_subprotocols).build();
            List tmp = dcc.getPreferredSubprotocols();
            if (tmp != null) {
                log.append("getPreferredSubprotocols() return non-null List|");
                if (!tmp.isEmpty()) {
                    log.append("getPreferredSubprotocols() return non-empty List with size " + tmp.size() + "|");
                    int size_actual = tmp.size();
                    if (size_actual == expected_subprotocols.size()) {
                        for (String subpro : tmp) {
                            if (expected_subprotocols.contains(subpro)) {
                                log.append("sub protocol " + subpro + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("sub protocol " + subpro + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getPreferredSubprotocols() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size_actual);
                    }
                } else {
                    log.append("getPreferredSubprotocols() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getPreferredSubprotocols() return null list");
            }
        }
        catch (Exception e) {
            System.err.print(e.getMessage() + log.toString());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void extensionsTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List<Extension.Parameter>)extension1));
        extensions.add(new TCKExtension("ext2", (List<Extension.Parameter>)extension2));
        try {
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().extensions(extensions).build();
            List tmp = dcc.getExtensions();
            if (tmp != null) {
                log.append("getExtensions() return non-null List|");
                if (!tmp.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmp.size() + "|");
                    int size_actual = tmp.size();
                    if (size_actual == extensions.size()) {
                        for (Extension ext : tmp) {
                            if (extensions.contains(ext)) {
                                log.append("extension " + ext + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("extension " + ext + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getExtensions() returned not exactly the same amount of extensions.");
                        log.append("Expecting two, returned " + size_actual);
                    }
                } else {
                    log.append("getExtensions() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getExtensions() return null list|");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, e.getMessage() + log.toString());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void constructorTest1() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List<Extension.Parameter>)extension1));
        extensions.add(new TCKExtension("ext2", (List<Extension.Parameter>)extension2));
        try {
            int size_actual;
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().preferredSubprotocols(expected_subprotocols).extensions(extensions).build();
            List tmpe = dcc.getExtensions();
            List tmpp = dcc.getPreferredSubprotocols();
            if (tmpe != null) {
                log.append("getExtensions() return non-null List|");
                if (!tmpe.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmpe.size() + "|");
                    size_actual = tmpe.size();
                    if (size_actual == extensions.size()) {
                        for (Extension ext : tmpe) {
                            if (extensions.contains(ext)) {
                                log.append("extension " + ext + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("extension " + ext + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getExtensions() returned not exactly the same amount of extensions.");
                        log.append("Expecting two, returned " + size_actual);
                    }
                } else {
                    log.append("getExtensions() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getExtensions() return null list|");
            }
            if (tmpp != null) {
                log.append("getPreferredSubprotocols() return non-null List|");
                if (!tmpp.isEmpty()) {
                    log.append("getPreferredSubprotocols() return non-empty List with size " + tmpp.size() + "|");
                    size_actual = tmpp.size();
                    if (size_actual == expected_subprotocols.size()) {
                        for (String subpro : tmpp) {
                            if (expected_subprotocols.contains(subpro)) {
                                log.append("sub protocol " + subpro + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("sub protocol " + subpro + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getPreferredSubprotocols() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size_actual);
                    }
                } else {
                    log.append("getPreferredSubprotocols() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getPreferredSubprotocols() return null list");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, e.getMessage() + log.toString());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void encodersTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        ArrayList<Class> expected_encoders = new ArrayList<Class>();
        expected_encoders.add(ErrorEncoder.class);
        expected_encoders.add(BooleanEncoder.class);
        try {
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().encoders(expected_encoders).build();
            List tmp = dcc.getEncoders();
            if (tmp != null) {
                log.append("getEncoders() return non-null List");
                if (!tmp.isEmpty()) {
                    int size = tmp.size();
                    log.append("getEncoders() return non-empty List  with size " + size + "|");
                    if (size == 2) {
                        for (Class encoder : tmp) {
                            log.append("Encoder " + encoder + " found ");
                            if (expected_encoders.contains(encoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getEncoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getEncoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getEncoders() return null list");
            }
        }
        catch (Exception e) {
            System.err.print(log.toString());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void decodersTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        try {
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().decoders(expected_decoders).build();
            List tmp = dcc.getDecoders();
            if (tmp != null) {
                log.append("getDecoders() return non-null List|");
                if (!tmp.isEmpty()) {
                    int size = tmp.size();
                    log.append("getDecoders() return non-empty List  with size " + tmp.size() + "|");
                    if (size == 2) {
                        for (Class decoder : tmp) {
                            log.append("Decoder " + decoder + " found ");
                            if (expected_decoders.contains(decoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getDecoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getDecoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getDecoders() return null list|");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, e.getMessage() + log.toString());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void constructorTest2() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List<Extension.Parameter>)extension1));
        extensions.add(new TCKExtension("ext2", (List<Extension.Parameter>)extension2));
        try {
            int size_actual;
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().preferredSubprotocols(expected_subprotocols).extensions(extensions).decoders(expected_decoders).build();
            List tmpe = dcc.getExtensions();
            List tmpp = dcc.getPreferredSubprotocols();
            List tmpd = dcc.getDecoders();
            if (tmpe != null) {
                log.append("getExtensions() return non-null List|");
                if (!tmpe.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmpe.size() + "|");
                    size_actual = tmpe.size();
                    if (size_actual == extensions.size()) {
                        for (Extension ext : tmpe) {
                            if (extensions.contains(ext)) {
                                log.append("extension " + ext + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("extension " + ext + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getExtensions() returned not exactly the same amount of extensions.");
                        log.append("Expecting two, returned " + size_actual);
                    }
                } else {
                    log.append("getExtensions() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getExtensions() return null list|");
            }
            if (tmpp != null) {
                log.append("getPreferredSubprotocols() return non-null List|");
                if (!tmpp.isEmpty()) {
                    log.append("getPreferredSubprotocols() return non-empty List with size " + tmpp.size() + "|");
                    size_actual = tmpp.size();
                    if (size_actual == expected_subprotocols.size()) {
                        for (String subpro : tmpp) {
                            if (expected_subprotocols.contains(subpro)) {
                                log.append("sub protocol " + subpro + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("sub protocol " + subpro + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getPreferredSubprotocols() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size_actual);
                    }
                } else {
                    log.append("getPreferredSubprotocols() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getPreferredSubprotocols() return null list");
            }
            if (tmpd != null) {
                log.append("getDecoders() return non-null List|");
                if (!tmpd.isEmpty()) {
                    int size = tmpd.size();
                    log.append("getDecoders() return non-empty List  with size " + tmpd.size() + "|");
                    if (size == 2) {
                        for (Class decoder : tmpd) {
                            log.append("Decoder " + decoder + " found ");
                            if (expected_decoders.contains(decoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getDecoders() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size);
                    }
                } else {
                    log.append("getDecoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getDecoders() return null list|");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, e.getMessage() + log.toString());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void constructorTest3() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        ArrayList<Class> expected_encoders = new ArrayList<Class>();
        expected_encoders.add(ErrorEncoder.class);
        expected_encoders.add(BooleanEncoder.class);
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List<Extension.Parameter>)extension1));
        extensions.add(new TCKExtension("ext2", (List<Extension.Parameter>)extension2));
        try {
            int size_actual;
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().preferredSubprotocols(expected_subprotocols).extensions(extensions).decoders(expected_decoders).encoders(expected_encoders).build();
            List tmpe = dcc.getExtensions();
            List tmpp = dcc.getPreferredSubprotocols();
            List tmpd = dcc.getDecoders();
            if (tmpe != null) {
                log.append("getExtensions() return non-null List|");
                if (!tmpe.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmpe.size() + "|");
                    size_actual = tmpe.size();
                    if (size_actual == extensions.size()) {
                        for (Extension ext : tmpe) {
                            if (extensions.contains(ext)) {
                                log.append("extension " + ext + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("extension " + ext + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getExtensions() returned not exactly the same amount of extensions.");
                        log.append("Expecting two, returned " + size_actual);
                    }
                } else {
                    log.append("getExtensions() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getExtensions() return null list|");
            }
            if (tmpp != null) {
                log.append("getPreferredSubprotocols() return non-null List|");
                if (!tmpp.isEmpty()) {
                    log.append("getPreferredSubprotocols() return non-empty List with size " + tmpp.size() + "|");
                    size_actual = tmpp.size();
                    if (size_actual == expected_subprotocols.size()) {
                        for (String subpro : tmpp) {
                            if (expected_subprotocols.contains(subpro)) {
                                log.append("sub protocol " + subpro + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("sub protocol " + subpro + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getPreferredSubprotocols() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size_actual);
                    }
                } else {
                    log.append("getPreferredSubprotocols() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getPreferredSubprotocols() return null list");
            }
            if (tmpd != null) {
                log.append("getDecoders() return non-null List|");
                if (!tmpd.isEmpty()) {
                    int size = tmpd.size();
                    log.append("getDecoders() return non-empty List  with size " + tmpd.size() + "|");
                    if (size == 2) {
                        for (Class decoder : tmpd) {
                            log.append("Decoder " + decoder + " found ");
                            if (expected_decoders.contains(decoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getDecoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getDecoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getDecoders() return null list|");
            }
            List tmpen = dcc.getEncoders();
            if (tmpen != null) {
                log.append("getEncoders() return non-null List");
                if (!tmpen.isEmpty()) {
                    int size = tmpen.size();
                    log.append("getEncoders() return non-empty List  with size " + size + "|");
                    if (size == 2) {
                        for (Class encoder : tmpen) {
                            log.append("Encoder " + encoder + " found ");
                            if (expected_encoders.contains(encoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getEncoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getEncoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getEncoders() return null list");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, e.getMessage() + log.toString());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void configuratorTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        TCKConfigurator config = new TCKConfigurator();
        try {
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)config).build();
            ClientEndpointConfig.Configurator tmpc = dcc.getConfigurator();
            if (!tmpc.getClass().equals(TCKConfigurator.class)) {
                logger.log(System.Logger.Level.ERROR, "getConfigurator() returned a different Configurator: " + tmpc.getClass().getName());
                passed = false;
            }
        }
        catch (Exception e) {
            System.err.print(log.toString());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void constructorTest4() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        TCKConfigurator config = new TCKConfigurator();
        try {
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)config).build();
            List tmp = dcc.getDecoders();
            if (tmp != null) {
                logger.log(System.Logger.Level.TRACE, "getDecoders() return non-null List");
                if (!tmp.isEmpty()) {
                    logger.log(System.Logger.Level.ERROR, "getDecoders() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = dcc.getEncoders()) != null) {
                logger.log(System.Logger.Level.TRACE, "getEncoders() return non-null List");
                if (!tmp.isEmpty()) {
                    logger.log(System.Logger.Level.ERROR, "getEncoders() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = dcc.getExtensions()) != null) {
                logger.log(System.Logger.Level.TRACE, "getExtensions() return non-null List");
                if (!tmp.isEmpty()) {
                    logger.log(System.Logger.Level.ERROR, "getExtensions() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = dcc.getPreferredSubprotocols()) != null) {
                logger.log(System.Logger.Level.TRACE, "getPreferredSubprotocols() return non-null List");
                if (!tmp.isEmpty()) {
                    logger.log(System.Logger.Level.ERROR, "getPreferredSubprotocols() return non-empty List with size " + tmp.size() + "|");
                    passed = false;
                }
            }
        }
        catch (Exception e) {
            System.err.print(log.toString());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void constructorTest5() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        List<String> expected_subprotocols = Arrays.asList("JSON", "XML", "XMPP", "Hessian", "Quake", "PUB/SUB", "Query");
        ArrayList<Class> expected_encoders = new ArrayList<Class>();
        expected_encoders.add(ErrorEncoder.class);
        expected_encoders.add(BooleanEncoder.class);
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        TCKConfigurator config = new TCKConfigurator();
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List<Extension.Parameter>)extension1));
        extensions.add(new TCKExtension("ext2", (List<Extension.Parameter>)extension2));
        try {
            int size_actual;
            ClientEndpointConfig dcc = ClientEndpointConfig.Builder.create().preferredSubprotocols(expected_subprotocols).extensions(extensions).decoders(expected_decoders).encoders(expected_encoders).configurator((ClientEndpointConfig.Configurator)config).build();
            List tmpe = dcc.getExtensions();
            List tmpp = dcc.getPreferredSubprotocols();
            List tmpd = dcc.getDecoders();
            if (tmpe != null) {
                log.append("getExtensions() return non-null List|");
                if (!tmpe.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmpe.size() + "|");
                    size_actual = tmpe.size();
                    if (size_actual == extensions.size()) {
                        for (Extension ext : tmpe) {
                            if (extensions.contains(ext)) {
                                log.append("extension " + ext + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("extension " + ext + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getExtensions() returned not exactly the same amount of extensions.");
                        log.append("Expecting two, returned " + size_actual);
                    }
                } else {
                    log.append("getExtensions() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getExtensions() return null list|");
            }
            if (tmpp != null) {
                log.append("getPreferredSubprotocols() return non-null List|");
                if (!tmpp.isEmpty()) {
                    log.append("getPreferredSubprotocols() return non-empty List with size " + tmpp.size() + "|");
                    size_actual = tmpp.size();
                    if (size_actual == expected_subprotocols.size()) {
                        for (String subpro : tmpp) {
                            if (expected_subprotocols.contains(subpro)) {
                                log.append("sub protocol " + subpro + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("sub protocol " + subpro + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getPreferredSubprotocols() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size_actual);
                    }
                } else {
                    log.append("getPreferredSubprotocols() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getPreferredSubprotocols() return null list");
            }
            if (tmpd != null) {
                log.append("getDecoders() return non-null List|");
                if (!tmpd.isEmpty()) {
                    int size = tmpd.size();
                    log.append("getDecoders() return non-empty List  with size " + tmpd.size() + "|");
                    if (size == 2) {
                        for (Class decoder : tmpd) {
                            log.append("Decoder " + decoder + " found ");
                            if (expected_decoders.contains(decoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getDecoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getDecoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getDecoders() return null list|");
            }
            List tmpen = dcc.getEncoders();
            if (tmpen != null) {
                log.append("getEncoders() return non-null List");
                if (!tmpen.isEmpty()) {
                    int size = tmpen.size();
                    log.append("getEncoders() return non-empty List  with size " + size + "|");
                    if (size == 2) {
                        for (Class encoder : tmpen) {
                            log.append("Encoder " + encoder + " found ");
                            if (expected_encoders.contains(encoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getEncoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getEncoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getEncoders() return null list");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, e.getMessage() + log.toString());
            throw new Exception(e);
        }
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    public void cleanup() {
    }
}

