/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.server;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.server.WSCMsgServer;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -712294674123256741L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_endpoint_server_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.server"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_endpoint_server_web");
    }

    @Test
    public void onErrorWorksTest() throws Exception {
        this.invoke("msg", (Object)WSCMsgServer.MESSAGES[0], "empty");
        this.invoke("error", (Object)"anything", "anything");
        this.invokeUntilFound("msg", WSCMsgServer.MESSAGES[1], "TCK test throwable");
        WSClientIT.logMsg("@OnError has been called after RuntimeException is thrown on @OnMessage as expected");
    }

    @Test
    public void onCloseWorksTest() throws Exception {
        this.invoke("msg", (Object)WSCMsgServer.MESSAGES[0], "empty");
        this.invoke("close", (Object)"anything", "anything");
        this.invokeUntilFound("msg", WSCMsgServer.MESSAGES[1], "@OnClose");
        WSClientIT.logMsg("@OnClose has been called after session.close() as expected");
    }

    private void invokeUntilFound(String endpoint, String content, String search) throws Exception {
        int sleep = 100;
        long maxWait = this._ws_wait * (1000 / sleep);
        boolean found = false;
        String response = null;
        for (long count = 0L; !found && count < maxWait; ++count) {
            this.invoke(endpoint, (Object)content, "", false);
            response = this.getLastResponse(String.class);
            if (response.equals(search)) {
                found = true;
            }
            this.cleanup();
            if (found) continue;
            TestUtil.sleepMsec((int)sleep);
        }
        if (!found) {
            new Exception(search + " has not been found in response, last response was " + response);
        }
    }
}

