/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.spec.application.containers;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.spec.application.containers.WSCServer;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -2942255764587010746L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_spec_application_containers_web.war");
        archive.addClasses(new Class[]{WSCServer.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_spec_application_containers_web");
    }

    @Test
    public void webSocketContainerIsOnePerVMTest() throws Exception {
        this.invoke("srv", (Object)"anything", "", false);
        String address = this.getResponseAsString();
        this.invokeAgain("anything", "", false);
        String address2 = this.getResponseAsString().substring(address.length());
        this.cleanup();
        WSClientIT.assertEquals(address, address2, "There are is not just one WebSocketContainer instance per application per VM); hashCode of first", address, "hasCode of the second", address2);
        WSClientIT.logMsg("session#getContainer returns only one instance of WebSocketContainer as expected");
    }
}

