/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.util.tracker.ServiceTracker;

public final class ServiceUtil {
    private ServiceUtil() {
    }

    public static <T> ServiceReference<T>[] getServiceReferences(BundleContext bundleContext, Class<T> clazz, @Nullable String filter) {
        Objects.requireNonNull(bundleContext, "Bundle context cannot be null.");
        Objects.requireNonNull(clazz, "Class intance name cannot be null.");
        try {
            Collection refs = bundleContext.getServiceReferences(clazz, filter);
            return refs.toArray(new ServiceReference[0]);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    public static <T> Collection<ServiceReference<T>> getServiceReferencesAsCollection(BundleContext bundleContext, Class<T> serviceClass, String filter) throws KuraException {
        try {
            Collection sr = bundleContext.getServiceReferences(serviceClass, filter);
            if (sr == null) {
                throw KuraException.internalError((String)(String.valueOf(serviceClass.toString()) + " not found."));
            }
            return sr;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T getService(BundleContext bundleContext, ServiceReference<T> serviceReference) throws KuraException {
        Object service = null;
        if (serviceReference != null) {
            service = bundleContext.getService(serviceReference);
        }
        if (service == null) {
            throw KuraException.internalError((String)"Service not found.");
        }
        return (T)service;
    }

    public static void ungetServiceReferences(BundleContext bundleContext, ServiceReference<?>[] refs) {
        Objects.requireNonNull(bundleContext, "Bundle context cannot be null.");
        Objects.requireNonNull(refs, "Service References cannot be null.");
        ServiceReference<?>[] serviceReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<?> ref = serviceReferenceArray[n2];
            bundleContext.ungetService(ref);
            ++n2;
        }
    }

    public static Optional<Object> waitForService(String filter, long timeout, TimeUnit timeunit) throws InterruptedException, InvalidSyntaxException {
        Objects.requireNonNull(filter, "Filter cannot be null.");
        Objects.requireNonNull(timeunit, "TimeUnit cannot be null");
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout period cannot be zero or negative");
        }
        long timeoutInMillis = timeunit.toMillis(timeout);
        BundleContext bundleContext = FrameworkUtil.getBundle(ServiceUtil.class).getBundleContext();
        Filter filterRef = bundleContext.createFilter(filter);
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, filterRef, null);
        serviceTracker.open();
        Object service = serviceTracker.waitForService(timeoutInMillis);
        serviceTracker.close();
        return Optional.ofNullable(service);
    }

    public static <T> T withService(BundleContext bundleContext, Function<Optional<Object>, T> func, String filter) throws InvalidSyntaxException {
        ServiceReference[] refs = bundleContext.getServiceReferences(null, filter);
        if (refs == null || refs.length == 0) {
            return func.apply(Optional.empty());
        }
        ServiceReference ref = refs[0];
        try {
            Object o = bundleContext.getService(ref);
            T t = func.apply(Optional.ofNullable(o));
            return t;
        }
        finally {
            bundleContext.ungetService(ref);
        }
    }

    public static <T> void withAllServices(BundleContext bundleContext, Class<T> serviceClass, String filter, ServiceConsumer<T> consumer) throws KuraException {
        ServiceUtil.withAllServiceReferences(bundleContext, serviceClass, filter, (ServiceReference<T> ref, BundleContext ctx) -> {
            Object service = ctx.getService(ref);
            try {
                consumer.consume(service);
            }
            finally {
                ctx.ungetService(ref);
            }
        });
    }

    public static <T> void withAllServiceReferences(BundleContext bundleContext, Class<T> serviceClass, String filter, ServiceReferenceConsumer<T> consumer) throws KuraException {
        ServiceReference[] refs;
        try {
            refs = bundleContext.getAllServiceReferences(serviceClass != null ? serviceClass.getName() : null, filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{serviceClass != null ? serviceClass.getName() : ""});
        }
        if (refs == null) {
            return;
        }
        ServiceReference[] serviceReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference ref = serviceReferenceArray[n2];
            consumer.consume(ref, bundleContext);
            ++n2;
        }
    }

    public static void withAllServices(BundleContext bundleContext, String filter, ServiceConsumer<Object> consumer, Class<?> ... classes) throws KuraException {
        if (classes == null || classes.length == 0) {
            ServiceUtil.withAllServices(bundleContext, null, filter, consumer);
        }
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            ServiceUtil.withAllServices(bundleContext, c, filter, consumer);
            ++n2;
        }
    }

    public static void withAllServiceReferences(BundleContext bundleContext, String filter, ServiceReferenceConsumer<Object> consumer, Class<?> ... classes) throws KuraException {
        if (classes == null || classes.length == 0) {
            ServiceUtil.withAllServiceReferences(bundleContext, null, filter, consumer);
        }
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            ServiceUtil.withAllServiceReferences(bundleContext, c, filter, consumer);
            ++n2;
        }
    }

    public static boolean ungetService(BundleContext bundleContext, ServiceReference<?> serviceReference) {
        if (serviceReference != null) {
            return bundleContext.ungetService(serviceReference);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, R> R applyToServiceOptionally(BundleContext bundleContext, Class<T> serviceClass, ServiceFunction<T, R> function) throws KuraException {
        ServiceReference ref = bundleContext.getServiceReference(serviceClass);
        try {
            if (ref == null) {
                return function.apply(null);
            }
            Object service = bundleContext.getService(ref);
            try {
                R r = function.apply(service);
                return r;
            }
            finally {
                bundleContext.ungetService(ref);
            }
        }
        catch (Exception e) {
            throw KuraException.internalError((String)e.getMessage());
        }
    }

    public static boolean providesService(BundleContext bundleContext, String kuraServicePid, Class<?> serviceInterface) {
        return ServiceUtil.providesService(bundleContext, kuraServicePid, (Set<String> s) -> s.contains(serviceInterface.getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean providesService(BundleContext bundleContext, String kuraServicePid, Predicate<Set<String>> filter) {
        String pidFilter = "(kura.service.pid=" + kuraServicePid + ")";
        try {
            ServiceReference[] refs = bundleContext.getAllServiceReferences(null, pidFilter);
            if (refs == null) {
                return false;
            }
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ServiceReference ref = serviceReferenceArray[n2];
                Object rawProvidedInterfaces = ref.getProperty("objectClass");
                Set<String> providedInterfaces = rawProvidedInterfaces instanceof String ? Collections.singleton((String)rawProvidedInterfaces) : (rawProvidedInterfaces instanceof String[] ? Arrays.asList((String[])rawProvidedInterfaces).stream().collect(Collectors.toSet()) : Collections.emptySet());
                if (filter.test(providedInterfaces)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    public static boolean isFactoryOf(BundleContext bundleContext, String factoryPid, Predicate<Set<String>> filter) {
        ServiceReference<ServiceComponentRuntime>[] refs = ServiceUtil.getServiceReferences(bundleContext, ServiceComponentRuntime.class, null);
        if (refs == null || refs.length == 0) {
            return false;
        }
        ServiceReference<ServiceComponentRuntime> ref = refs[0];
        try {
            ServiceComponentRuntime scr = (ServiceComponentRuntime)bundleContext.getService(ref);
            boolean bl = scr.getComponentDescriptionDTOs(new Bundle[0]).stream().anyMatch(c -> {
                if (!Objects.equals(factoryPid, c.name)) {
                    return false;
                }
                return ServiceUtil.providedInterfacesMatch(c.serviceInterfaces, filter);
            });
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            bundleContext.ungetService(ref);
        }
    }

    private static boolean providedInterfacesMatch(String[] providedInterfaces, Predicate<Set<String>> filter) {
        if (providedInterfaces == null) {
            return filter.test(Collections.emptySet());
        }
        return filter.test(Arrays.stream(providedInterfaces).collect(Collectors.toSet()));
    }

    public static boolean isFactoryOfAnyService(BundleContext bundleContext, String factoryPid, Class<?> ... interfaces) {
        return ServiceUtil.isFactoryOf(bundleContext, factoryPid, s -> {
            Class[] classArray2 = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class intf = classArray2[n2];
                if (s.contains(intf.getName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        });
    }

    public static interface ServiceConsumer<T> {
        public void consume(T var1) throws KuraException;
    }

    public static interface ServiceFunction<T, R> {
        public R apply(T var1) throws KuraException;
    }

    public static interface ServiceReferenceConsumer<T> {
        public void consume(ServiceReference<T> var1, BundleContext var2) throws KuraException;
    }
}

