/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore.crl;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.net.URI;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredCRL {
    private static final Logger logger = LoggerFactory.getLogger(StoredCRL.class);
    private static final String DISTRIBUTION_POINTS_KEY = "dps";
    private static final String BODY_KEY = "body";
    private final Set<URI> distributionPoints;
    private final X509CRL crl;

    public StoredCRL(Set<URI> distributionPoints, X509CRL crl) {
        this.distributionPoints = distributionPoints;
        this.crl = crl;
    }

    public Set<URI> getDistributionPoints() {
        return this.distributionPoints;
    }

    public X509CRL getCrl() {
        return this.crl;
    }

    public boolean isExpired() {
        long now = System.currentTimeMillis();
        Date nextUpdate = this.crl.getNextUpdate();
        return nextUpdate != null && nextUpdate.getTime() < now;
    }

    public static StoredCRL fromJson(JsonObject object) throws IOException, CRLException {
        HashSet<URI> dps = new HashSet<URI>();
        JsonArray dpsArray = object.get(DISTRIBUTION_POINTS_KEY).asArray();
        for (JsonValue value : dpsArray) {
            try {
                dps.add(new URI(value.asString()));
            }
            catch (Exception e) {
                logger.warn("failed to parse URI", (Throwable)e);
            }
        }
        String body = object.get(BODY_KEY).asString();
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] decoded = decoder.decode(body);
        X509CRLHolder holder = new X509CRLHolder(decoded);
        return new StoredCRL(dps, new JcaX509CRLConverter().getCRL(holder));
    }

    public JsonObject toJson() throws CRLException {
        JsonObject result = new JsonObject();
        JsonArray dpsArray = new JsonArray();
        for (URI uri : this.distributionPoints) {
            dpsArray.add(uri.toString());
        }
        result.add(DISTRIBUTION_POINTS_KEY, (JsonValue)dpsArray);
        Base64.Encoder encoder = Base64.getEncoder();
        String body = encoder.encodeToString(this.crl.getEncoded());
        result.add(BODY_KEY, body);
        return result;
    }
}

