/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MappingCollection<T, U>
implements Collection<U> {
    private final Collection<T> source;
    private final Function<T, U> func;

    public MappingCollection(Collection<T> source, Function<T, U> func) {
        this.source = source;
        this.func = func;
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.source.stream().map(this.func).collect(Collectors.toList()).contains(o);
    }

    @Override
    public Iterator<U> iterator() {
        final Iterator<T> iter = this.source.iterator();
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public U next() {
                return MappingCollection.this.func.apply(iter.next());
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.source.stream().map(this.func).collect(Collectors.toList()).toArray();
    }

    @Override
    public <V> V[] toArray(V[] a) {
        return this.source.stream().map(this.func).collect(Collectors.toList()).toArray(a);
    }

    @Override
    public boolean add(U e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends U> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

