/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.provider;

import com.eclipsesource.jaxrs.provider.security.AuthenticationHandler;
import com.eclipsesource.jaxrs.provider.security.AuthorizationHandler;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.internal.rest.auth.BasicAuthenticationProvider;
import org.eclipse.kura.internal.rest.auth.CertificateAuthenticationProvider;
import org.eclipse.kura.internal.rest.auth.RestSessionHelper;
import org.eclipse.kura.internal.rest.auth.SessionAuthProvider;
import org.eclipse.kura.internal.rest.auth.SessionRestService;
import org.eclipse.kura.internal.rest.provider.AuthenticationProviderHolder;
import org.eclipse.kura.internal.rest.provider.RestServiceOptions;
import org.eclipse.kura.internal.rest.provider.ServletContainerBridgeFix;
import org.eclipse.kura.rest.auth.AuthenticationProvider;
import org.eclipse.kura.util.useradmin.UserAdminHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.useradmin.UserAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RestService
implements AuthenticationHandler,
AuthorizationHandler,
ConfigurableComponent,
ContainerResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(RestService.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");
    private static final Response NOT_FOUND_RESPONSE = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    private CryptoService cryptoService;
    private UserAdmin userAdmin;
    private ConfigurationAdmin configurationAdmin;
    RestServiceOptions options;
    private final List<ServiceRegistration<?>> registeredServices = new ArrayList();
    private final Set<AuthenticationProviderHolder> authenticationProviders = new TreeSet<AuthenticationProviderHolder>();
    private AuthenticationProvider basicAuthProvider;
    private AuthenticationProvider certificateAuthProvider;
    private SessionAuthProvider sessionAuthenticationProvider;
    private SessionRestService authRestService;
    private UserAdminHelper userAdminHelper;
    private ServiceTracker<Object, Thread> tracker;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    public void setUserAdmin(UserAdmin userAdmin) {
        this.userAdmin = userAdmin;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindAuthenticationProvider(AuthenticationProvider provider) {
        Set<AuthenticationProviderHolder> set = this.authenticationProviders;
        synchronized (set) {
            AuthenticationProviderHolder holder = new AuthenticationProviderHolder(provider);
            this.authenticationProviders.add(holder);
            holder.onEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAuthenticationProvider(AuthenticationProvider provider) {
        Set<AuthenticationProviderHolder> set = this.authenticationProviders;
        synchronized (set) {
            AuthenticationProviderHolder holder = new AuthenticationProviderHolder(provider);
            if (this.authenticationProviders.remove(holder)) {
                holder.onDisabled();
            }
        }
    }

    public void activate(Map<String, Object> properties) {
        logger.info("activating...");
        BundleContext bundleContext = FrameworkUtil.getBundle(RestService.class).getBundleContext();
        try {
            this.tracker = new ServiceTracker(bundleContext, FrameworkUtil.createFilter((String)"(osgi.http.whiteboard.servlet.name=com.eclipsesource.jaxrs.publisher.internal.ServletContainerBridge)"), (ServiceTrackerCustomizer)new ServletContainerBridgeFix(bundleContext));
            this.tracker.open();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.userAdminHelper = new UserAdminHelper(this.userAdmin, this.cryptoService);
        RestSessionHelper restSessionHelper = new RestSessionHelper(this.userAdminHelper);
        this.registeredServices.add(bundleContext.registerService(ContainerRequestFilter.class, (Object)new IncomingPortCheckFilter(), null));
        this.basicAuthProvider = new BasicAuthenticationProvider(bundleContext, this.userAdminHelper);
        this.certificateAuthProvider = new CertificateAuthenticationProvider(this.userAdminHelper);
        this.sessionAuthenticationProvider = new SessionAuthProvider(restSessionHelper, new HashSet<String>(Arrays.asList("/session/v1/changePassword", "/session/v1/xsrfToken")), Collections.singleton("/session/v1/xsrfToken"));
        this.authRestService = new SessionRestService(this.userAdminHelper, restSessionHelper, this.configurationAdmin);
        this.registeredServices.add(bundleContext.registerService(SessionRestService.class, (Object)this.authRestService, null));
        this.update(properties);
        logger.info("activating...done");
    }

    public void update(Map<String, Object> properties) {
        logger.info("updating...");
        RestServiceOptions newOptions = new RestServiceOptions(properties);
        if (!Objects.equals(this.options, newOptions)) {
            this.options = newOptions;
            this.updateBuiltinAuthenticationProviders(newOptions);
            this.authRestService.setOptions(newOptions);
            this.sessionAuthenticationProvider.setOptions(newOptions);
        }
        logger.info("updating...done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        logger.info("deactivating...");
        this.tracker.close();
        for (ServiceRegistration<?> reg : this.registeredServices) {
            reg.unregister();
        }
        Set<AuthenticationProviderHolder> set = this.authenticationProviders;
        synchronized (set) {
            Iterator<AuthenticationProviderHolder> iter = this.authenticationProviders.iterator();
            while (iter.hasNext()) {
                iter.next().onDisabled();
                iter.remove();
            }
        }
        logger.info("deactivating...done");
    }

    public boolean isUserInRole(Principal requestUser, String role) {
        try {
            this.userAdminHelper.requirePermissions(requestUser.getName(), new String[]{"rest." + role});
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(ContainerRequestContext requestContext) {
        this.initAuditContext(requestContext);
        Set<AuthenticationProviderHolder> set = this.authenticationProviders;
        synchronized (set) {
            for (AuthenticationProviderHolder provider : this.authenticationProviders) {
                Optional<Principal> principal = provider.authenticate(this.request, requestContext);
                if (!principal.isPresent()) continue;
                return principal.get();
            }
        }
        return null;
    }

    public String getAuthenticationScheme() {
        return null;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        int responseStatus = responseContext.getStatus();
        AuditContext auditContext = this.initAuditContext(requestContext);
        try {
            if (responseContext.getStatus() == 404) {
                auditLogger.warn("{} Rest - Failure - Service not found", (Object)auditContext);
                return;
            }
            if (responseContext.getStatus() == 403) {
                if (requestContext.getSecurityContext() == null || requestContext.getSecurityContext().getUserPrincipal() == null) {
                    responseContext.setStatus(401);
                } else {
                    auditLogger.warn("{} Rest - Failure - User not authorized to perform the requested operation", (Object)auditContext);
                    return;
                }
            }
            if (responseContext.getStatus() == 401) {
                auditLogger.warn("{} Rest - Failure - User not authenticated", (Object)auditContext);
                return;
            }
            if (responseStatus >= 200 && responseStatus < 400) {
                auditLogger.info("{} Rest - Success - Rest request succeeded", (Object)auditContext);
            } else {
                auditLogger.warn("{} Rest - Failure - Request failed", (Object)auditContext);
            }
        }
        finally {
            this.closeAuditContext(requestContext);
        }
    }

    private String getRequestPath(ContainerRequestContext request) {
        List pathSegments = request.getUriInfo().getPathSegments();
        Iterator iterator = pathSegments.iterator();
        StringBuilder pathBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            pathBuilder.append(((PathSegment)iterator.next()).getPath());
            if (!iterator.hasNext()) continue;
            pathBuilder.append("/");
        }
        return pathBuilder.toString();
    }

    private AuditContext initAuditContext(ContainerRequestContext request) {
        Object rawContext = request.getProperty("org.eclipse.kura.rest.audit.context");
        if (rawContext != null) {
            return (AuditContext)rawContext;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        String requestIp = request.getHeaderString("X-FORWARDED-FOR");
        if (requestIp == null) {
            requestIp = this.request.getRemoteAddr();
        }
        properties.put(AuditConstants.KEY_ENTRY_POINT.getValue(), "RestService");
        properties.put(AuditConstants.KEY_IP.getValue(), requestIp);
        properties.put("rest.method", request.getMethod());
        properties.put("rest.path", this.getRequestPath(request));
        AuditContext result = new AuditContext(properties);
        AuditContext.Scope scope = AuditContext.openScope((AuditContext)result);
        request.setProperty("org.eclipse.kura.rest.audit.context", (Object)result);
        request.setProperty("org.eclipse.kura.rest.audit.scope", (Object)scope);
        return result;
    }

    private void closeAuditContext(ContainerRequestContext request) {
        Object rawScope = request.getProperty("org.eclipse.kura.rest.audit.scope");
        if (rawScope instanceof AuditContext.Scope) {
            ((AuditContext.Scope)rawScope).close();
        }
    }

    private void updateBuiltinAuthenticationProviders(RestServiceOptions options) {
        if (options.isPasswordAuthEnabled() && options.isBasicAuthEnabled()) {
            this.bindAuthenticationProvider(this.basicAuthProvider);
        } else {
            this.unbindAuthenticationProvider(this.basicAuthProvider);
        }
        if (options.isCertificateAuthEnabled() && options.isStatelessCertificateAuthEnabled()) {
            this.bindAuthenticationProvider(this.certificateAuthProvider);
        } else {
            this.unbindAuthenticationProvider(this.certificateAuthProvider);
        }
        if (options.isSessionManagementEnabled()) {
            this.bindAuthenticationProvider(this.sessionAuthenticationProvider);
        }
    }

    @Provider
    @Priority(value=900)
    private class IncomingPortCheckFilter
    implements ContainerRequestFilter {
        @Context
        private HttpServletRequest sr;

        private IncomingPortCheckFilter() {
        }

        public void filter(ContainerRequestContext request) throws IOException {
            RestService.this.initAuditContext(request);
            Set<Integer> allowedPorts = RestService.this.options.getAllowedPorts();
            if (allowedPorts.isEmpty()) {
                return;
            }
            int port = this.sr.getLocalPort();
            if (!allowedPorts.contains(port)) {
                request.abortWith(NOT_FOUND_RESPONSE);
            }
        }
    }
}

