/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.processor.RoutingSlip;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;

@Metadata(label="eip,endpoint,routing")
@XmlRootElement(name="routingSlip")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoutingSlipDefinition<Type extends ProcessorDefinition<Type>>
extends NoOutputExpressionNode {
    public static final String DEFAULT_DELIMITER = ",";
    @XmlAttribute
    @Metadata(defaultValue=",")
    private String uriDelimiter;
    @XmlAttribute
    private Boolean ignoreInvalidEndpoints;
    @XmlAttribute
    private Integer cacheSize;

    public RoutingSlipDefinition() {
        this((String)null, DEFAULT_DELIMITER);
    }

    public RoutingSlipDefinition(String headerName) {
        this(headerName, DEFAULT_DELIMITER);
    }

    public RoutingSlipDefinition(String headerName, String uriDelimiter) {
        super(new HeaderExpression(headerName));
        this.setUriDelimiter(uriDelimiter);
    }

    public RoutingSlipDefinition(Expression expression, String uriDelimiter) {
        super(expression);
        this.setUriDelimiter(uriDelimiter);
    }

    public RoutingSlipDefinition(Expression expression) {
        this(expression, DEFAULT_DELIMITER);
    }

    public String toString() {
        return "RoutingSlip[" + this.getExpression() + "]";
    }

    @Override
    public String getShortName() {
        return "routingSlip";
    }

    @Override
    public String getLabel() {
        return "routingSlip[" + this.getExpression() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Expression expression = this.getExpression().createExpression(routeContext);
        String delimiter = this.getUriDelimiter() != null ? this.getUriDelimiter() : DEFAULT_DELIMITER;
        RoutingSlip routingSlip = new RoutingSlip(routeContext.getCamelContext(), expression, delimiter);
        if (this.getIgnoreInvalidEndpoints() != null) {
            routingSlip.setIgnoreInvalidEndpoints(this.getIgnoreInvalidEndpoints());
        }
        if (this.getCacheSize() != null) {
            routingSlip.setCacheSize(this.getCacheSize());
        }
        ErrorHandlerFactory builder = routeContext.getRoute().getErrorHandlerBuilder();
        AsyncProcessor errorHandler = (AsyncProcessor)builder.createErrorHandler(routeContext, routingSlip.newRoutingSlipProcessorForErrorHandler());
        routingSlip.setErrorHandler(errorHandler);
        return routingSlip;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return Collections.emptyList();
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public void setUriDelimiter(String uriDelimiter) {
        this.uriDelimiter = uriDelimiter;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setIgnoreInvalidEndpoints(Boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public Boolean getIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Type end() {
        return (Type)super.end();
    }

    public RoutingSlipDefinition<Type> ignoreInvalidEndpoints() {
        this.setIgnoreInvalidEndpoints(true);
        return this;
    }

    public RoutingSlipDefinition<Type> uriDelimiter(String uriDelimiter) {
        this.setUriDelimiter(uriDelimiter);
        return this;
    }

    public RoutingSlipDefinition<Type> cacheSize(int cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }
}

