/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.store;

import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.util.configuration.Property;

public final class WireRecordStoreComponentOptions {
    private static final Property<String> STORE_NAME_PROPERTY = new Property("store.name", (Object)"WR_data");
    private static final Property<Integer> MAXIMUM_STORE_SIZE_PROPERTY = new Property("maximum.store.size", (Object)10000);
    private static final Property<Integer> CLEANUP_RECORDS_KEEP_PROPERTY = new Property("cleanup.records.keep", (Object)5000);
    private final String storeName;
    private final int maximumStoreSize;
    private final int cleanupRecordsKeep;

    public WireRecordStoreComponentOptions(Map<String, Object> properties) {
        this.storeName = (String)STORE_NAME_PROPERTY.get(properties);
        this.maximumStoreSize = (Integer)MAXIMUM_STORE_SIZE_PROPERTY.get(properties);
        this.cleanupRecordsKeep = (Integer)CLEANUP_RECORDS_KEEP_PROPERTY.get(properties);
    }

    public int getCleanupRecordsKeep() {
        return this.cleanupRecordsKeep;
    }

    public int getMaximumStoreSize() {
        return this.maximumStoreSize;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public int hashCode() {
        return Objects.hash(this.cleanupRecordsKeep, this.maximumStoreSize, this.storeName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WireRecordStoreComponentOptions)) {
            return false;
        }
        WireRecordStoreComponentOptions other = (WireRecordStoreComponentOptions)obj;
        return this.cleanupRecordsKeep == other.cleanupRecordsKeep && this.maximumStoreSize == other.maximumStoreSize && Objects.equals(this.storeName, other.storeName);
    }
}

