/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.taimos.gpsd4java.types.IGPSObject;
import de.taimos.gpsd4java.types.ParseException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultParser {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractResultParser.class);
    protected final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final JsonParser jsonParser;

    protected AbstractResultParser() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.jsonParser = new JsonParser();
    }

    public IGPSObject parse(String line) throws ParseException {
        try {
            JsonObject jsonObject = this.jsonParser.parse(line).getAsJsonObject();
            return this.parse(jsonObject);
        }
        catch (JsonSyntaxException e) {
            throw new ParseException("Parsing failed", e);
        }
    }

    public abstract IGPSObject parse(JsonObject var1) throws ParseException;

    protected <T extends IGPSObject> List<T> parseObjectArray(JsonArray array, Class<T> type) throws ParseException {
        try {
            if (array == null) {
                return new ArrayList(10);
            }
            ArrayList<IGPSObject> objects = new ArrayList<IGPSObject>(10);
            for (int i = 0; i < array.size(); ++i) {
                objects.add(this.parse(array.get(i).getAsJsonObject()));
            }
            return objects;
        }
        catch (JsonSyntaxException e) {
            throw new ParseException("Parsing failed", e);
        }
    }

    protected double parseTimestamp(JsonObject json, String fieldName) {
        try {
            String text = this.optString(json, fieldName, null);
            if (text != null) {
                LOG.debug("{}: {}", (Object)fieldName, (Object)text);
                Date date = this.dateFormat.parse(text);
                if (LOG.isDebugEnabled()) {
                    String ds = DateFormat.getDateTimeInstance(0, 0).format(date);
                    LOG.debug("Date: {}", (Object)ds);
                }
                return (double)date.getTime() / 1000.0;
            }
        }
        catch (Exception ex) {
            double d = this.optDouble(json, fieldName, Double.NaN);
            if (d != Double.NaN) {
                return d;
            }
            LOG.info("Failed to parse time", (Throwable)ex);
        }
        return Double.NaN;
    }

    protected <T> T optField(Class<T> clazz, JsonObject json, String field, T fallBackValue) {
        Object t = fallBackValue;
        JsonElement jsonField = json.get(field);
        if (jsonField != null && !json.isJsonNull() && jsonField.isJsonPrimitive()) {
            if (jsonField.getAsJsonPrimitive().isNumber()) {
                if (clazz.isAssignableFrom(Double.class)) {
                    t = jsonField.getAsDouble();
                } else if (clazz.isAssignableFrom(Integer.class)) {
                    t = jsonField.getAsInt();
                }
            } else if (jsonField.getAsJsonPrimitive().isBoolean()) {
                if (clazz.isAssignableFrom(Boolean.class)) {
                    t = jsonField.getAsBoolean();
                }
            } else if (jsonField.getAsJsonPrimitive().isString() && clazz.isAssignableFrom(String.class)) {
                t = jsonField.getAsString();
            }
        }
        return t;
    }

    protected double optDouble(JsonObject json, String field, double fallbackValue) {
        return this.optField(Double.class, json, field, fallbackValue);
    }

    protected int optInt(JsonObject json, String field, int fallbackValue) {
        return this.optField(Integer.class, json, field, fallbackValue);
    }

    protected int optInt(JsonObject json, String field) {
        return this.optInt(json, field, 0);
    }

    protected boolean optBoolean(JsonObject json, String field, boolean fallbackValue) {
        return this.optField(Boolean.class, json, field, fallbackValue);
    }

    protected String optString(JsonObject json, String field, String fallbackValue) {
        return this.optField(String.class, json, field, fallbackValue);
    }

    protected String optString(JsonObject json, String field) {
        return this.optString(json, field, "");
    }
}

