/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;

public abstract class AbstractDecorator {
    protected volatile DependencyManager m_manager;
    private final Map m_services = new HashMap();
    static /* synthetic */ Class class$org$osgi$framework$BundleContext;
    static /* synthetic */ Class class$org$osgi$framework$ServiceRegistration;
    static /* synthetic */ Class class$org$apache$felix$dm$DependencyManager;
    static /* synthetic */ Class class$org$apache$felix$dm$Component;

    public abstract Component createService(Object[] var1);

    public void updateService(Object[] properties) {
        throw new NoSuchMethodError("Method updateService not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceProperties(Dictionary serviceProperties) {
        HashMap services = new HashMap();
        AbstractDecorator abstractDecorator = this;
        synchronized (abstractDecorator) {
            services.putAll(this.m_services);
        }
        Iterator i = services.values().iterator();
        while (i.hasNext()) {
            ((Component)i.next()).setServiceProperties(serviceProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(ComponentStateListener listener) {
        HashMap services = new HashMap();
        AbstractDecorator abstractDecorator = this;
        synchronized (abstractDecorator) {
            services.putAll(this.m_services);
        }
        Iterator i = services.values().iterator();
        while (i.hasNext()) {
            ((Component)i.next()).addStateListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(ComponentStateListener listener) {
        HashMap services = new HashMap();
        AbstractDecorator abstractDecorator = this;
        synchronized (abstractDecorator) {
            services.putAll(this.m_services);
        }
        Iterator i = services.values().iterator();
        while (i.hasNext()) {
            ((Component)i.next()).removeStateListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(Dependency d) {
        HashMap services = new HashMap();
        AbstractDecorator abstractDecorator = this;
        synchronized (abstractDecorator) {
            services.putAll(this.m_services);
        }
        Iterator i = services.values().iterator();
        while (i.hasNext()) {
            ((Component)i.next()).add(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependencies(List dependencies) {
        HashMap services = new HashMap();
        AbstractDecorator abstractDecorator = this;
        synchronized (abstractDecorator) {
            services.putAll(this.m_services);
        }
        Iterator i = services.values().iterator();
        while (i.hasNext()) {
            ((Component)i.next()).add(dependencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependency(Dependency d) {
        HashMap services = new HashMap();
        AbstractDecorator abstractDecorator = this;
        synchronized (abstractDecorator) {
            services.putAll(this.m_services);
        }
        Iterator i = services.values().iterator();
        while (i.hasNext()) {
            ((Component)i.next()).remove(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        block11: {
            try {
                Component service;
                AbstractDecorator abstractDecorator = this;
                synchronized (abstractDecorator) {
                    service = (Component)this.m_services.get(pid);
                }
                if (service == null) {
                    service = this.createService(new Object[]{properties});
                    abstractDecorator = this;
                    synchronized (abstractDecorator) {
                        this.m_services.put(pid, service);
                    }
                    this.m_manager.add(service);
                    break block11;
                }
                this.updateService(new Object[]{properties, service});
            }
            catch (Throwable t) {
                if (t instanceof ConfigurationException) {
                    throw (ConfigurationException)t;
                }
                if (t.getCause() instanceof ConfigurationException) {
                    throw (ConfigurationException)t.getCause();
                }
                throw new ConfigurationException(null, "Could not create service for ManagedServiceFactory Pid " + pid, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(String pid) {
        Component service = null;
        AbstractDecorator abstractDecorator = this;
        synchronized (abstractDecorator) {
            service = (Component)this.m_services.remove(pid);
        }
        if (service != null) {
            this.m_manager.remove(service);
        }
    }

    public void added(URL resource) {
        Component newService = this.createService(new Object[]{resource});
        this.m_services.put(resource, newService);
        this.m_manager.add(newService);
    }

    public void removed(URL resource) {
        Component newService = (Component)this.m_services.remove(resource);
        if (newService == null) {
            throw new IllegalStateException("Service should not be null here.");
        }
        this.m_manager.remove(newService);
    }

    public void added(ServiceReference ref, Object service) {
        Component newService = this.createService(new Object[]{ref, service});
        this.m_services.put(ref, newService);
        this.m_manager.add(newService);
    }

    public void removed(ServiceReference ref, Object service) {
        Component newService = (Component)this.m_services.remove(ref);
        if (newService == null) {
            throw new IllegalStateException("Service should not be null here.");
        }
        this.m_manager.remove(newService);
    }

    public void added(Bundle bundle) {
        Component newService = this.createService(new Object[]{bundle});
        this.m_services.put(bundle, newService);
        this.m_manager.add(newService);
    }

    public void removed(Bundle bundle) {
        Component newService = (Component)this.m_services.remove(bundle);
        if (newService == null) {
            throw new IllegalStateException("Service should not be null here.");
        }
        this.m_manager.remove(newService);
    }

    public void stop() {
        Iterator i = this.m_services.values().iterator();
        while (i.hasNext()) {
            this.m_manager.remove((Component)i.next());
        }
        this.m_services.clear();
    }

    public void configureAutoConfigState(Component target, Component source) {
        this.configureAutoConfigState(target, source, class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = AbstractDecorator.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext);
        this.configureAutoConfigState(target, source, class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = AbstractDecorator.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration);
        this.configureAutoConfigState(target, source, class$org$apache$felix$dm$DependencyManager == null ? (class$org$apache$felix$dm$DependencyManager = AbstractDecorator.class$("org.apache.felix.dm.DependencyManager")) : class$org$apache$felix$dm$DependencyManager);
        this.configureAutoConfigState(target, source, class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = AbstractDecorator.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component);
    }

    private void configureAutoConfigState(Component target, Component source, Class clazz) {
        String name = source.getAutoConfigInstance(clazz);
        if (name != null) {
            target.setAutoConfig(clazz, name);
        } else {
            target.setAutoConfig(clazz, source.getAutoConfig(clazz));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

