/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net.modem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.kura.core.net.AbstractNetInterface;
import org.eclipse.kura.core.net.modem.ModemInterfaceAddressImpl;
import org.eclipse.kura.net.NetInterface;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetInterfaceType;
import org.eclipse.kura.net.modem.ModemDevice;
import org.eclipse.kura.net.modem.ModemInterface;
import org.eclipse.kura.net.modem.ModemInterfaceAddress;
import org.eclipse.kura.net.modem.ModemPowerMode;
import org.eclipse.kura.net.modem.ModemTechnologyType;
import org.eclipse.kura.usb.UsbModemDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModemInterfaceImpl<T extends ModemInterfaceAddress>
extends AbstractNetInterface<T>
implements ModemInterface<T> {
    private static final Logger logger = LoggerFactory.getLogger(ModemInterfaceImpl.class);
    private String modemId;
    private int pppNum;
    private String model;
    private String manufacturer;
    private String serialNumber;
    private String[] revisionId;
    private List<ModemTechnologyType> technologyTypes;
    private boolean poweredOn;
    private ModemPowerMode powerMode;
    private ModemDevice modemDevice;
    private boolean gpsSupported;

    public ModemInterfaceImpl(String name) {
        super(name);
    }

    public ModemInterfaceImpl(Class<T> modemInterfaceAddressClass, ModemInterface<? extends ModemInterfaceAddress> other) {
        super((NetInterface<? extends NetInterfaceAddress>)other);
        this.modemId = other.getModemIdentifier();
        this.pppNum = other.getPppNum();
        this.model = other.getModel();
        this.manufacturer = other.getManufacturer();
        this.serialNumber = other.getSerialNumber();
        this.revisionId = other.getRevisionId();
        this.technologyTypes = other.getTechnologyTypes();
        this.poweredOn = other.isPoweredOn();
        this.powerMode = other.getPowerMode();
        this.modemDevice = other.getModemDevice();
        if (this.modemDevice instanceof UsbModemDevice) {
            this.setName(((UsbModemDevice)this.modemDevice).getUsbPort());
        }
        List otherNetInterfaceAddresses = other.getNetInterfaceAddresses();
        ArrayList<ModemInterfaceAddress> interfaceAddresses = new ArrayList<ModemInterfaceAddress>();
        if (otherNetInterfaceAddresses != null) {
            for (ModemInterfaceAddress modemInterfaceAddress : otherNetInterfaceAddresses) {
                try {
                    ModemInterfaceAddressImpl copiedInterfaceAddressImpl = new ModemInterfaceAddressImpl(modemInterfaceAddress);
                    interfaceAddresses.add((ModemInterfaceAddress)modemInterfaceAddressClass.cast(copiedInterfaceAddressImpl));
                }
                catch (Exception exception) {
                    logger.debug("Could not copy interface address: {}", (Object)modemInterfaceAddress);
                }
            }
        }
        this.setNetInterfaceAddresses(interfaceAddresses);
    }

    public NetInterfaceType getType() {
        return NetInterfaceType.MODEM;
    }

    public int getPppNum() {
        return this.pppNum;
    }

    public void setPppNum(int pppNum) {
        this.pppNum = pppNum;
    }

    public String getModemIdentifier() {
        return this.modemId;
    }

    public void setModemIdentifier(String modemId) {
        this.modemId = modemId;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String[] getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(String[] revisionId) {
        this.revisionId = revisionId;
    }

    public List<ModemTechnologyType> getTechnologyTypes() {
        return this.technologyTypes;
    }

    public void setTechnologyTypes(List<ModemTechnologyType> technologyTypes) {
        this.technologyTypes = technologyTypes;
    }

    public boolean isPoweredOn() {
        return this.poweredOn;
    }

    public void setPoweredOn(boolean poweredOn) {
        this.poweredOn = poweredOn;
    }

    public ModemPowerMode getPowerMode() {
        return this.powerMode;
    }

    public void setPowerMode(ModemPowerMode powerMode) {
        this.powerMode = powerMode;
    }

    public ModemDevice getModemDevice() {
        return this.modemDevice;
    }

    public void setModemDevice(ModemDevice modemDevice) {
        this.modemDevice = modemDevice;
    }

    public boolean isGpsSupported() {
        return this.gpsSupported;
    }

    public void setGpsSupported(boolean gpsSupported) {
        this.gpsSupported = gpsSupported;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.revisionId);
        result = 31 * result + Objects.hash(this.gpsSupported, this.manufacturer, this.model, this.modemDevice, this.modemId, this.powerMode, this.poweredOn, this.pppNum, this.serialNumber, this.technologyTypes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModemInterfaceImpl other = (ModemInterfaceImpl)obj;
        return this.gpsSupported == other.gpsSupported && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.model, other.model) && Objects.equals(this.modemDevice, other.modemDevice) && Objects.equals(this.modemId, other.modemId) && this.powerMode == other.powerMode && this.poweredOn == other.poweredOn && this.pppNum == other.pppNum && Arrays.equals(this.revisionId, other.revisionId) && Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.technologyTypes, other.technologyTypes);
    }
}

