/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Configuration;
import com.bugsnag.Diagnostics;
import com.bugsnag.Exception;
import com.bugsnag.HandledState;
import com.bugsnag.MetaData;
import com.bugsnag.Session;
import com.bugsnag.Severity;
import com.bugsnag.ThreadState;
import com.bugsnag.serialization.Expose;
import com.bugsnag.util.FilteredMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Report {
    static final String PAYLOAD_VERSION = "4";
    private Configuration config;
    private String apiKey;
    private final Exception exception;
    private HandledState handledState;
    private Severity severity;
    private String groupingHash;
    private Diagnostics diagnostics;
    private boolean shouldCancel = false;
    private Map<String, Object> sessionMap;
    private final List<ThreadState> threadStates;

    protected Report(Configuration config, Throwable throwable) {
        this(config, throwable, HandledState.newInstance(HandledState.SeverityReasonType.REASON_HANDLED_EXCEPTION), Thread.currentThread());
    }

    Report(Configuration config, Throwable throwable, HandledState handledState, Thread currentThread) {
        this.config = config;
        this.exception = new Exception(config, throwable);
        this.handledState = handledState;
        this.severity = handledState.getOriginalSeverity();
        this.diagnostics = new Diagnostics(this.config);
        if (config.sendThreads) {
            Throwable exc = handledState.isUnhandled() ? throwable : null;
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            this.threadStates = ThreadState.getLiveThreads(config, currentThread, allStackTraces, exc);
        } else {
            this.threadStates = null;
        }
    }

    @Expose
    protected String getPayloadVersion() {
        return PAYLOAD_VERSION;
    }

    @Expose
    protected List<Exception> getExceptions() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        exceptions.add(this.exception);
        for (Throwable currentThrowable = this.exception.getThrowable().getCause(); currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
            exceptions.add(new Exception(this.config, currentThrowable));
        }
        return exceptions;
    }

    @Expose
    boolean getUnhandled() {
        return this.handledState.isUnhandled();
    }

    @Expose
    SeverityReason getSeverityReason() {
        return new SeverityReason(this.handledState.calculateSeverityReasonType().toString(), this.handledState.getSeverityReasonAttributes());
    }

    @Expose
    protected List<ThreadState> getThreads() {
        return this.threadStates;
    }

    @Expose
    public String getGroupingHash() {
        return this.groupingHash;
    }

    @Expose
    public String getSeverity() {
        return this.severity.getValue();
    }

    @Expose
    public String getContext() {
        return this.diagnostics.context;
    }

    @Expose
    public Map<String, Object> getApp() {
        return this.diagnostics.app;
    }

    @Expose
    public Map<String, Object> getDevice() {
        return this.diagnostics.device;
    }

    @Expose
    public Map<String, String> getUser() {
        return this.diagnostics.user;
    }

    @Expose
    public Map<String, Object> getMetaData() {
        return new FilteredMap(this.diagnostics.metaData, Arrays.asList(this.config.filters));
    }

    @Expose
    Map<String, Object> getSession() {
        return this.sessionMap;
    }

    void setSession(Session session) {
        if (session == null) {
            this.sessionMap = null;
        } else {
            this.sessionMap = new HashMap<String, Object>();
            this.sessionMap.put("id", session.getId());
            this.sessionMap.put("startedAt", session.getStartedAt());
            HashMap<String, Integer> handledCounts = new HashMap<String, Integer>();
            handledCounts.put("handled", session.getHandledCount());
            handledCounts.put("unhandled", session.getUnhandledCount());
            this.sessionMap.put("events", handledCounts);
        }
    }

    public Throwable getException() {
        return this.exception.getThrowable();
    }

    public String getExceptionName() {
        return this.exception.getErrorClass();
    }

    public void setExceptionName(String exceptionName) {
        this.exception.setErrorClass(exceptionName);
    }

    public String getExceptionMessage() {
        return this.exception.getThrowable().getLocalizedMessage();
    }

    public Report addToTab(String tabName, String key, Object value) {
        this.diagnostics.metaData.addToTab(tabName, key, value);
        return this;
    }

    public Report clearTab(String tabName) {
        this.diagnostics.metaData.clearTab(tabName);
        return this;
    }

    @Deprecated
    public Report setAppInfo(String key, Object value) {
        this.diagnostics.app.put(key, value);
        return this;
    }

    public Report setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    protected String getApiKey() {
        return this.apiKey;
    }

    public Report setContext(String context) {
        this.diagnostics.context = context;
        return this;
    }

    @Deprecated
    public Report setDeviceInfo(String key, Object value) {
        this.diagnostics.device.put(key, value);
        return this;
    }

    public Report setGroupingHash(String groupingHash) {
        this.groupingHash = groupingHash;
        return this;
    }

    public Report setSeverity(Severity severity) {
        this.severity = severity;
        this.handledState.setCurrentSeverity(severity);
        return this;
    }

    public Report setUser(String id, String email, String name) {
        this.diagnostics.user.put("id", id);
        this.diagnostics.user.put("email", email);
        this.diagnostics.user.put("name", name);
        return this;
    }

    public Report setUserId(String id) {
        this.diagnostics.user.put("id", id);
        return this;
    }

    public Report setUserEmail(String email) {
        this.diagnostics.user.put("email", email);
        return this;
    }

    public Report setUserName(String name) {
        this.diagnostics.user.put("name", name);
        return this;
    }

    public Report cancel() {
        this.shouldCancel = true;
        return this;
    }

    public boolean getShouldCancel() {
        return this.shouldCancel;
    }

    HandledState getHandledState() {
        return this.handledState;
    }

    void setHandledState(HandledState handledState) {
        this.handledState = handledState;
    }

    void mergeMetaData(MetaData metaData) {
        this.diagnostics.metaData.merge(metaData);
    }

    static class SeverityReason {
        private final String type;
        private final Map<String, String> attributes;

        SeverityReason(String type, Map<String, String> attributes) {
            this.type = type;
            this.attributes = attributes;
        }

        @Expose
        String getType() {
            return this.type;
        }

        @Expose
        Map<String, String> getAttributes() {
            return this.attributes;
        }
    }
}

