/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.diagnostics;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsSettings;
import org.eclipse.lsp4mp.commons.runtime.EnumConstantsProvider;
import org.eclipse.lsp4mp.commons.runtime.ExecutionMode;
import org.eclipse.lsp4mp.commons.runtime.MicroProfileProjectRuntime;
import org.eclipse.lsp4mp.jdt.core.java.AbtractJavaContext;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.config.java.MicroProfileConfigErrorCode;

public class JavaDiagnosticsContext
extends AbtractJavaContext {
    private static final Logger LOGGER = Logger.getLogger(JavaDiagnosticsContext.class.getName());
    private final List<Diagnostic> diagnostics;
    private final DocumentFormat documentFormat;
    private final MicroProfileJavaDiagnosticsSettings settings;

    public JavaDiagnosticsContext(String uri, ITypeRoot typeRoot, IJDTUtils utils, DocumentFormat documentFormat, MicroProfileJavaDiagnosticsSettings settings, List<Diagnostic> diagnostics) {
        super(uri, typeRoot, utils);
        this.diagnostics = diagnostics;
        this.documentFormat = documentFormat;
        this.settings = settings == null ? new MicroProfileJavaDiagnosticsSettings(Collections.emptyList(), DiagnosticSeverity.Error, ExecutionMode.SAFE) : settings;
    }

    public DocumentFormat getDocumentFormat() {
        return this.documentFormat;
    }

    public MicroProfileJavaDiagnosticsSettings getSettings() {
        return this.settings;
    }

    public Diagnostic addDiagnostic(String message, String source, int offset, int length, String code, DiagnosticSeverity severity) {
        try {
            ITypeRoot openable = this.getTypeRoot();
            Range range = this.getUtils().toRange((IOpenable)openable, offset, length);
            return this.addDiagnostic(message, range, source, code, severity);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while creating diagnostic '" + message + "'.", e);
            return null;
        }
    }

    public Diagnostic addDiagnostic(String message, Range range, String source, IJavaErrorCode code) {
        return this.addDiagnostic(message, range, source, code != null ? code.getCode() : null, DiagnosticSeverity.Warning);
    }

    private Diagnostic addDiagnostic(String message, Range range, String source, String code, DiagnosticSeverity severity) {
        Diagnostic d = this.createDiagnostic(message, range, source, code, severity);
        this.diagnostics.add(d);
        return d;
    }

    private Diagnostic addDiagnostic(String message, String source, ASTNode node, String code, DiagnosticSeverity severity, int start, int end) {
        return this.addDiagnostic(message, source, node.getStartPosition() + start, end, code, severity);
    }

    private Diagnostic createDiagnostic(String message, Range range, String source, String code, DiagnosticSeverity severity) {
        Diagnostic diagnostic = new Diagnostic();
        diagnostic.setSource(source);
        diagnostic.setMessage(message);
        diagnostic.setSeverity(severity);
        diagnostic.setRange(range);
        if (code != null) {
            diagnostic.setCode(code);
        }
        return diagnostic;
    }

    public void validateWithConverter(String defValue, ITypeBinding fieldBinding, Expression defaultValueExpr) {
        DiagnosticSeverity valueSeverity = this.getSettings().getValidationValueSeverity();
        MicroProfileProjectRuntime projectRuntime = super.getProjectRuntime();
        if (projectRuntime == null || valueSeverity == null) {
            return;
        }
        ExecutionMode preferredMode = this.getSettings().getMode();
        EnumConstantsProvider.SimpleEnumConstantsProvider provider = new EnumConstantsProvider.SimpleEnumConstantsProvider();
        String fqn = JavaDiagnosticsContext.toQualifiedTypeString(fieldBinding, provider);
        projectRuntime.validateValue(defValue, fqn, provider, preferredMode, (errorMessage, source, code, start, end) -> this.addDiagnostic(errorMessage, source, (ASTNode)defaultValueExpr, MicroProfileConfigErrorCode.DEFAULT_VALUE_IS_WRONG_TYPE.getCode(), valueSeverity, start + 1, end));
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

