/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.wizard.atlproject;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2m.atl.adt.wizard.atlproject.AtlDescriptionProjectScreen;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AtlProjectCreator
extends Wizard
implements INewWizard,
IExecutableExtension {
    private AtlDescriptionProjectScreen page;
    private IConfigurationElement configElement;
    private ISelection selection;
    private IProject modelProject;

    public AtlProjectCreator() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new AtlDescriptionProjectScreen(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String projectName = this.page.getProjectName();
        try {
            IWorkspace wks = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot wksroot = wks.getRoot();
            this.modelProject = wksroot.getProject(projectName);
            if (!this.modelProject.exists()) {
                this.modelProject.create(null);
            }
            if (!this.modelProject.isOpen()) {
                this.modelProject.open(null);
            }
            this.addNature(this.modelProject, "org.eclipse.m2m.atl.adt.builder.atlNature");
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        }
        catch (CoreException ce) {
            System.err.println((Object)ce);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addNature(IProject project, String natureId) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            System.err.println((Object)e);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }
}

