/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.adwp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.m2m.atl.engine.vm.NetworkDebugger;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.adwp.ADWPStackFrame;
import org.eclipse.m2m.atl.engine.vm.adwp.BooleanValue;
import org.eclipse.m2m.atl.engine.vm.adwp.IntegerValue;
import org.eclipse.m2m.atl.engine.vm.adwp.NullValue;
import org.eclipse.m2m.atl.engine.vm.adwp.ObjectReference;
import org.eclipse.m2m.atl.engine.vm.adwp.RealValue;
import org.eclipse.m2m.atl.engine.vm.adwp.StringValue;
import org.eclipse.m2m.atl.engine.vm.adwp.Value;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class LocalObjectReference
extends ObjectReference {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private static Map values = new HashMap();
    private static Map valuesById = new HashMap();
    private static int idGenerator = 0;
    private ASMOclAny object;
    private NetworkDebugger debugger;

    public static ObjectReference valueOf(int id_) {
        Integer id = new Integer(id_);
        ObjectReference ret = (ObjectReference)valuesById.get(id);
        return ret;
    }

    public static ObjectReference valueOf(ASMOclAny object, NetworkDebugger debugger) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(object);
        key.add(debugger);
        ObjectReference ret = (ObjectReference)values.get(key);
        if (ret == null) {
            int id = idGenerator++;
            ret = new LocalObjectReference(object, id, debugger);
            values.put(key, ret);
            valuesById.put(new Integer(id), ret);
        }
        return ret;
    }

    private LocalObjectReference(ASMOclAny object, int id, NetworkDebugger debugger) {
        super(id);
        this.object = object;
        this.debugger = debugger;
    }

    public Value get(String propName) {
        Value ret = null;
        ASMOclAny o = null;
        try {
            o = this.object.get(this.debugger.getExecEnv().peek(), propName);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        ret = this.asm2value(o);
        return ret;
    }

    private Value asm2value(ASMOclAny o) {
        return LocalObjectReference.asm2value(o, this.debugger);
    }

    public static Value asm2value(ASMOclAny o, NetworkDebugger debugger) {
        Value ret = null;
        ret = o instanceof ASMString ? StringValue.valueOf(((ASMString)o).getSymbol()) : (o instanceof ASMInteger ? IntegerValue.valueOf(((ASMInteger)o).getSymbol()) : (o instanceof ASMReal ? RealValue.valueOf(((ASMReal)o).getSymbol()) : (o instanceof ASMBoolean ? BooleanValue.valueOf(((ASMBoolean)o).getSymbol()) : (o == null ? new NullValue() : LocalObjectReference.valueOf(o, debugger)))));
        return ret;
    }

    public ASMOclAny value2asm(Value value) {
        ASMOclAny ret = null;
        if (value instanceof LocalObjectReference) {
            ret = ((LocalObjectReference)value).object;
        } else if (value instanceof StringValue) {
            ret = new ASMString(((StringValue)value).getValue());
        } else if (value instanceof IntegerValue) {
            ret = new ASMInteger(((IntegerValue)value).getValue());
        } else if (value instanceof RealValue) {
            ret = new ASMReal(((RealValue)value).getValue());
        } else if (value instanceof BooleanValue) {
            ret = new ASMBoolean(((BooleanValue)value).getValue());
        } else if (value instanceof NullValue) {
            ret = null;
        }
        return ret;
    }

    public void set(String propName, Value value) {
        ASMOclAny realValue = this.value2asm(value);
        this.object.set(null, propName, realValue);
    }

    public Value call(String opName, List args) {
        Value ret = null;
        Operation op = this.debugger.getExecEnv().getOperation(this.object.getType(), opName);
        if (op == null) {
            logger.severe("ERROR: operation not found: " + opName + " on " + this.object + " : " + this.object.getType());
        } else {
            ArrayList<ASMOclAny> realArgs = new ArrayList<ASMOclAny>();
            realArgs.add(this.value2asm(this));
            for (Value v : args) {
                realArgs.add(this.value2asm(v));
            }
            ASMOclAny o = op.exec(new ADWPStackFrame(op, args).enterFrame(op, realArgs));
            ret = this.asm2value(o);
        }
        return ret;
    }

    public ASMOclAny getObject() {
        return this.object;
    }
}

