/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.wizard.atlplugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2m.atl.adt.runner.CreateModuleActivatorWriter;
import org.eclipse.m2m.atl.adt.runner.CreateModuleBuildWriter;
import org.eclipse.m2m.atl.adt.runner.CreateModuleClasspathWriter;
import org.eclipse.m2m.atl.adt.runner.CreateModuleMANIFESTWriter;
import org.eclipse.m2m.atl.adt.runner.CreateModuleProjectWriter;
import org.eclipse.m2m.atl.adt.runner.CreateModulePropertiesWriter;
import org.eclipse.m2m.atl.adt.runner.CreateModuleSettingsWriter;
import org.eclipse.m2m.atl.adt.runner.CreatePluginData;
import org.eclipse.m2m.atl.adt.runner.CreateRunnableData;
import org.eclipse.m2m.atl.adt.runner.CreateRunnableJavaWriter;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.adt.ui.wizard.atlplugin.AtlPluginScreen;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class AtlPluginCreator
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String PROJECT_NAME_PREFIX = "org.eclipse.m2m.atl.";
    private static final String DEFAULT_PROJECT_NAME_SUFFIX = "sample";
    protected WizardNewProjectCreationPage newProjectPage;
    protected AtlPluginScreen parametersPage;
    protected IConfigurationElement configElement;
    private IStructuredSelection selection;

    public AtlPluginCreator() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("AtlPluginCreator.Title"));
    }

    public WizardNewProjectCreationPage getNewProjectPage() {
        return this.newProjectPage;
    }

    public AtlPluginScreen getParametersPage() {
        return this.parametersPage;
    }

    public void addPages() {
        this.newProjectPage = new WizardNewProjectCreationPage(Messages.getString("AtlPluginCreator.Page.Name"));
        this.newProjectPage.setTitle(Messages.getString("AtlPluginCreator.Title"));
        this.newProjectPage.setDescription(Messages.getString("AtlProjectCreator.Page.Description"));
        this.newProjectPage.setImageDescriptor(AtlUIPlugin.getImageDescriptor("ATLWizard.png"));
        this.parametersPage = new AtlPluginScreen(this.getClosestATLFile());
        String initialName = PROJECT_NAME_PREFIX;
        IFile atlFile = this.getClosestATLFile();
        initialName = atlFile == null ? String.valueOf(initialName) + DEFAULT_PROJECT_NAME_SUFFIX : String.valueOf(initialName) + atlFile.getFullPath().removeFileExtension().lastSegment().toLowerCase();
        this.newProjectPage.setInitialProjectName(initialName);
        this.newProjectPage.isPageComplete();
        this.addPage((IWizardPage)this.newProjectPage);
        this.addPage((IWizardPage)this.parametersPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection s) {
        this.selection = s;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.newProjectPage) {
            return this.newProjectPage.isPageComplete();
        }
        return this.parametersPage.isPageComplete();
    }

    public boolean performFinish() {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                CreatePluginData pluginData = new CreatePluginData(AtlPluginCreator.this.newProjectPage.getProjectName());
                pluginData.setRunnableData(AtlPluginCreator.this.parametersPage.getRunnableData());
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(AtlPluginCreator.this.newProjectPage.getProjectName());
                IPath location = AtlPluginCreator.this.newProjectPage.getLocationPath();
                if (!project.exists()) {
                    IProjectDescription desc = project.getWorkspace().newProjectDescription(AtlPluginCreator.this.newProjectPage.getProjectName());
                    if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)location)) {
                        location = null;
                    }
                    desc.setLocation(location);
                    project.create(desc, monitor);
                    project.open(monitor);
                    AtlPluginCreator.this.convert(project, pluginData, monitor);
                }
                if (!project.isOpen()) {
                    project.open(monitor);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(create, null);
            return true;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.m2m.atl.adt.ui", 0, e.getMessage(), (Throwable)e);
            AtlUIPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    private IFile getClosestATLFile() {
        IFile file;
        Object element;
        if (this.selection != null && (element = this.selection.getFirstElement()) instanceof IFile && "atl".equals((file = (IFile)element).getFileExtension())) {
            return file;
        }
        return null;
    }

    public void convert(IProject project, CreatePluginData pluginData, IProgressMonitor monitor) {
        CreateModuleActivatorWriter activatorWriter = new CreateModuleActivatorWriter();
        String text = activatorWriter.generate((Object)pluginData);
        Path file = new Path("/src/" + pluginData.getProjectName().replaceAll("\\.", "/") + "/Activator.java");
        AtlPluginCreator.createFile(project, (IPath)file, text, monitor);
        CreateModuleBuildWriter buildWriter = new CreateModuleBuildWriter();
        text = buildWriter.generate((Object)pluginData);
        file = new Path("build.properties");
        AtlPluginCreator.createFile(project, (IPath)file, text, monitor);
        CreateModuleClasspathWriter classpathWriter = new CreateModuleClasspathWriter();
        text = classpathWriter.generate((Object)pluginData);
        file = new Path(".classpath");
        AtlPluginCreator.createFile(project, (IPath)file, text, monitor);
        CreateModuleMANIFESTWriter manifestWriter = new CreateModuleMANIFESTWriter();
        text = manifestWriter.generate((Object)pluginData);
        file = new Path("META-INF/MANIFEST.MF");
        AtlPluginCreator.createFile(project, (IPath)file, text, monitor);
        CreateModuleProjectWriter projectWriter = new CreateModuleProjectWriter();
        text = projectWriter.generate((Object)pluginData);
        file = new Path(".project");
        AtlPluginCreator.createFile(project, (IPath)file, text, monitor);
        CreateModuleSettingsWriter settingsWriter = new CreateModuleSettingsWriter();
        text = settingsWriter.generate((Object)pluginData);
        file = new Path("/.settings/org.eclipse.jdt.core.prefs");
        AtlPluginCreator.createFile(project, (IPath)file, text, monitor);
        CreateRunnableData runnableData = pluginData.getRunnableData();
        if (runnableData != null) {
            CreateRunnableJavaWriter runnableWriter = new CreateRunnableJavaWriter();
            text = runnableWriter.generate((Object)pluginData);
            file = new Path("/src/" + project.getName().replaceAll("\\.", "/") + "/files/" + runnableData.getClassShortName() + ".java");
            AtlPluginCreator.createFile(project, (IPath)file, text, monitor);
            CreateModulePropertiesWriter propertiesWriter = new CreateModulePropertiesWriter();
            text = propertiesWriter.generate((Object)runnableData);
            file = new Path("/src/" + project.getName().replaceAll("\\.", "/") + "/files/" + runnableData.getClassShortName() + ".properties");
            AtlPluginCreator.createFile(project, (IPath)file, text, monitor);
            int i = 0;
            while (i < runnableData.getTransformationFiles().length) {
                IFile transfoFile = runnableData.getTransformationFiles()[i];
                AtlPluginCreator.copyAtlFile(project, transfoFile, (IPath)new Path("/src/" + project.getName().replaceAll("\\.", "/") + "/files/" + transfoFile.getName()), monitor);
                ++i;
            }
            for (String libraryName : runnableData.getAllLibrariesNames()) {
                IFile libraryFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path((String)runnableData.getLibraryLocations().get(libraryName)));
                AtlPluginCreator.copyAtlFile(project, libraryFile, (IPath)new Path("/src/" + project.getName().replaceAll("\\.", "/") + "/files/" + libraryFile.getName()), monitor);
            }
        }
    }

    public static void createFile(IProject project, IPath projectRelativePath, String content, IProgressMonitor monitor) {
        try {
            ByteArrayInputStream javaStream = new ByteArrayInputStream(content.getBytes("UTF8"));
            IProject container = project;
            String[] folders = projectRelativePath.removeLastSegments(1).segments();
            int i = 0;
            while (i < folders.length) {
                if (!(container = container.getFolder((IPath)new Path(folders[i]))).exists()) {
                    ((IFolder)container).create(true, true, monitor);
                }
                ++i;
            }
            IFile file = container.getFile((IPath)new Path(projectRelativePath.lastSegment()));
            if (!file.exists() && file.getParent().exists()) {
                IResource[] members = file.getParent().members(1);
                int i2 = 0;
                while (i2 < members.length) {
                    if (members[i2] instanceof IFile && file.getName().toLowerCase().equals(members[i2].getName().toLowerCase())) {
                        file = (IFile)members[i2];
                        break;
                    }
                    ++i2;
                }
            }
            if (!file.exists()) {
                file.create((InputStream)javaStream, true, monitor);
            } else {
                file.setContents((InputStream)javaStream, true, false, monitor);
            }
            javaStream.close();
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.m2m.atl.adt.ui", 0, e.getMessage(), (Throwable)e);
            AtlUIPlugin.getDefault().getLog().log((IStatus)status);
        }
        catch (UnsupportedEncodingException e) {
            Status status = new Status(4, "org.eclipse.m2m.atl.adt.ui", 0, e.getMessage(), (Throwable)e);
            AtlUIPlugin.getDefault().getLog().log((IStatus)status);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.m2m.atl.adt.ui", 0, e.getMessage(), (Throwable)e);
            AtlUIPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public static void copyAtlFile(IProject project, IFile fileToCopy, IPath targetDirRelativePath, IProgressMonitor monitor) {
        IFile atlFile;
        if ("asm".equals(fileToCopy.getFileExtension()) && (atlFile = fileToCopy.getProject().getParent().getFile(fileToCopy.getFullPath().removeFileExtension().addFileExtension("atl"))) != null && atlFile.isAccessible()) {
            AtlPluginCreator.copyFile(project, atlFile, targetDirRelativePath, monitor);
            return;
        }
        AtlPluginCreator.copyFile(project, fileToCopy, targetDirRelativePath, monitor);
    }

    public static void copyFile(IProject project, IFile fileToCopy, IPath targetDirRelativePath, IProgressMonitor monitor) {
        try {
            IProject container = project;
            String[] folders = targetDirRelativePath.removeLastSegments(1).segments();
            int i = 0;
            while (i < folders.length) {
                if (!(container = container.getFolder((IPath)new Path(folders[i]))).exists()) {
                    ((IFolder)container).create(true, true, monitor);
                }
                ++i;
            }
            fileToCopy.copy(container.getFullPath().append(fileToCopy.getName()), true, monitor);
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.m2m.atl.adt.ui", 0, e.getMessage(), (Throwable)e);
            AtlUIPlugin.getDefault().getLog().log((IStatus)status);
        }
    }
}

