/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.AssociationStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.AttributeStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.ClassStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.ElementStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.EvaluationElement;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.MappingStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.PropertyStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.TransformationStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.util.AbstractExtendingEvaluationStatusVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphBuilder;

public class EvaluationStatus2GraphVisitor
extends AbstractExtendingEvaluationStatusVisitor<String, GraphBuilder> {
    protected static @NonNull String NULL_PLACEHOLDER = "\"<null>\"";
    private Map<AssociationStatus, String> associationId = new HashMap<AssociationStatus, String>();
    private Map<ClassStatus, String> classId = new HashMap<ClassStatus, String>();
    private Map<MappingStatus, String> mappingId = new HashMap<MappingStatus, String>();

    public EvaluationStatus2GraphVisitor(@NonNull GraphBuilder context) {
        super(context);
    }

    protected @NonNull String getAssociationColor(@NonNull AssociationStatus associationStatus) {
        if (associationStatus.isIsInput()) {
            return associationStatus.isIsOutput() ? "#ccffff" : "#ccff00";
        }
        return associationStatus.isIsOutput() ? "#cc80ff" : "#cc0000";
    }

    protected @NonNull String getAssociationId(@NonNull AssociationStatus object) {
        String id = this.associationId.get(object);
        if (id == null) {
            id = "a" + this.associationId.size() + 1;
            this.associationId.put(object, id);
        }
        return id;
    }

    protected String getAssociationLabel(@NonNull AssociationStatus associationStatus) {
        EReference forwardReference = associationStatus.getForwardEReference();
        EReference oppositeReference = forwardReference.getEOpposite();
        String firstName = forwardReference.getName();
        String secondName = oppositeReference.getName();
        boolean swap = false;
        swap = forwardReference.isMany() != oppositeReference.isMany() ? forwardReference.isMany() : firstName.compareTo(secondName) > 0;
        return swap ? String.valueOf(secondName) + " / " + firstName : String.valueOf(firstName) + " / " + secondName;
    }

    protected @NonNull String getAttributeId(@NonNull AttributeStatus attributeStatus) {
        ClassStatus classStatus = attributeStatus.getOwningClassStatus();
        assert (classStatus != null);
        return String.valueOf(this.getClassId(classStatus)) + "-" + attributeStatus.getEFeature().getName();
    }

    protected @NonNull String getClassColor(@NonNull ClassStatus classStatus) {
        if (classStatus.isIsInput()) {
            return classStatus.isIsOutput() ? "#ccffff" : "#ccff00";
        }
        return classStatus.isIsOutput() ? "#cc80ff" : "#cc0000";
    }

    protected @NonNull String getClassId(@NonNull ClassStatus object) {
        String id = this.classId.get(object);
        if (id == null) {
            id = String.valueOf(object.getType().getName()) + "-" + (this.classId.size() + 1);
            this.classId.put(object, id);
        }
        return id;
    }

    protected @NonNull String getMappingId(@NonNull MappingStatus object) {
        String id = this.mappingId.get(object);
        if (id == null) {
            id = String.valueOf(object.getReferredMappingCall().getReferredMapping().getName()) + "-" + (this.mappingId.size() + 1);
            this.mappingId.put(object, id);
        }
        return id;
    }

    protected @NonNull String getPropertyId(@NonNull PropertyStatus object) {
        if (object instanceof AssociationStatus) {
            return this.getAssociationId((AssociationStatus)object);
        }
        if (object instanceof AttributeStatus) {
            return this.getAttributeId((AttributeStatus)object);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String visiting(@NonNull EvaluationElement visitable) {
        return null;
    }

    @Override
    public @Nullable String visitAssociationStatus(@NonNull AssociationStatus object) {
        String classId;
        String associationId = this.getAssociationId(object);
        String fillColor = object.isIsError() ? "#ff0000" : this.getAssociationColor(object);
        String label = this.getAssociationLabel(object);
        ((GraphBuilder)this.context).appendNode(associationId, "rectangle", fillColor, 30, 100, label);
        for (ClassStatus classStatus : object.getFromClassStatuses()) {
            if (classStatus == null) continue;
            classId = this.getClassId(classStatus);
            ((GraphBuilder)this.context).appendEdge(classId, associationId, "#339966", "line", "diamond", "none");
        }
        for (ClassStatus classStatus : object.getToClassStatuses()) {
            if (classStatus == null) continue;
            classId = this.getClassId(classStatus);
            ((GraphBuilder)this.context).appendEdge(classId, associationId, "#339966", "line", "diamond", "none");
        }
        return null;
    }

    @Override
    public @Nullable String visitAttributeStatus(@NonNull AttributeStatus object) {
        ClassStatus classStatus = object.getOwningClassStatus();
        assert (classStatus != null);
        String classId = this.getClassId(classStatus);
        String attributeId = this.getAttributeId(object);
        String fillColor = object.isIsError() ? "#ff0000" : this.getClassColor(classStatus);
        EStructuralFeature eFeature = object.getEFeature();
        String label = eFeature.getName();
        EClassifier type = eFeature.getEType();
        if (type instanceof EDataType) {
            label = String.valueOf(label) + "\n" + String.valueOf(object.getObject());
        }
        ((GraphBuilder)this.context).appendNode(attributeId, "rectangle", fillColor, 30, 50, label);
        ((GraphBuilder)this.context).appendEdge(classId, attributeId, "#339966", "line", "diamond", "none");
        return null;
    }

    @Override
    public @Nullable String visitClassStatus(@NonNull ClassStatus object) {
        String classId = this.getClassId(object);
        ((GraphBuilder)this.context).appendNode(classId, "rectangle", this.getClassColor(object), 30, 120, classId.replace("-", "\n"));
        for (AttributeStatus attributeStatus : object.getOwnedAttributeStatuses()) {
            attributeStatus.accept(this);
        }
        return null;
    }

    @Override
    public @Nullable String visitMappingStatus(@NonNull MappingStatus object) {
        String propertyId;
        PropertyStatus propertyStatus;
        String classId;
        ClassStatus classStatus;
        String mappingId = this.getMappingId(object);
        ((GraphBuilder)this.context).appendNode(mappingId, "hexagon", "#ffcc00", 30, 150, mappingId.replace("-", "\n"));
        for (ElementStatus inputStatus : object.getInputs()) {
            if (inputStatus instanceof ClassStatus) {
                classStatus = (ClassStatus)inputStatus;
                classId = this.getClassId(classStatus);
                ((GraphBuilder)this.context).appendEdge(classId, mappingId, "#000000", "line", "none", "standard");
                continue;
            }
            if (!(inputStatus instanceof PropertyStatus)) continue;
            propertyStatus = (PropertyStatus)inputStatus;
            propertyId = this.getPropertyId(propertyStatus);
            ((GraphBuilder)this.context).appendEdge(propertyId, mappingId, "#000000", "dashed", "none", "standard");
        }
        for (ElementStatus outputStatus : object.getOutputs()) {
            if (outputStatus instanceof ClassStatus) {
                classStatus = (ClassStatus)outputStatus;
                classId = this.getClassId(classStatus);
                ((GraphBuilder)this.context).appendEdge(mappingId, classId, "#000000", "line", "none", "standard");
                continue;
            }
            if (!(outputStatus instanceof PropertyStatus)) continue;
            propertyStatus = (PropertyStatus)outputStatus;
            propertyId = this.getPropertyId(propertyStatus);
            ((GraphBuilder)this.context).appendEdge(mappingId, propertyId, "#000000", "dashed", "none", "standard");
        }
        return null;
    }

    @Override
    public @Nullable String visitTransformationStatus(@NonNull TransformationStatus object) {
        ((GraphBuilder)this.context).open();
        for (ClassStatus classStatus : object.getOwnedClassStatuses()) {
            classStatus.accept(this);
        }
        for (MappingStatus mappingStatus : object.getOwnedMappingStatuses()) {
            mappingStatus.accept(this);
        }
        for (AssociationStatus associationStatus : object.getOwnedAssociationStatuses()) {
            associationStatus.accept(this);
        }
        ((GraphBuilder)this.context).close();
        return null;
    }
}

