/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.PrimitiveLiteralExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.ResultVariable;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.NavigationEdgeSorter;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.NavigationForestBuilder;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.CheckStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.DeclareStatement;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.LoopVariable;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.util.AbstractExtendingQVTimperativeVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.StatementComparator;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;

public class BasicRegion2Mapping
extends AbstractRegion2Mapping {
    private final @NonNull List<@NonNull Node> headNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> guardNodes = new ArrayList<Node>();
    private final @NonNull Map<@NonNull Node, @NonNull VariableDeclaration> node2variable = new HashMap<Node, VariableDeclaration>();

    public BasicRegion2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull Region region) {
        super(visitor, region);
        String name = region.getName();
        this.createHeadAndGuardNodeVariables();
        this.createNavigablePredicates();
        this.createExternalPredicates();
        this.createRealizedVariables();
        this.createPropertyAssignments();
        this.createAddStatements();
        this.createRealizedIncludesAssignments();
        this.createObservedProperties();
    }

    public @Nullable VariableDeclaration basicGetVariable(@NonNull Node node) {
        return this.node2variable.get(node);
    }

    private void createAddStatements() {
        if (this.connection2variable != null) {
            for (NodeConnection connection : this.connection2variable.keySet()) {
                Node sourceNode = connection.getSource(this.region);
                OCLExpression variableExpression = this.createVariableExp(sourceNode);
                ConnectionVariable connectionVariable = (ConnectionVariable)this.connection2variable.get(connection);
                assert (connectionVariable != null);
                this.createAddStatement(connectionVariable, variableExpression);
            }
        }
    }

    private @NonNull DeclareStatement createBottomVariable(@NonNull Node node, @NonNull OCLExpression initExpression) {
        Class variableType = node.getCompleteClass().getPrimaryClass();
        assert (variableType != null);
        boolean isRequired = node.isMatched();
        for (TypedElement typedElement : node.getTypedElements()) {
            if (typedElement.isIsRequired()) continue;
            isRequired = false;
        }
        if (initExpression.isIsRequired()) {
            isRequired = true;
        }
        String safeName = this.getSafeName(node);
        DeclareStatement newVariable = this.helper.createDeclareStatement(safeName, (Type)variableType, isRequired, initExpression);
        this.mapping.getOwnedStatements().add((Object)newVariable);
        VariableDeclaration oldVariable = this.node2variable.put(node, (VariableDeclaration)newVariable);
        assert (oldVariable == null);
        return newVariable;
    }

    private void createCastPredicates(@NonNull Node sourceNode, @NonNull VariableDeclaration sourceVariable) {
        for (NavigableEdge edge : sourceNode.getNavigationEdges()) {
            if (!edge.isCast() || !edge.isUnconditional()) continue;
            Node targetNode = RegionUtil.getTargetNode((Edge)edge);
            Property castProperty = RegionUtil.getProperty((NavigableEdge)edge);
            Type targetType = PivotUtil.getType((TypedElement)castProperty);
            VariableExp sourceExpression = this.helper.createVariableExp(sourceVariable);
            VariableDeclaration targetVariable = this.node2variable.get(targetNode);
            if (targetVariable == null) {
                boolean isRequired = sourceVariable.isIsRequired();
                String safeName = this.getSafeName(PivotUtil.getName((NamedElement)sourceVariable));
                DeclareStatement declareStatement = this.helper.createDeclareStatement(safeName, targetType, isRequired, (OCLExpression)sourceExpression);
                declareStatement.setIsCheck(true);
                this.mapping.getOwnedStatements().add((Object)declareStatement);
                targetVariable = declareStatement;
                this.node2variable.put(targetNode, targetVariable);
                this.createCastPredicates(targetNode, targetVariable);
                continue;
            }
            TypeExp typeExpression = this.helper.createTypeExp(targetType);
            OperationCallExp conditionExpression = this.helper.createOperationCallExp((OCLExpression)sourceExpression, "oclIsKindOf", new OCLExpression[]{typeExpression});
            CheckStatement checkStatement = this.helper.createCheckStatement((OCLExpression)conditionExpression);
            this.mapping.getOwnedStatements().add((Object)checkStatement);
        }
    }

    private void createClassSetStatements(@NonNull Iterable<@NonNull List<@NonNull NavigableEdge>> classAssignments) {
        for (List<NavigableEdge> edges : classAssignments) {
            for (NavigableEdge edge : edges) {
                Node sourceNode = edge.getEdgeSource();
                Node targetNode = edge.getEdgeTarget();
                VariableDeclaration slotVariable = this.getVariable(sourceNode);
                Property property = RegionUtil.getProperty((NavigableEdge)edge);
                OCLExpression targetVariableExp = this.createVariableExp(targetNode);
                boolean isNotify = this.isHazardousWrite(edge);
                SetStatement setStatement = this.helper.createSetStatement(slotVariable, property, targetVariableExp, edge.isPartial(), isNotify);
                this.mapping.getOwnedStatements().add((Object)setStatement);
            }
        }
    }

    private void createExternalPredicates() {
        for (Edge edge : RegionUtil.getOwnedEdges((Region)this.region)) {
            if (!edge.isPredicate()) continue;
            ExpressionCreator expressionCreator = new ExpressionCreator();
            ExpressionCreator inlineExpressionCreator = expressionCreator.getInlineExpressionCreator();
            Node sourceNode = edge.getEdgeSource();
            Node targetNode = edge.getEdgeTarget();
            OCLExpression conditionExpression = inlineExpressionCreator.getExpression(sourceNode);
            assert (conditionExpression != null);
            if (!targetNode.isTrue()) {
                String name = ((String)ClassUtil.nonNullState((Object)edge.getName())).trim();
                if (name.length() >= 2) {
                    name = name.substring(1, name.length() - 1);
                }
                OCLExpression targetExpression = inlineExpressionCreator.getExpression(targetNode);
                assert (targetExpression != null);
                conditionExpression = this.helper.createOperationCallExp(conditionExpression, name, new OCLExpression[]{targetExpression});
            }
            CheckStatement asPredicate = this.helper.createCheckStatement(conditionExpression);
            this.mapping.getOwnedStatements().add((Object)asPredicate);
        }
    }

    private @NonNull GuardParameter createGuardParameter(@NonNull Node guardNode) {
        ClassDatumAnalysis classDatumAnalysis = RegionUtil.getClassDatumAnalysis(guardNode);
        Class variableType = guardNode.getCompleteClass().getPrimaryClass();
        ImperativeTypedModel iTypedModel = (ImperativeTypedModel)ClassUtil.nonNullState((Object)this.visitor.getQVTiTypedModel(classDatumAnalysis.getClassDatum().getReferredTypedModel()));
        GuardParameter guardVariable = this.helper.createGuardParameter(this.getSafeName(guardNode), iTypedModel, (Type)variableType, true);
        this.mapping.getOwnedMappingParameters().add((Object)guardVariable);
        VariableDeclaration oldVariable = this.node2variable.put(guardNode, (VariableDeclaration)guardVariable);
        assert (oldVariable == null);
        return guardVariable;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createHeadAndGuardNodeVariables() {
        HashSet<@NonNull Region> headCallingRegions = new HashSet<Region>();
        @NonNull Iterable recursionEdges = this.region.getRecursionEdges();
        if (Iterables.size((Iterable)recursionEdges) > 0) {
            headCallingRegions.add(this.region);
        }
        for (Node headNode : RegionUtil.getHeadNodes((Region)this.region)) {
            if (headNode.isTrue() || headNode.isDependency()) continue;
            Node bestHeadNode = null;
            @NonNull Iterable callingSources = headNode.getPassedBindingSources();
            if (!Iterables.isEmpty((Iterable)callingSources)) {
                bestHeadNode = headNode;
            }
            for (Node callingSource : callingSources) {
                headCallingRegions.add(RegionUtil.getOwningRegion((Node)callingSource));
            }
            if (bestHeadNode != null) {
                this.headNodes.add(bestHeadNode);
                continue;
            }
            this.visitor.addProblem(RegionUtil.createRegionError(this.region, "No best head", new Object[0]));
        }
        this.guardNodes.addAll(this.headNodes);
        Collections.sort(this.guardNodes, NameUtil.NAMEABLE_COMPARATOR);
        for (Node guardNode : this.guardNodes) {
            assert (!guardNode.isDependency());
            this.createGuardParameter(guardNode);
        }
        this.createAppendParameters();
    }

    private void createMappingStatements(@NonNull Map<@NonNull Region, @NonNull Map<@NonNull Node, @NonNull Node>> calls) {
        ArrayList<@NonNull MappingCall> mappingStatements = new ArrayList<MappingCall>();
        HashMap<@NonNull LoopVariable, @NonNull OCLExpression> loopVariables = null;
        for (Map.Entry<Region, Map<Node, Node>> entry : calls.entrySet()) {
            @NonNull Region calledRegion = entry.getKey();
            AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(calledRegion);
            ArrayList<@NonNull MappingParameterBinding> mappingParameterBindings = new ArrayList<MappingParameterBinding>();
            for (Map.Entry<Node, Node> entry2 : entry.getValue().entrySet()) {
                @NonNull Node sourceNode = entry2.getKey();
                @NonNull Node targetNode = entry2.getValue();
                OCLExpression sourceExpression = this.getSourceExpression(sourceNode);
                Type type = sourceExpression.getType();
                if (type instanceof CollectionType) {
                    if (loopVariables == null) {
                        loopVariables = new HashMap<LoopVariable, OCLExpression>();
                    }
                    Type elementType = ((CollectionType)type).getElementType();
                    assert (elementType != null);
                    LoopVariable loopVariable = this.helper.createLoopVariable(this.getSafeName("loop" + loopVariables.size()), elementType);
                    loopVariables.put(loopVariable, sourceExpression);
                    MappingParameter guardVariable = calledRegion2Mapping.getGuardVariable(targetNode);
                    mappingParameterBindings.add((MappingParameterBinding)this.helper.createLoopParameterBinding((GuardParameter)guardVariable, loopVariable));
                    continue;
                }
                MappingParameter guardVariable = calledRegion2Mapping.getGuardVariable(targetNode);
                mappingParameterBindings.add((MappingParameterBinding)this.helper.createSimpleParameterBinding((SimpleParameter)guardVariable, sourceExpression));
            }
            Collections.sort(mappingParameterBindings, QVTimperativeUtil.MappingParameterBindingComparator.INSTANCE);
            MappingCall mappingCallStatement = calledRegion2Mapping.createMappingCall(mappingParameterBindings);
            if (loopVariables != null) {
                for (Map.Entry loopEntry : loopVariables.entrySet()) {
                    @NonNull LoopVariable loopVariable = (LoopVariable)loopEntry.getKey();
                    @NonNull OCLExpression loopSource = (OCLExpression)loopEntry.getValue();
                    mappingCallStatement = this.helper.createMappingLoop(loopSource, loopVariable, (MappingStatement)mappingCallStatement);
                }
            }
            mappingStatements.add(mappingCallStatement);
        }
        this.mapping.getOwnedStatements().addAll(mappingStatements);
    }

    private void createNavigablePredicates() {
        OCLExpression sourceExp;
        Property property;
        Node targetNode;
        Node sourceNode;
        String name = this.region.getName();
        ArrayList<@NonNull NavigableEdge> forestEdges = new ArrayList<NavigableEdge>();
        for (NavigableEdge edge : this.region.getNavigationEdges()) {
            if (!edge.isUnconditional()) continue;
            forestEdges.add(edge);
        }
        NavigationForestBuilder navigationForest = new NavigationForestBuilder(this.guardNodes, forestEdges);
        for (NavigableEdge traversedEdge : navigationForest.getForestNavigations()) {
            sourceNode = traversedEdge.getEdgeSource();
            targetNode = traversedEdge.getEdgeTarget();
            property = RegionUtil.getProperty((NavigableEdge)traversedEdge);
            sourceExp = this.createVariableExp(sourceNode);
            CallExp source2targetExp = this.createCallExp(sourceExp, property);
            if (!targetNode.isExplicitNull()) {
                VariableDeclaration nodeVariable = this.node2variable.get(targetNode);
                assert (nodeVariable == null);
                DeclareStatement declareStatement = this.createBottomVariable(targetNode, (OCLExpression)source2targetExp);
                this.createCastPredicates(targetNode, (VariableDeclaration)declareStatement);
                continue;
            }
            NullLiteralExp targetExp = this.helper.createNullLiteralExp();
            OperationCallExp conditionExpression = this.helper.createOperationCallExp((OCLExpression)source2targetExp, "=", new OCLExpression[]{targetExp});
            CheckStatement checkStatement = this.helper.createCheckStatement((OCLExpression)conditionExpression);
            this.mapping.getOwnedStatements().add((Object)checkStatement);
        }
        for (NavigableEdge untraversedEdge : navigationForest.getGraphPredicates()) {
            sourceNode = untraversedEdge.getEdgeSource();
            if (sourceNode.isDependency()) continue;
            targetNode = untraversedEdge.getEdgeTarget();
            property = RegionUtil.getProperty((NavigableEdge)untraversedEdge);
            sourceExp = this.createVariableExp(sourceNode);
            OCLExpression targetExp = this.createVariableExp(targetNode);
            CallExp source2targetExp = this.createCallExp(sourceExp, property);
            OperationCallExp matchesExp = targetNode.isExplicitNull() ? this.helper.createOperationCallExp((OCLExpression)source2targetExp, "=", new OCLExpression[]{targetExp}) : this.helper.createOperationCallExp(targetExp, "=", new OCLExpression[]{source2targetExp});
            CheckStatement asPredicate = this.helper.createCheckStatement((OCLExpression)matchesExp);
            this.mapping.getOwnedStatements().add((Object)asPredicate);
        }
    }

    private void createObservedProperties() {
        HashSet<@NonNull Property> allCheckedProperties = new HashSet<Property>();
        RootDomainUsageAnalysis.DomainUsageConstant anyUsage = RegionUtil.getScheduleManager(this.region).getDomainAnalysis().getAnyUsage();
        for (TypedModel qvtmTypedModel : anyUsage.getTypedModels()) {
            Set<@NonNull NavigableEdge> checkedEdges = RegionAnalysis.get(this.region).getCheckedEdges(qvtmTypedModel);
            if (checkedEdges == null) continue;
            for (NavigableEdge checkedEdge : checkedEdges) {
                Property asProperty = RegionUtil.getProperty((NavigableEdge)checkedEdge);
                allCheckedProperties.add(asProperty);
                Property asOppositeProperty = asProperty.getOpposite();
                if (asOppositeProperty == null) continue;
                allCheckedProperties.add(asOppositeProperty);
            }
        }
        for (Statement asStatement : this.mapping.getOwnedStatements()) {
            if (!(asStatement instanceof ObservableStatement)) continue;
            EList observedProperties = ((ObservableStatement)asStatement).getObservedProperties();
            for (EObject eObject : new TreeIterable((EObject)asStatement, false)) {
                Property property;
                if (eObject instanceof PropertyCallExp) {
                    property = PivotUtil.getReferredProperty((NavigationCallExp)((PropertyCallExp)eObject));
                    if (!allCheckedProperties.contains(property) || observedProperties.contains(property)) continue;
                    observedProperties.add(property);
                    continue;
                }
                if (!(eObject instanceof OppositePropertyCallExp) || !allCheckedProperties.contains(property = PivotUtil.getReferredProperty((NavigationCallExp)((NavigationCallExp)eObject)).getOpposite()) || observedProperties.contains(property)) continue;
                observedProperties.add(property);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createPropertyAssignments() {
        HashMap<@NonNull Node, @NonNull ArrayList<@NonNull NavigableEdge>> classAssignments = null;
        for (NavigableEdge edge : NavigationEdgeSorter.getSortedAssignments(this.region.getRealizedNavigationEdges())) {
            ArrayList<NavigableEdge> edges;
            Node sourceNode = edge.getEdgeSource();
            Node targetNode = edge.getEdgeTarget();
            if (targetNode.isDataType()) {
                VariableDeclaration asVariable = this.getVariable(sourceNode);
                Property property = RegionUtil.getProperty((NavigableEdge)edge);
                ExpressionCreator expressionCreator = new ExpressionCreator();
                OCLExpression valueExp = expressionCreator.getExpression(targetNode);
                if (valueExp == null) {
                    ExpressionCreator expressionCreator2 = new ExpressionCreator();
                    valueExp = expressionCreator2.getExpression(targetNode);
                }
                if (valueExp != null) {
                    boolean isNotify = this.isHazardousWrite(edge);
                    SetStatement setStatement = this.helper.createSetStatement(asVariable, property, valueExp, edge.isPartial(), isNotify);
                    this.mapping.getOwnedStatements().add((Object)setStatement);
                    continue;
                }
                System.err.println("No assignment in " + this + " to " + asVariable + "." + property);
                continue;
            }
            if (classAssignments == null) {
                classAssignments = new HashMap<Node, ArrayList<NavigableEdge>>();
            }
            if ((edges = (ArrayList<NavigableEdge>)classAssignments.get(sourceNode)) == null) {
                edges = new ArrayList<NavigableEdge>();
                classAssignments.put(sourceNode, edges);
            }
            edges.add(edge);
        }
        if (classAssignments != null) {
            this.pruneClassAssignments(classAssignments);
            Collection<@NonNull List<@NonNull NavigableEdge>> values = classAssignments.values();
            this.createClassSetStatements(values);
        }
        @NonNull @NonNull EList statements = this.mapping.getOwnedStatements();
        ECollections.sort((EList)statements, (Comparator)new StatementComparator((List)statements));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createRealizedIncludesAssignments() {
        @NonNull List realizedIncludesEdges = null;
        for (Edge edge : this.region.getRealizedEdges()) {
        }
        if (realizedIncludesEdges != null) {
            if (realizedIncludesEdges.size() > 1) {
                Collections.sort(realizedIncludesEdges, NameUtil.ToStringComparator.INSTANCE);
            }
            for (Edge edge : realizedIncludesEdges) {
                Node sourceNode = edge.getEdgeSource();
                Node node = edge.getEdgeTarget();
            }
        }
    }

    private void createRealizedVariables() {
        for (Node newNode : this.region.getNewNodes()) {
            if (!newNode.isClass()) continue;
            ExpressionCreator expressionCreator = new ExpressionCreator();
            OCLExpression constructor = null;
            if (newNode.isOperation()) {
                constructor = (OCLExpression)((OperationCallExp)newNode.getTypedElements().iterator().next()).accept((Visitor)expressionCreator);
            }
            ClassDatum classDatum = newNode.getClassDatum();
            TypedModel pTypedModel = classDatum.getReferredTypedModel();
            ImperativeTypedModel iTypedModel = (ImperativeTypedModel)ClassUtil.nonNullState((Object)this.visitor.getQVTiTypedModel(pTypedModel));
            NewStatement newStatement = this.helper.createNewStatement(this.getSafeName(newNode), iTypedModel, (Type)classDatum.getCompleteClass().getPrimaryClass());
            newStatement.setOwnedExpression(constructor);
            newStatement.setIsContained(newNode.isContained());
            this.mapping.getOwnedStatements().add((Object)newStatement);
            VariableDeclaration oldVariable = this.node2variable.put(newNode, (VariableDeclaration)newStatement);
            assert (oldVariable == null);
        }
    }

    @Override
    public void createSchedulingStatements() {
        HashMap<@NonNull Region, @NonNull HashMap<@NonNull K, @NonNull V>> calls = null;
        for (Region calledRegion : this.region.getCallableChildren()) {
            HashMap<Node, Node> source2target;
            if (calls == null) {
                calls = new HashMap();
            }
            if ((source2target = (HashMap<Node, Node>)calls.get(calledRegion)) == null) {
                source2target = new HashMap<Node, Node>();
                calls.put(calledRegion, source2target);
            }
            AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(calledRegion);
            for (Node calledGuardNode : calledRegion2Mapping.getGuardNodes()) {
                Node oldNode;
                for (Node callingNode : calledGuardNode.getPassedBindingSources()) {
                    if (callingNode.getOwningRegion() != this.region) continue;
                    oldNode = source2target.put(callingNode, calledGuardNode);
                    assert (oldNode == null);
                }
                for (Node callingNode : calledGuardNode.getUsedBindingSources()) {
                    if (callingNode.getOwningRegion() != this.region) continue;
                    oldNode = source2target.put(callingNode, calledGuardNode);
                    assert (oldNode == null);
                }
            }
        }
        if (calls != null) {
            this.createMappingStatements(calls);
        }
    }

    private @NonNull OCLExpression createVariableExp(@NonNull Node node) {
        if (node.isExplicitNull()) {
            return this.helper.createNullLiteralExp();
        }
        VariableDeclaration variable = this.getVariable(node);
        return PivotUtil.createVariableExp((VariableDeclaration)variable);
    }

    @Override
    public @NonNull List<@NonNull Node> getGuardNodes() {
        return this.guardNodes;
    }

    @Override
    public @NonNull MappingParameter getGuardVariable(@NonNull Node node) {
        VariableDeclaration variable = this.node2variable.get(node);
        assert (variable != null);
        return (MappingParameter)variable;
    }

    private @NonNull OCLExpression getSourceExpression(@NonNull Node sourceNode) {
        return this.createVariableExp(sourceNode);
    }

    protected @NonNull VariableDeclaration getVariable(Node node) {
        VariableDeclaration variable = this.node2variable.get(node);
        if (variable == null) {
            ExpressionCreator expressionCreator = new ExpressionCreator();
            TypedElement expression = (TypedElement)node.getTypedElements().iterator().next();
            OCLExpression initExpression = (OCLExpression)expression.accept((Visitor)expressionCreator);
            variable = this.createBottomVariable(node, initExpression);
        }
        return variable;
    }

    private boolean isIfExp(@NonNull Node node) {
        if (node.isExpression()) {
            for (TypedElement typedElement : node.getTypedElements()) {
                if (!(typedElement instanceof IfExp)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isHazardousWrite(@NonNull NavigableEdge edge) {
        Node sourceNode = edge.getEdgeSource();
        Property asProperty = edge.getProperty();
        TypedModel typedModel = RegionUtil.getTypedModel(RegionUtil.getClassDatumAnalysis(sourceNode));
        Set<@NonNull NavigableEdge> enforcedEdges = RegionAnalysis.get(this.region).getEnforcedEdges(typedModel);
        if (enforcedEdges != null) {
            Property asOppositeProperty = asProperty.getOpposite();
            for (NavigableEdge enforcedEdge : enforcedEdges) {
                Property edgeProperty = enforcedEdge.getProperty();
                if (edgeProperty != asProperty && edgeProperty != asOppositeProperty) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isInfinite() {
        return this.region.getRecursionEdges().iterator().hasNext();
    }

    private void pruneClassAssignments(@NonNull Map<@NonNull Node, @NonNull List<@NonNull NavigableEdge>> classAssignments) {
        for (Node sourceNode : new ArrayList<Node>(classAssignments.keySet())) {
            List<@NonNull NavigableEdge> forwardEdges = classAssignments.get(sourceNode);
            assert (forwardEdges != null);
            int iForward = forwardEdges.size() - 1;
            while (iForward >= 0) {
                NavigableEdge forwardEdge = forwardEdges.get(iForward);
                Node targetNode = forwardEdge.getEdgeTarget();
                List<@NonNull NavigableEdge> reverseEdges = classAssignments.get(targetNode);
                if (reverseEdges != null) {
                    int iReverse = reverseEdges.size() - 1;
                    while (iReverse >= 0) {
                        NavigableEdge reverseEdge = reverseEdges.get(iReverse);
                        if (sourceNode == reverseEdge.getEdgeTarget()) {
                            Property forwardProperty = forwardEdge.getProperty();
                            Property reverseProperty = reverseEdge.getProperty();
                            if (forwardProperty.getOpposite() == reverseProperty) {
                                if (forwardProperty.isIsImplicit()) {
                                    forwardEdges.remove(forwardEdge);
                                } else if (reverseProperty.isIsImplicit()) {
                                    reverseEdges.remove(reverseEdge);
                                } else if (sourceNode.isDependency()) {
                                    forwardEdges.remove(forwardEdge);
                                } else if (targetNode.isDependency()) {
                                    reverseEdges.remove(reverseEdge);
                                } else {
                                    reverseEdges.remove(reverseEdge);
                                }
                            }
                        }
                        --iReverse;
                    }
                }
                --iForward;
            }
        }
    }

    private class ExpressionCreator
    extends AbstractExtendingQVTimperativeVisitor<OCLExpression, BasicRegion2Mapping> {
        protected final @NonNull Set<@NonNull Node> multiAccessedNodes;
        protected final @NonNull Set<@NonNull Node> conditionalNodes;
        private ExpressionCreator inlineExpressionCreator;

        public ExpressionCreator() {
            super((Object)BasicRegion2Mapping.this);
            this.multiAccessedNodes = new HashSet<Node>();
            this.conditionalNodes = new HashSet<Node>();
            this.inlineExpressionCreator = null;
            this.analyzeExpressions(this.multiAccessedNodes, this.conditionalNodes);
        }

        protected void addNavigation(@NonNull Property asProperty) {
        }

        private void analyzeExpressions(@NonNull Set<Node> multiAccessedNodes, @NonNull Set<Node> conditionalNodes) {
            HashSet<@NonNull Node> unconditionalNodes = new HashSet<Node>();
            for (Edge edge : BasicRegion2Mapping.this.region.getRealizedEdges()) {
                this.analyzeIncomingPath(edge.getEdgeTarget(), unconditionalNodes, conditionalNodes, false);
            }
            conditionalNodes.removeAll(unconditionalNodes);
            for (Node node : unconditionalNodes) {
                int accesses = 0;
                for (Edge outgoingEdge : RegionUtil.getOutgoingEdges((Node)node)) {
                    if (!outgoingEdge.isNavigation() && !outgoingEdge.isComputation()) continue;
                    ++accesses;
                }
                if (accesses <= true) continue;
                multiAccessedNodes.add(node);
            }
        }

        private void analyzeIncomingPath(@NonNull Node node, @NonNull Set<Node> unconditionalNodes, @NonNull Set<Node> conditionalNodes, boolean isConditional) {
            if ((isConditional ? conditionalNodes : unconditionalNodes).add(node)) {
                boolean isIf = BasicRegion2Mapping.this.isIfExp(node);
                for (Edge edge : RegionUtil.getIncomingEdges((Node)node)) {
                    if (edge.isComputation()) {
                        boolean isIfThenOrElse = isIf && ("then".equals(edge.getName()) || "else".equals(edge.getName()));
                        this.analyzeIncomingPath(edge.getEdgeSource(), unconditionalNodes, conditionalNodes, isConditional || isIfThenOrElse);
                        continue;
                    }
                    if (!edge.isNavigation()) continue;
                    this.analyzeIncomingPath(edge.getEdgeSource(), unconditionalNodes, conditionalNodes, isConditional);
                }
                return;
            }
        }

        protected @NonNull OCLExpression create(Node node) {
            if (node.isExplicitNull()) {
                return BasicRegion2Mapping.this.helper.createNullLiteralExp();
            }
            VariableDeclaration theVariable = (VariableDeclaration)BasicRegion2Mapping.this.node2variable.get(node);
            if (theVariable == null) {
                TypedElement oldTypedElement = (TypedElement)node.getTypedElements().iterator().next();
                assert (oldTypedElement != null);
                OCLExpression initExpression = (OCLExpression)oldTypedElement.accept((Visitor)this);
                assert (initExpression != null);
                if (initExpression instanceof PrimitiveLiteralExp || this.hasRealizedVariableReference(initExpression) || this.conditionalNodes.contains(node)) {
                    return initExpression;
                }
                theVariable = BasicRegion2Mapping.this.createBottomVariable(node, initExpression);
            }
            return PivotUtil.createVariableExp((VariableDeclaration)theVariable);
        }

        private @Nullable OCLExpression create(@Nullable OCLExpression oldTypedElement) {
            if (oldTypedElement == null) {
                return null;
            }
            Node node = ((BasicRegion2Mapping)this.context).getNode((TypedElement)oldTypedElement);
            if (node == null) {
                node = ((BasicRegion2Mapping)this.context).getNode((TypedElement)oldTypedElement);
            }
            if (node != null) {
                return this.create(node);
            }
            return (OCLExpression)oldTypedElement.accept((Visitor)this);
        }

        private @NonNull List<@NonNull OCLExpression> createAll(@NonNull List<@NonNull OCLExpression> oldTypedElements) {
            ArrayList<@NonNull OCLExpression> newTypedElements = new ArrayList<OCLExpression>(oldTypedElements.size());
            for (OCLExpression oldTypedElement : oldTypedElements) {
                OCLExpression newTypedElement = this.create(oldTypedElement);
                assert (newTypedElement != null);
                newTypedElements.add(newTypedElement);
            }
            return newTypedElements;
        }

        private @NonNull Variable createIteratorVariable(@NonNull Variable oldVariable) {
            String name = oldVariable.getName();
            assert (name != null);
            Type type = oldVariable.getType();
            assert (type != null);
            assert (oldVariable.getOwnedInit() == null);
            IteratorVariable newVariable = BasicRegion2Mapping.this.helper.createIteratorVariable(name, type, oldVariable.isIsRequired());
            Node variableNode = BasicRegion2Mapping.this.getNode((TypedElement)oldVariable);
            if (variableNode != null) {
                BasicRegion2Mapping.this.node2variable.put(variableNode, newVariable);
            }
            return newVariable;
        }

        private @NonNull List<@NonNull Variable> createIteratorVariables(@NonNull List<@NonNull Variable> oldVariables) {
            ArrayList<@NonNull Variable> newVariables = new ArrayList<Variable>(oldVariables.size());
            for (Variable oldVariable : oldVariables) {
                Variable newVariable = this.createIteratorVariable(oldVariable);
                newVariables.add(newVariable);
            }
            return newVariables;
        }

        private @NonNull Variable createLetVariable(@NonNull Variable oldVariable) {
            String name = oldVariable.getName();
            assert (name != null);
            Type type = oldVariable.getType();
            assert (type != null);
            OCLExpression newInit = (OCLExpression)ClassUtil.nonNullState((Object)this.create(oldVariable.getOwnedInit()));
            LetVariable newVariable = BasicRegion2Mapping.this.helper.createLetVariable(name, type, oldVariable.isIsRequired(), newInit);
            Node variableNode = BasicRegion2Mapping.this.getNode((TypedElement)oldVariable);
            if (variableNode != null) {
                BasicRegion2Mapping.this.node2variable.put(variableNode, newVariable);
            }
            return newVariable;
        }

        private @NonNull OCLExpression createNonNull(@Nullable OCLExpression oldTypedElement) {
            assert (oldTypedElement != null);
            Node node = ((BasicRegion2Mapping)this.context).getNode((TypedElement)oldTypedElement);
            if (node == null) {
                node = ((BasicRegion2Mapping)this.context).getNode((TypedElement)oldTypedElement);
            }
            return this.create(node);
        }

        private @NonNull Variable createResultVariable(@NonNull Variable oldVariable) {
            String name = oldVariable.getName();
            assert (name != null);
            Type type = oldVariable.getType();
            assert (type != null);
            OCLExpression newInit = (OCLExpression)ClassUtil.nonNullState((Object)this.create(oldVariable.getOwnedInit()));
            ResultVariable newVariable = BasicRegion2Mapping.this.helper.createResultVariable(name, type, oldVariable.isIsRequired(), newInit);
            Node variableNode = BasicRegion2Mapping.this.getNode((TypedElement)oldVariable);
            if (variableNode != null) {
                BasicRegion2Mapping.this.node2variable.put(variableNode, newVariable);
            }
            return newVariable;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable OCLExpression getExpression(@NonNull Node node) {
            if (node.isExplicitNull()) {
                return BasicRegion2Mapping.this.helper.createNullLiteralExp();
            }
            VariableDeclaration variable = (VariableDeclaration)BasicRegion2Mapping.this.node2variable.get(node);
            if (variable != null) {
                return PivotUtil.createVariableExp((VariableDeclaration)variable);
            }
            if (node.isOperation()) {
                @NonNull Iterable typedElements = node.getTypedElements();
                assert (Iterables.size((Iterable)typedElements) >= 1);
                return (OCLExpression)((TypedElement)typedElements.iterator().next()).accept((Visitor)this.getInlineExpressionCreator());
            }
            Iterator iterator = node.getArgumentEdges().iterator();
            if (iterator.hasNext()) {
                VariableDeclaration referredVariable;
                @NonNull Edge edge = (Edge)iterator.next();
                Node expNode = edge.getEdgeSource();
                OCLExpression clonedElement = this.create(expNode);
                if (clonedElement instanceof VariableExp && (referredVariable = ((VariableExp)clonedElement).getReferredVariable()) instanceof Variable) {
                    BasicRegion2Mapping.this.node2variable.put(node, referredVariable);
                }
                return clonedElement;
            }
            for (Edge edge : RegionUtil.getIncomingEdges((Node)node)) {
                OCLExpression source;
                if (!edge.isNavigation()) continue;
                Role edgeRole = RegionUtil.getEdgeRole((Edge)edge);
                if (edgeRole == Role.LOADED) {
                    source = this.getExpression(edge.getEdgeSource());
                    if (source == null) continue;
                    return BasicRegion2Mapping.this.helper.createNavigationCallExp(source, RegionUtil.getProperty((NavigableEdge)((NavigableEdge)edge)));
                }
                if (edgeRole != Role.PREDICATED) continue;
                source = this.create(edge.getEdgeSource());
                return BasicRegion2Mapping.this.helper.createNavigationCallExp(source, RegionUtil.getProperty((NavigableEdge)((NavigableEdge)edge)));
            }
            for (Edge edge : RegionUtil.getIncomingEdges((Node)node)) {
                if (!edge.isExpression()) continue;
                OCLExpression source = this.create(edge.getEdgeSource());
                return source;
            }
            return null;
        }

        public @NonNull ExpressionCreator getInlineExpressionCreator() {
            ExpressionCreator inlineExpressionCreator2 = this.inlineExpressionCreator;
            if (inlineExpressionCreator2 == null) {
                this.inlineExpressionCreator = inlineExpressionCreator2 = new InlineExpressionCreator(this);
            }
            return inlineExpressionCreator2;
        }

        private boolean hasRealizedVariableReference(@NonNull OCLExpression oclExpression) {
            TreeIterator tit = oclExpression.eAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof VariableExp) || !(((VariableExp)eObject).getReferredVariable() instanceof NewStatement)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " " + BasicRegion2Mapping.this.region;
        }

        public @NonNull OCLExpression visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }

        public @NonNull OCLExpression visitCollectionLiteralExp(@NonNull CollectionLiteralExp pCollectionLiteralExp) {
            ArrayList<@NonNull Object> clonedParts = new ArrayList<Object>();
            for (CollectionLiteralPart pPart : ClassUtil.nullFree((List)pCollectionLiteralExp.getOwnedParts())) {
                if (pPart instanceof CollectionItem) {
                    OCLExpression item = this.createNonNull(((CollectionItem)pPart).getOwnedItem());
                    clonedParts.add(BasicRegion2Mapping.this.helper.createCollectionItem(item));
                    continue;
                }
                CollectionRange pCollectionRange = (CollectionRange)pPart;
                OCLExpression first = this.createNonNull(pCollectionRange.getOwnedFirst());
                OCLExpression last = this.createNonNull(pCollectionRange.getOwnedLast());
                clonedParts.add(BasicRegion2Mapping.this.helper.createCollectionRange(first, last));
            }
            CollectionType collectionType = (CollectionType)pCollectionLiteralExp.getType();
            assert (collectionType != null);
            return BasicRegion2Mapping.this.helper.createCollectionLiteralExp(collectionType, clonedParts);
        }

        public @NonNull OCLExpression visitEnumLiteralExp(@NonNull EnumLiteralExp pEnumLiteralExp) {
            return (OCLExpression)EcoreUtil.copy((EObject)pEnumLiteralExp);
        }

        public @NonNull OCLExpression visitIfExp(@NonNull IfExp pIfExp) {
            MetamodelManager metamodelManager = BasicRegion2Mapping.this.visitor.getMetamodelManager();
            ExpressionCreator inlineExpressionCreator = this.getInlineExpressionCreator();
            return ((PivotMetamodelManager)metamodelManager).createIfExp(this.createNonNull(pIfExp.getOwnedCondition()), inlineExpressionCreator.createNonNull(pIfExp.getOwnedThen()), inlineExpressionCreator.createNonNull(pIfExp.getOwnedElse()));
        }

        public @NonNull OCLExpression visitIterateExp(@NonNull IterateExp pIterateExp) {
            OCLExpression iSource = this.create(pIterateExp.getOwnedSource());
            assert (iSource != null);
            List<@NonNull Variable> iIterators = this.createIteratorVariables(ClassUtil.nullFree((List)pIterateExp.getOwnedIterators()));
            Variable result = this.createResultVariable((Variable)ClassUtil.nonNull((Object)pIterateExp.getOwnedResult()));
            Iteration referredIteration = (Iteration)BasicRegion2Mapping.this.visitor.create((Operation)pIterateExp.getReferredIteration());
            assert (referredIteration != null);
            OCLExpression iBody = this.getInlineExpressionCreator().create(pIterateExp.getOwnedBody());
            assert (iBody != null);
            return BasicRegion2Mapping.this.helper.createIterateExp(iSource, referredIteration, iIterators, result, iBody);
        }

        public @NonNull OCLExpression visitIteratorExp(@NonNull IteratorExp pIteratorExp) {
            OCLExpression iSource = this.create(pIteratorExp.getOwnedSource());
            assert (iSource != null);
            List<@NonNull Variable> iIterators = this.createIteratorVariables(ClassUtil.nullFree((List)pIteratorExp.getOwnedIterators()));
            Iteration referredIteration = (Iteration)BasicRegion2Mapping.this.visitor.create((Operation)pIteratorExp.getReferredIteration());
            assert (referredIteration != null);
            OCLExpression iBody = this.getInlineExpressionCreator().create(pIteratorExp.getOwnedBody());
            assert (iBody != null);
            return BasicRegion2Mapping.this.helper.createIteratorExp(iSource, referredIteration, iIterators, iBody);
        }

        public @NonNull OCLExpression visitLetExp(@NonNull LetExp pLetExp) {
            Variable asVariable = this.createLetVariable((Variable)ClassUtil.nonNull((Object)pLetExp.getOwnedVariable()));
            OCLExpression asInExpression = this.create(pLetExp.getOwnedIn());
            assert (asInExpression != null);
            return BasicRegion2Mapping.this.helper.createLetExp(asVariable, asInExpression);
        }

        public @NonNull OCLExpression visitMapLiteralExp(@NonNull MapLiteralExp pMapLiteralExp) {
            ArrayList<@NonNull MapLiteralPart> clonedParts = new ArrayList<MapLiteralPart>();
            for (MapLiteralPart pPart : ClassUtil.nullFree((List)pMapLiteralExp.getOwnedParts())) {
                OCLExpression key = this.createNonNull(pPart.getOwnedKey());
                OCLExpression value = this.createNonNull(pPart.getOwnedValue());
                clonedParts.add(BasicRegion2Mapping.this.helper.createMapLiteralPart(key, value));
            }
            MapType mapType = (MapType)pMapLiteralExp.getType();
            assert (mapType != null);
            return BasicRegion2Mapping.this.helper.createMapLiteralExp(mapType, clonedParts);
        }

        public @NonNull OCLExpression visitOperationCallExp(@NonNull OperationCallExp pOperationCallExp) {
            OCLExpression iSource = this.create(pOperationCallExp.getOwnedSource());
            List<@NonNull OCLExpression> iArguments = this.createAll(ClassUtil.nullFree((List)pOperationCallExp.getOwnedArguments()));
            Operation referredOperation = BasicRegion2Mapping.this.visitor.create(pOperationCallExp.getReferredOperation());
            assert (referredOperation != null);
            if (iSource == null && referredOperation instanceof Function) {
                ScheduleManager scheduleManager = RegionUtil.getScheduleManager(BasicRegion2Mapping.this.getRegion());
                StandardLibrary standardLibrary = scheduleManager.getStandardLibrary();
                Variable thisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)BasicRegion2Mapping.this.visitor.getTransformation());
                iSource = PivotUtil.createVariableExp((VariableDeclaration)thisVariable);
            }
            return BasicRegion2Mapping.this.helper.createOperationCallExp(iSource, referredOperation, iArguments);
        }

        public @NonNull OCLExpression visitNavigationCallExp(@NonNull NavigationCallExp pNavigationCallExp) {
            OCLExpression iSource = this.createNonNull(pNavigationCallExp.getOwnedSource());
            Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)pNavigationCallExp);
            this.addNavigation(referredProperty);
            return BasicRegion2Mapping.this.helper.createNavigationCallExp(iSource, referredProperty);
        }

        public @NonNull OCLExpression visitPrimitiveLiteralExp(@NonNull PrimitiveLiteralExp pPrimitiveLiteralExp) {
            return (OCLExpression)EcoreUtil.copy((EObject)pPrimitiveLiteralExp);
        }

        public @NonNull OCLExpression visitShadowExp(@NonNull ShadowExp pShadowExp) {
            ArrayList<@NonNull ShadowPart> clonedParts = new ArrayList<ShadowPart>();
            for (ShadowPart pPart : ClassUtil.nullFree((List)pShadowExp.getOwnedParts())) {
                OCLExpression init = this.createNonNull(pPart.getOwnedInit());
                String name = pPart.getName();
                Type type = pPart.getType();
                assert (name != null && type != null);
                Property referredProperty = pPart.getReferredProperty();
                assert (referredProperty != null);
                clonedParts.add(BasicRegion2Mapping.this.helper.createShadowPart(referredProperty, init));
            }
            Class shadowType = pShadowExp.getType();
            assert (shadowType != null);
            return BasicRegion2Mapping.this.helper.createShadowExp(shadowType, clonedParts);
        }

        public @NonNull OCLExpression visitTupleLiteralExp(@NonNull TupleLiteralExp pTupleLiteralExp) {
            ArrayList<@NonNull TupleLiteralPart> clonedParts = new ArrayList<TupleLiteralPart>();
            for (TupleLiteralPart pPart : ClassUtil.nullFree((List)pTupleLiteralExp.getOwnedParts())) {
                OCLExpression init = this.createNonNull(pPart.getOwnedInit());
                String name = pPart.getName();
                Type type = pPart.getType();
                assert (name != null && type != null);
                clonedParts.add(BasicRegion2Mapping.this.helper.createTupleLiteralPart(name, type, pPart.isIsRequired(), init));
            }
            TupleType tupleType = (TupleType)pTupleLiteralExp.getType();
            assert (tupleType != null);
            return BasicRegion2Mapping.this.helper.createTupleLiteralExp(tupleType, clonedParts);
        }

        public @NonNull OCLExpression visitTypeExp(@NonNull TypeExp pTypeExp) {
            Type referredType = pTypeExp.getReferredType();
            assert (referredType != null);
            return BasicRegion2Mapping.this.helper.createTypeExp(referredType);
        }

        public @NonNull OCLExpression visitVariableExp(@NonNull VariableExp pVariableExp) {
            VariableDeclaration pVariable = pVariableExp.getReferredVariable();
            Node node = BasicRegion2Mapping.this.getNode((TypedElement)pVariable);
            if (node == null) {
                ScheduleManager scheduleManager = RegionUtil.getScheduleManager(BasicRegion2Mapping.this.getRegion());
                StandardLibrary standardLibrary = scheduleManager.getStandardLibrary();
                Transformation pTransformation = QVTbaseUtil.getContainingTransformation((EObject)pVariableExp);
                Variable pThisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)pTransformation);
                if (pVariableExp.getReferredVariable() == pThisVariable) {
                    Variable iThisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)BasicRegion2Mapping.this.visitor.getTransformation());
                    return PivotUtil.createVariableExp((VariableDeclaration)iThisVariable);
                }
            }
            if (node != null) {
                VariableDeclaration iVariable = BasicRegion2Mapping.this.basicGetVariable(node);
                assert (iVariable != null);
                return PivotUtil.createVariableExp((VariableDeclaration)iVariable);
            }
            System.err.println("Creating unexpected variable for " + pVariable + " in " + BasicRegion2Mapping.this.region);
            Type variableType = pVariable.getType();
            assert (variableType != null);
            String safeName = BasicRegion2Mapping.this.getSafeName((String)ClassUtil.nonNullState((Object)pVariable.getName()));
            DeclareStatement iVariable = BasicRegion2Mapping.this.helper.createDeclareStatement(safeName, variableType, pVariable.isIsRequired(), (OCLExpression)BasicRegion2Mapping.this.helper.createNullLiteralExp());
            BasicRegion2Mapping.this.mapping.getOwnedStatements().add((Object)iVariable);
            return PivotUtil.createVariableExp((VariableDeclaration)iVariable);
        }
    }

    private class InlineExpressionCreator
    extends ExpressionCreator {
        protected final @NonNull ExpressionCreator expressionCreator;

        private InlineExpressionCreator(ExpressionCreator expressionCreator) {
            this.expressionCreator = expressionCreator;
        }

        @Override
        protected void addNavigation(@NonNull Property asProperty) {
            this.expressionCreator.addNavigation(asProperty);
        }

        @Override
        public @NonNull OCLExpression create(Node node) {
            if (node.isExplicitNull()) {
                return BasicRegion2Mapping.this.helper.createNullLiteralExp();
            }
            VariableDeclaration theVariable = (VariableDeclaration)BasicRegion2Mapping.this.node2variable.get(node);
            if (theVariable == null) {
                TypedElement oldTypedElement = (TypedElement)node.getTypedElements().iterator().next();
                assert (oldTypedElement != null);
                if (oldTypedElement instanceof Variable && ((Variable)oldTypedElement).getOwnedInit() == null) {
                    for (Edge edge : RegionUtil.getIncomingEdges((Node)node)) {
                        if (edge.isExpression() && "\u00abequals\u00bb".equals(edge.getName())) {
                            Node edgeSource = edge.getEdgeSource();
                            return this.create(edgeSource);
                        }
                        if (!edge.isCast()) continue;
                        throw new UnsupportedOperationException();
                    }
                } else {
                    return (OCLExpression)oldTypedElement.accept((Visitor)this);
                }
                assert (theVariable != null);
            }
            return PivotUtil.createVariableExp((VariableDeclaration)theVariable);
        }
    }
}

