/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.NumericLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.util.AbstractExtendingQVTbaseVisitor;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseHelper;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionRangeNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EnumLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.IfNode;
import org.eclipse.qvtd.pivot.qvtschedule.MapLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationCallNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ShadowNode;
import org.eclipse.qvtd.pivot.qvtschedule.TupleLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.TypeLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.Utility;
import org.eclipse.qvtd.pivot.qvtschedule.impl.RuleRegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeLibraryHelper;

public abstract class ExpressionSynthesizer
extends AbstractExtendingQVTbaseVisitor<Node, RuleAnalysis> {
    protected final @NonNull Utility utility;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull QVTbaseHelper helper;
    protected final @NonNull StandardLibraryHelper standardLibraryHelper;
    protected final @NonNull QVTruntimeLibraryHelper qvtbaseLibraryHelper;
    protected final @NonNull ExpressionSynthesizer nonNullMatchedExpressionSynthesizer;
    private ExpressionSynthesizer nullableMatchedExpressionSynthesizer = null;
    private ExpressionSynthesizer nullableConditionalExpressionSynthesizer = null;
    private ExpressionSynthesizer nonNullConditionalExpressionSynthesizer = null;
    private @Nullable Map<@NonNull OCLExpression, @NonNull Node> expression2knownNode;

    protected ExpressionSynthesizer(@NonNull RuleAnalysis context, @Nullable ExpressionSynthesizer unconditionalExpressionSynthesizer, @NonNull Utility resultUtility) {
        super((Object)context);
        this.utility = resultUtility;
        switch (resultUtility) {
            case NON_NULL_MATCHED: {
                assert (unconditionalExpressionSynthesizer == null);
                break;
            }
            case NULLABLE_MATCHED: {
                assert (unconditionalExpressionSynthesizer != null);
                break;
            }
            case NON_NULL_CONDITIONAL: {
                assert (unconditionalExpressionSynthesizer != null);
                break;
            }
            case NULLABLE_CONDITIONAL: {
                assert (unconditionalExpressionSynthesizer != null);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.nonNullMatchedExpressionSynthesizer = unconditionalExpressionSynthesizer != null ? unconditionalExpressionSynthesizer : this;
        this.scheduleManager = context.getScheduleManager();
        this.environmentFactory = this.scheduleManager.getEnvironmentFactory();
        this.helper = new QVTbaseHelper(this.environmentFactory);
        this.standardLibraryHelper = this.scheduleManager.getStandardLibraryHelper();
        this.qvtbaseLibraryHelper = this.scheduleManager.getQVTruntimeLibraryHelper();
    }

    protected @NonNull Node createBooleanLiteralNode(boolean booleanValue, @NonNull BooleanLiteralExp booleanLiteralExp) {
        Utility utility = this.getRequiredUtility((TypedElement)booleanLiteralExp);
        return ((RuleAnalysis)((Object)this.context)).createBooleanLiteralNode(utility, booleanValue, booleanLiteralExp);
    }

    public @NonNull CastEdge createCastEdge(@NonNull Node sourceNode, @NonNull ClassDatum classDatum, @NonNull Node castNode) {
        Utility utility = this.getRequiredUtility(castNode);
        return ((RuleAnalysis)((Object)this.context)).createCastEdge(utility, sourceNode, classDatum, castNode);
    }

    protected @NonNull Node createCollectionLiteral(@NonNull CollectionLiteralExp collectionLiteralExp, @NonNull CollectionLiteralPart[] collectionParts, @NonNull Node @NonNull [] partNodes) {
        Utility utility = this.getRequiredUtility((TypedElement)collectionLiteralExp);
        Operation collectionOperation = this.qvtbaseLibraryHelper.getCollectionOperation();
        assert (collectionParts.length == partNodes.length);
        Node reusedNode = this.findOperationNode(collectionOperation, partNodes);
        if (reusedNode != null) {
            return reusedNode;
        }
        String nodeName = CompilerUtil.recoverVariableName((NamedElement)collectionLiteralExp);
        if (nodeName == null) {
            nodeName = QVTbaseUtil.getName((NamedElement)collectionOperation);
        }
        CollectionLiteralNode collectionLiteralNode = ((RuleAnalysis)((Object)this.context)).createCollectionLiteralNode(utility, nodeName, collectionLiteralExp, partNodes);
        int i = 0;
        while (i < collectionParts.length) {
            CollectionLiteralPart collectionPart = collectionParts[i];
            Utility partUtility = this.getRequiredUtility((TypedElement)collectionPart);
            ((RuleAnalysis)((Object)this.context)).createCollectionPartEdge(partUtility, partNodes[i], collectionPart, (Node)collectionLiteralNode);
            ++i;
        }
        return collectionLiteralNode;
    }

    protected @NonNull Node createCollectionRange(@NonNull Utility utility, @NonNull CollectionRange collectionRange, @NonNull Node firstNode, @NonNull Node lastNode) {
        Operation rangeOperation = this.qvtbaseLibraryHelper.getRangeOperation();
        Node[] sourceAndArgumentNodes = new Node[]{firstNode, lastNode};
        Node reusedNode = this.findOperationNode(rangeOperation, sourceAndArgumentNodes);
        if (reusedNode != null) {
            return reusedNode;
        }
        String nodeName = CompilerUtil.recoverVariableName((NamedElement)collectionRange);
        if (nodeName == null) {
            nodeName = QVTbaseUtil.getName((NamedElement)rangeOperation);
        }
        CollectionRangeNode operationNode = ((RuleAnalysis)((Object)this.context)).createCollectionRangeNode(utility, nodeName, collectionRange, sourceAndArgumentNodes);
        Parameter firstParameter = this.qvtbaseLibraryHelper.getRangeFirstParameter();
        Parameter lastParameter = this.qvtbaseLibraryHelper.getRangeLastParameter();
        this.createOperationParameterEdge(firstNode, firstParameter, -1, (Node)operationNode);
        this.createOperationParameterEdge(lastNode, lastParameter, -1, (Node)operationNode);
        return operationNode;
    }

    protected @NonNull Node createDataTypeNode(@NonNull String name, @NonNull Node sourceNode, @NonNull NavigationCallExp navigationCallExp) {
        Utility utility = this.getRequiredUtility((TypedElement)navigationCallExp);
        return ((RuleAnalysis)((Object)this.context)).createDataTypeNode(utility, name, sourceNode, navigationCallExp);
    }

    protected @NonNull Edge createDependencyEdge(@NonNull Node sourceNode, @NonNull String name, @NonNull Node targetNode) {
        return ((RuleAnalysis)((Object)this.context)).createDependencyEdge(Utility.DEPENDENCY, sourceNode, name, targetNode);
    }

    protected @NonNull Node createDependencyNode(@NonNull String name, @NonNull ClassDatum classDatum) {
        return ((RuleAnalysis)((Object)this.context)).createDependencyNode(Utility.DEPENDENCY, name, classDatum);
    }

    protected @NonNull EnumLiteralNode createEnumLiteralNode(@NonNull EnumerationLiteral enumValue, @NonNull EnumLiteralExp enumLiteralExp) {
        Utility utility = this.getRequiredUtility((TypedElement)enumLiteralExp);
        return ((RuleAnalysis)((Object)this.context)).createEnumLiteralNode(utility, enumValue, enumLiteralExp);
    }

    protected @NonNull Node createErrorNode(@NonNull String name, @NonNull ClassDatum classDatum) {
        return ((RuleAnalysis)((Object)this.context)).createErrorNode(name, classDatum);
    }

    protected @NonNull Edge createEqualsEdge(@NonNull Node sourceNode, @NonNull Node targetNode) {
        return ((RuleAnalysis)((Object)this.context)).createEqualsEdge(this.utility, sourceNode, targetNode);
    }

    protected abstract @NonNull ExpressionSynthesizer createExpressionSynthesizer(@NonNull Utility var1);

    protected @NonNull IfNode createIfNode(@NonNull IfExp ifExp, @NonNull String name, @NonNull Node @NonNull [] sourceAndArgumentNodes) {
        Utility utility = this.getRequiredUtility((TypedElement)ifExp);
        return ((RuleAnalysis)((Object)this.context)).createIfNode(utility, name, ifExp, sourceAndArgumentNodes);
    }

    protected @NonNull Edge createIteratedEdge(@NonNull Node sourceNode, @NonNull Node targetNode) {
        Utility utility = this.getRequiredUtility(targetNode);
        return ((RuleAnalysis)((Object)this.context)).createIteratedEdge(utility, sourceNode, targetNode);
    }

    protected @NonNull Node createIteratorNode(@NonNull Variable iterator, @NonNull Node sourceNode) {
        Utility utility = this.getRequiredUtility((TypedElement)iterator);
        return ((RuleAnalysis)((Object)this.context)).createIteratorNode(utility, (VariableDeclaration)iterator, sourceNode);
    }

    protected @NonNull Node createLetNode(@NonNull Variable letVariable, @NonNull Node inNode) {
        Utility utility = this.getRequiredUtility((TypedElement)letVariable);
        return ((RuleAnalysis)((Object)this.context)).createLetVariableNode(utility, (VariableDeclaration)letVariable, inNode);
    }

    protected @NonNull Node createMapLiteral(@NonNull MapLiteralExp mapLiteralExp, @NonNull MapLiteralPart[] mapParts, @NonNull Node @NonNull [] partNodes) {
        Utility utility = this.getRequiredUtility((TypedElement)mapLiteralExp);
        assert (mapParts.length == partNodes.length);
        Operation mapOperation = this.qvtbaseLibraryHelper.getMapOperation();
        Node reusedNode = this.findOperationNode(mapOperation, partNodes);
        if (reusedNode != null) {
            return reusedNode;
        }
        String nodeName = CompilerUtil.recoverVariableName((NamedElement)mapLiteralExp);
        if (nodeName == null) {
            nodeName = QVTbaseUtil.getName((NamedElement)mapOperation);
        }
        MapLiteralNode mapLiteralNode = ((RuleAnalysis)((Object)this.context)).createMapLiteralNode(utility, nodeName, mapLiteralExp, partNodes);
        int i = 0;
        while (i < mapParts.length) {
            MapLiteralPart mapPart = mapParts[i];
            Utility partUtility = utility;
            ((RuleAnalysis)((Object)this.context)).createMapPartEdge(partUtility, partNodes[i], mapPart, (Node)mapLiteralNode);
            ++i;
        }
        return mapLiteralNode;
    }

    protected @NonNull Node createMapPart(@NonNull MapLiteralPart mapLiteralPart, @NonNull Node keyNode, @NonNull Node valueNode) {
        OCLExpression typedElement = QVTbaseUtil.getOwnedValue((MapLiteralPart)mapLiteralPart);
        Operation partOperation = this.qvtbaseLibraryHelper.getMapPartOperation();
        Node[] subPartNodes = new Node[]{keyNode, valueNode};
        Node reusedNode = this.findOperationNode(partOperation, subPartNodes);
        if (reusedNode != null) {
            return reusedNode;
        }
        String nodeName = CompilerUtil.recoverVariableName((NamedElement)typedElement);
        if (nodeName == null) {
            nodeName = QVTbaseUtil.getName((NamedElement)partOperation);
        }
        Node operationNode = ((RuleAnalysis)((Object)this.context)).createMapPartNode(this.utility, nodeName, mapLiteralPart, subPartNodes);
        Parameter keyParameter = this.qvtbaseLibraryHelper.getMapPartKeyParameter();
        Parameter valueParameter = this.qvtbaseLibraryHelper.getMapPartValueParameter();
        this.createOperationParameterEdge(keyNode, keyParameter, -1, operationNode);
        this.createOperationParameterEdge(valueNode, valueParameter, -1, operationNode);
        return operationNode;
    }

    protected @NonNull Node createNavigableDataTypeNode(@NonNull Node sourceNode, @NonNull Property source2targetProperty) {
        Utility utility = this.getRequiredUtility((TypedElement)source2targetProperty);
        return ((RuleAnalysis)((Object)this.context)).createDataTypeNode(utility, sourceNode, source2targetProperty);
    }

    protected @NonNull NavigableEdge createNavigableNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode) {
        Utility utility = this.getRequiredUtility(targetNode);
        return ((RuleAnalysis)((Object)this.context)).createNavigationEdge(utility, sourceNode, source2targetProperty, targetNode, false);
    }

    public @NonNull NavigableEdge createNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, boolean isPartial) {
        Utility utility = this.getRequiredUtility(targetNode);
        return ((RuleAnalysis)((Object)this.context)).createNavigationEdge(utility, sourceNode, source2targetProperty, targetNode, isPartial);
    }

    protected @NonNull NavigableEdge createNavigationOrRealizedEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        NavigableEdge navigationEdge = sourceNode.getOutgoingNavigableEdge(source2targetProperty);
        assert (navigationEdge == null);
        boolean isPartial = navigationAssignment != null ? navigationAssignment.isIsPartial() : this.scheduleManager.computeIsPartial(targetNode, source2targetProperty);
        navigationEdge = navigationAssignment != null || ((RuleAnalysis)((Object)this.context)).isPropertyAssignment(sourceNode, source2targetProperty) ? this.createRealizedNavigationEdge(sourceNode, source2targetProperty, targetNode, isPartial) : this.createNavigationEdge(sourceNode, source2targetProperty, targetNode, isPartial);
        return navigationEdge;
    }

    protected @NonNull Node createNullLiteralNode() {
        return ((RuleAnalysis)((Object)this.context)).createNullLiteralNode(this.utility, null);
    }

    protected @NonNull Node createNullLiteralNode(@NonNull NullLiteralExp nullLiteralExp) {
        Utility utility = this.getRequiredUtility((TypedElement)nullLiteralExp);
        return ((RuleAnalysis)((Object)this.context)).createNullLiteralNode(utility, nullLiteralExp);
    }

    protected @NonNull Node createNumericLiteralNode(@NonNull Number numberValue, @NonNull NumericLiteralExp numericLiteralExp) {
        Utility utility = this.getRequiredUtility((TypedElement)numericLiteralExp);
        return ((RuleAnalysis)((Object)this.context)).createNumericLiteralNode(utility, numberValue, numericLiteralExp);
    }

    protected @NonNull Node createOperationCallNode(@NonNull CallExp callExp, @NonNull Operation operation, @NonNull Node @NonNull [] sourceAndArgumentNodes) {
        Node reusedNode = this.findOperationNode(operation, sourceAndArgumentNodes);
        assert (reusedNode == null);
        String nameHint = CompilerUtil.recoverVariableName((NamedElement)callExp);
        Utility utility = this.getRequiredUtility((TypedElement)callExp);
        OperationCallNode operationNode = ((RuleAnalysis)((Object)this.context)).createOperationCallNode(utility, nameHint, operation, (TypedElement)callExp, sourceAndArgumentNodes);
        return operationNode;
    }

    protected @NonNull Node createOperationCallNode2(@NonNull String nameHint, @NonNull Role nodeRole, @NonNull Operation operation, @NonNull ClassDatum classDatum, Node ... sourceAndArgumentNodes) {
        OperationCallNode operationNode = ((RuleAnalysis)((Object)this.context)).createOperationCallNode2(nodeRole, this.utility, nameHint, operation, classDatum, sourceAndArgumentNodes);
        return operationNode;
    }

    protected @NonNull Edge createOperationParameterEdge(@NonNull Node sourceNode, @NonNull Parameter parameter, int parameterIndex, @NonNull Node targetNode) {
        Utility utility = this.getRequiredUtility(sourceNode);
        return ((RuleAnalysis)((Object)this.context)).createOperationParameterEdge(utility, sourceNode, parameter, parameterIndex, targetNode);
    }

    protected @NonNull Edge createOperationSelfEdge(@NonNull Node sourceNode, @NonNull Type type, @NonNull Node targetNode) {
        Utility utility = this.getRequiredUtility(sourceNode);
        return ((RuleAnalysis)((Object)this.context)).createOperationSelfEdge(utility, sourceNode, type, targetNode);
    }

    protected @NonNull Edge createPredicateEdge(@NonNull Utility utility, @NonNull Node sourceNode, @Nullable String name, @NonNull Node targetNode) {
        return ((RuleAnalysis)((Object)this.context)).createPredicateEdge(utility, sourceNode, name, targetNode);
    }

    public @NonNull NavigableEdge createRealizedNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, boolean isPartial) {
        Utility utility = this.getRequiredUtility(targetNode);
        return ((RuleAnalysis)((Object)this.context)).createRealizedNavigationEdge(utility, sourceNode, source2targetProperty, targetNode, isPartial);
    }

    protected @NonNull Node createShadow(@NonNull ShadowExp shadowExp, @NonNull ShadowPart[] shadowParts, @NonNull Node @NonNull [] partNodes) {
        Utility utility = this.getRequiredUtility((TypedElement)shadowExp);
        assert (shadowParts.length == partNodes.length);
        Operation shadowOperation = this.qvtbaseLibraryHelper.getShadowOperation();
        Node reusedNode = this.findOperationNode(shadowOperation, partNodes);
        if (reusedNode != null) {
            return reusedNode;
        }
        String nodeName = CompilerUtil.recoverVariableName((NamedElement)shadowExp);
        if (nodeName == null) {
            nodeName = QVTbaseUtil.getName((NamedElement)shadowOperation);
        }
        ShadowNode shadowLiteralNode = ((RuleAnalysis)((Object)this.context)).createShadowNode(utility, nodeName, shadowExp, partNodes);
        int i = 0;
        while (i < shadowParts.length) {
            ShadowPart shadowPart = shadowParts[i];
            Utility partUtility = this.getRequiredUtility((TypedElement)shadowPart);
            ((RuleAnalysis)((Object)this.context)).createShadowPartEdge(partUtility, partNodes[i], shadowPart, (Node)shadowLiteralNode);
            ++i;
        }
        return shadowLiteralNode;
    }

    protected @NonNull Node createStepNode(@NonNull String name, @NonNull CallExp callExp, @NonNull Node sourceNode) {
        Utility utility = this.getRequiredUtility((TypedElement)callExp);
        return ((RuleAnalysis)((Object)this.context)).createStepNode(utility, name, callExp, sourceNode);
    }

    protected @NonNull Node createStringLiteralNode(@NonNull String stringValue, @NonNull StringLiteralExp stringLiteralExp) {
        Utility utility = this.getRequiredUtility((TypedElement)stringLiteralExp);
        return ((RuleAnalysis)((Object)this.context)).createStringLiteralNode(utility, stringValue, stringLiteralExp);
    }

    protected @NonNull Node createTupleLiteral(@NonNull TupleLiteralExp tupleLiteralExp, @NonNull TupleLiteralPart[] tupleParts, @NonNull Node @NonNull [] partNodes) {
        Utility utility = this.getRequiredUtility((TypedElement)tupleLiteralExp);
        assert (tupleParts.length == partNodes.length);
        Operation tupleOperation = this.qvtbaseLibraryHelper.getTupleOperation();
        Node reusedNode = this.findOperationNode(tupleOperation, partNodes);
        if (reusedNode != null) {
            return reusedNode;
        }
        String nodeName = CompilerUtil.recoverVariableName((NamedElement)tupleLiteralExp);
        if (nodeName == null) {
            nodeName = QVTbaseUtil.getName((NamedElement)tupleOperation);
        }
        TupleLiteralNode tupleLiteralNode = ((RuleAnalysis)((Object)this.context)).createTupleLiteralNode(utility, nodeName, tupleLiteralExp, partNodes);
        int i = 0;
        while (i < tupleParts.length) {
            TupleLiteralPart tuplePart = tupleParts[i];
            Utility partUtility = this.getRequiredUtility((TypedElement)tuplePart);
            ((RuleAnalysis)((Object)this.context)).createTuplePartEdge(partUtility, partNodes[i], tuplePart, (Node)tupleLiteralNode);
            ++i;
        }
        return tupleLiteralNode;
    }

    protected @NonNull TypeLiteralNode createTypeLiteralNode(@NonNull Type typeValue, @NonNull TypeExp typeExp) {
        return ((RuleAnalysis)((Object)this.context)).createTypeLiteralNode(this.getRequiredUtility((TypedElement)typeExp), typeValue, typeExp);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Node doLoopExp(@NonNull LoopExp loopExp, @NonNull Node sourceNode) {
        Node bodyNode;
        ExpressionSynthesizer conditionalExpressionSynthesizer = this.getExpressionSynthesizer(this.utility.getConditionalUtility());
        @NonNull List ownedIterators = ClassUtil.nullFree((List)loopExp.getOwnedIterators());
        @NonNull Node[] argNodes = new Node[1 + ownedIterators.size() + (loopExp instanceof IterateExp ? 1 : 0)];
        int i = 1;
        for (Variable iterator : ownedIterators) {
            Node iteratorNode = conditionalExpressionSynthesizer.createIteratorNode(iterator, sourceNode);
            Type iteratorType = QVTbaseUtil.getType((TypedElement)iterator);
            conditionalExpressionSynthesizer.createIteratedEdge(sourceNode, iteratorNode);
            argNodes[i++] = iteratorNode;
        }
        if (loopExp instanceof IterateExp) {
            Variable accumulator = QVTbaseUtil.getOwnedResult((IterateExp)((IterateExp)loopExp));
            Node iteratorNode = conditionalExpressionSynthesizer.createIteratorNode(accumulator, sourceNode);
            Type iteratorType = QVTbaseUtil.getType((TypedElement)accumulator);
            conditionalExpressionSynthesizer.createIteratedEdge(sourceNode, iteratorNode);
            argNodes[i++] = iteratorNode;
        }
        argNodes[0] = bodyNode = conditionalExpressionSynthesizer.synthesize((Visitable)loopExp.getOwnedBody());
        Iteration referredIteration = QVTbaseUtil.getReferredIteration((LoopExp)loopExp);
        Node accumulateNode = this.findOperationNode((Operation)referredIteration, argNodes);
        if (accumulateNode == null) {
            accumulateNode = this.createOperationCallNode((CallExp)loopExp, (Operation)referredIteration, argNodes);
            this.createOperationParameterEdge(sourceNode, this.qvtbaseLibraryHelper.getLoopSourceParameter(), -1, accumulateNode);
            conditionalExpressionSynthesizer.createOperationParameterEdge(bodyNode, this.qvtbaseLibraryHelper.getLoopBodyParameter(), -1, accumulateNode);
            int j = 1;
            while (j <= ownedIterators.size()) {
                conditionalExpressionSynthesizer.createOperationParameterEdge(argNodes[j], this.qvtbaseLibraryHelper.getLoopIteratorsParameter(), j - 1, accumulateNode);
                ++j;
            }
        }
        return accumulateNode;
    }

    protected @NonNull Node doNavigationCallExp(@NonNull NavigationCallExp navigationCallExp, @NonNull Node sourceNode) {
        Property referredProperty = QVTbaseUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
        if (sourceNode.isClass()) {
            Node targetNode;
            NavigableEdge navigationEdge;
            if (!referredProperty.isIsMany() && (navigationEdge = sourceNode.getOutgoingNavigableEdge(referredProperty)) != null) {
                return navigationEdge.getEdgeTarget();
            }
            String name = CompilerUtil.recoverVariableName((NamedElement)navigationCallExp);
            if (name == null) {
                name = QVTbaseUtil.getName((NamedElement)referredProperty);
            }
            Type type = QVTbaseUtil.getType((TypedElement)referredProperty);
            Node node = targetNode = this.expression2knownNode != null ? this.expression2knownNode.get(navigationCallExp) : null;
            if (targetNode == null) {
                if (type instanceof DataType) {
                    targetNode = sourceNode.getNavigableTarget(referredProperty);
                    if (targetNode == null) {
                        targetNode = this.createDataTypeNode(name, sourceNode, navigationCallExp);
                    }
                } else {
                    targetNode = this.createStepNode(name, (CallExp)navigationCallExp, sourceNode);
                }
            }
            this.getNavigationEdge(sourceNode, referredProperty, targetNode, null);
            return targetNode;
        }
        OCLExpression ownedSource = QVTbaseUtil.getOwnedSource((CallExp)navigationCallExp);
        return ((RuleAnalysis)((Object)this.context)).getUnknownNode((TypedElement)ownedSource);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable Node doOperationCallExp(@NonNull OperationCallExp operationCallExp, @Nullable Node sourceNode) {
        Type returnType;
        boolean isRequired = operationCallExp.isIsRequired();
        Operation referredOperation = QVTbaseUtil.getReferredOperation((CallExp)operationCallExp);
        String operationName = (String)ClassUtil.nonNullState((Object)referredOperation.getName());
        OCLExpression ownedSource = operationCallExp.getOwnedSource();
        if (sourceNode == null) {
            List ownedArguments = operationCallExp.getOwnedArguments();
            int iSize = ownedArguments.size();
            @NonNull Node[] argNodes = new Node[iSize];
            int i = 0;
            while (i < iSize) {
                argNodes[i] = this.synthesize((Visitable)ownedArguments.get(i));
                ++i;
            }
            ExpressionSynthesizer nestedAnalyzer = this.getRequiredExpressionSynthesizer(isRequired);
            Node operationNode = this.findOperationNode(referredOperation, argNodes);
            if (operationNode == null) {
                operationNode = nestedAnalyzer.createOperationCallNode((CallExp)operationCallExp, referredOperation, argNodes);
                int i2 = 0;
                while (i2 < iSize) {
                    Parameter parameter = QVTbaseUtil.getOwnedParameter((Operation)referredOperation, (int)i2);
                    nestedAnalyzer.createOperationParameterEdge(argNodes[i2], parameter, -1, operationNode);
                    ++i2;
                }
                if (referredOperation.getBodyExpression() != null) {
                    OperationRegion operationRegion = this.scheduleManager.analyzeOperation(operationCallExp);
                    @NonNull Iterable referenceNodes = QVTscheduleUtil.getDependencyNodes((OperationRegion)operationRegion);
                    for (Node referenceNode : referenceNodes) {
                        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)referenceNode);
                        Node dependencyHead = ((RuleAnalysis)((Object)this.context)).getDependencyHead(classDatum);
                        if (dependencyHead == null) {
                            dependencyHead = ((RuleAnalysis)((Object)this.context)).createDependencyHead(classDatum);
                            this.createDependencyEdge(dependencyHead, QVTscheduleUtil.getName((Nameable)dependencyHead), operationNode);
                        }
                        this.instantiate(dependencyHead, referenceNode);
                    }
                }
            }
            return operationNode;
        }
        assert (ownedSource != null);
        OperationId operationId = referredOperation.getOperationId();
        if (operationCallExp.eContainer() instanceof Predicate && !(ownedSource.getType() instanceof DataType) && QVTbaseUtil.isSameOperation((OperationId)operationId, (OperationId)this.standardLibraryHelper.getOclAnyEqualsId())) {
            return this.synthesizeOperationCallExp_equals(operationCallExp);
        }
        if (operationId == this.standardLibraryHelper.getOclAnyOclAsTypeId()) {
            return this.synthesizeOperationCallExp_oclAsType(sourceNode, operationCallExp);
        }
        if (QVTbaseUtil.isSameOperation((OperationId)operationId, (OperationId)this.standardLibraryHelper.getOclElementOclContainerId())) {
            return this.synthesizeOperationCallExp_oclContainer(sourceNode, operationCallExp);
        }
        if (operationCallExp.eContainer() instanceof Predicate && sourceNode.getClassDatum().isCollectionType() && "includes".equals(operationName)) {
            return this.synthesizeOperationCallExp_includes(sourceNode, operationCallExp);
        }
        List ownedArguments = operationCallExp.getOwnedArguments();
        int iSize = ownedArguments.size();
        @NonNull Node[] argNodes = new Node[iSize + 1];
        @NonNull String[] argNames = new String[iSize + 1];
        argNodes[0] = sourceNode;
        argNames[0] = "\u00abself\u00bb";
        int i = 0;
        while (i < iSize) {
            argNodes[i + 1] = this.synthesize((Visitable)ownedArguments.get(i));
            argNames[i + 1] = "\u00ab" + ((Parameter)referredOperation.getOwnedParameters().get(i)).getName() + "\u00bb";
            ++i;
        }
        Node operationNode = this.findOperationNode(referredOperation, argNodes);
        if (operationNode == null) {
            operationNode = this.createOperationCallNode((CallExp)operationCallExp, referredOperation, argNodes);
            int i3 = 0;
            while (i3 <= iSize) {
                if (i3 == 0) {
                    this.createOperationSelfEdge(argNodes[i3], QVTbaseUtil.getType((TypedElement)ownedSource), operationNode);
                } else {
                    this.createOperationParameterEdge(argNodes[i3], QVTbaseUtil.getOwnedParameter((Operation)referredOperation, (int)(i3 - 1)), -1, operationNode);
                }
                ++i3;
            }
            if (referredOperation.getBodyExpression() != null) {
                OperationRegion operationRegion = this.scheduleManager.analyzeOperation(operationCallExp);
                @NonNull Iterable referenceNodes = QVTscheduleUtil.getDependencyNodes((OperationRegion)operationRegion);
                for (Node referenceNode : referenceNodes) {
                    ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)referenceNode);
                    Node dependencyHead = ((RuleAnalysis)((Object)this.context)).getDependencyHead(classDatum);
                    if (dependencyHead == null) {
                        dependencyHead = ((RuleAnalysis)((Object)this.context)).createDependencyHead(classDatum);
                        this.createDependencyEdge(dependencyHead, QVTscheduleUtil.getName((Nameable)dependencyHead), operationNode);
                    }
                    this.instantiate(dependencyHead, referenceNode);
                }
            }
        } else {
            operationNode.addOriginatingElement((Element)operationCallExp);
        }
        if ((returnType = operationCallExp.getType()) instanceof DataType) {
            return operationNode;
        }
        return operationNode;
    }

    protected @NonNull Node doSafeNavigation(@NonNull CallExp callExp, @NonNull Node sourceNode, @NonNull Node navigationNode) {
        assert (callExp.isIsSafe());
        Type unsafeType = callExp.getType();
        assert (!(unsafeType instanceof MapType));
        if (unsafeType instanceof CollectionType) {
            Operation excludingOperation = this.standardLibraryHelper.getCollectionExcludingOperation();
            Node nullNode = this.createNullLiteralNode();
            Node excludingNode = this.createOperationCallNode2("safe" + navigationNode.getName(), QVTscheduleUtil.getNodeRole((Node)navigationNode), excludingOperation, QVTscheduleUtil.getClassDatum((Node)navigationNode), navigationNode, nullNode);
            return excludingNode;
        }
        Operation equalsOperation = this.standardLibraryHelper.getOclAnyEqualsOperation();
        Node nullNode1 = this.createNullLiteralNode();
        Node isNonNullNode = this.createOperationCallNode2("equals", QVTscheduleUtil.getNodeRole((Node)navigationNode), equalsOperation, this.scheduleManager.getBooleanClassDatum(), sourceNode, nullNode1);
        this.createOperationSelfEdge(sourceNode, QVTbaseUtil.getType((TypedElement)QVTbaseUtil.getOwnedSource((CallExp)callExp)), isNonNullNode);
        this.createOperationParameterEdge(nullNode1, QVTbaseUtil.getOwnedParameter((Operation)equalsOperation, (int)0), -1, isNonNullNode);
        Node nullNode2 = this.createNullLiteralNode();
        Operation ifOperation = this.qvtbaseLibraryHelper.getIfOperation();
        Node[] sourceAndArgumentNodes = new Node[]{isNonNullNode, navigationNode, nullNode2};
        String nodeName = QVTbaseUtil.getName((NamedElement)ifOperation);
        IfNode ifNode = ((RuleAnalysis)((Object)this.context)).createIfNode2(this.utility, nodeName, QVTscheduleUtil.getClassDatum((Node)navigationNode), sourceAndArgumentNodes);
        Parameter conditionParameter = this.qvtbaseLibraryHelper.getIfConditionParameter();
        Parameter thenParameter = this.qvtbaseLibraryHelper.getIfThenParameter();
        Parameter elseParameter = this.qvtbaseLibraryHelper.getIfElseParameter();
        this.createOperationParameterEdge(isNonNullNode, conditionParameter, -1, (Node)ifNode);
        this.createOperationParameterEdge(nullNode2, thenParameter, -1, (Node)ifNode);
        this.createOperationParameterEdge(navigationNode, elseParameter, -1, (Node)ifNode);
        return ifNode;
    }

    protected @Nullable Node findOperationNode(@NonNull Operation operation, Node ... sourceAndArgumentNodes) {
        String name = QVTbaseUtil.getName((NamedElement)operation);
        if (sourceAndArgumentNodes.length > 0) {
            for (Edge searchEdge : QVTscheduleUtil.getOutgoingEdges((Node)sourceAndArgumentNodes[0])) {
                Node reusedNode;
                if (!searchEdge.isComputation() || !(reusedNode = searchEdge.getEdgeTarget()).isOperation()) continue;
                OperationNode operationNode = (OperationNode)reusedNode;
                boolean equals1 = name.equals(reusedNode.getName());
                if (!equals1) continue;
                int iSize = 0;
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)reusedNode)) {
                    if (!edge.isExpression()) continue;
                    ++iSize;
                }
                if (iSize != sourceAndArgumentNodes.length) continue;
                int i = 0;
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)reusedNode)) {
                    if (!edge.isExpression()) continue;
                    Node reusedArgumentNode = edge.getEdgeSource();
                    if (reusedArgumentNode != sourceAndArgumentNodes[i]) break;
                    ++i;
                }
                if (i != iSize) continue;
                if (!this.utility.isConditional()) assert (!reusedNode.isConditional());
                return reusedNode;
            }
        }
        return null;
    }

    public @NonNull ExpressionSynthesizer getExpressionSynthesizer(@NonNull Utility utility) {
        if (this.nonNullMatchedExpressionSynthesizer != this) {
            return this.nonNullMatchedExpressionSynthesizer.getExpressionSynthesizer(utility);
        }
        assert (this == this.nonNullMatchedExpressionSynthesizer);
        switch (utility) {
            case NON_NULL_MATCHED: {
                return this;
            }
            case NULLABLE_MATCHED: {
                ExpressionSynthesizer nullableMatchedExpressionSynthesizer2 = this.nullableMatchedExpressionSynthesizer;
                if (nullableMatchedExpressionSynthesizer2 == null) {
                    this.nullableMatchedExpressionSynthesizer = nullableMatchedExpressionSynthesizer2 = this.createExpressionSynthesizer(utility);
                }
                return nullableMatchedExpressionSynthesizer2;
            }
            case NON_NULL_CONDITIONAL: {
                ExpressionSynthesizer nonNullConditionalExpressionSynthesizer2 = this.nonNullConditionalExpressionSynthesizer;
                if (nonNullConditionalExpressionSynthesizer2 == null) {
                    this.nonNullConditionalExpressionSynthesizer = nonNullConditionalExpressionSynthesizer2 = this.createExpressionSynthesizer(utility);
                }
                return nonNullConditionalExpressionSynthesizer2;
            }
            case NULLABLE_CONDITIONAL: {
                ExpressionSynthesizer nullableConditionalExpressionSynthesizer2 = this.nullableConditionalExpressionSynthesizer;
                if (nullableConditionalExpressionSynthesizer2 == null) {
                    this.nullableConditionalExpressionSynthesizer = nullableConditionalExpressionSynthesizer2 = this.createExpressionSynthesizer(utility);
                }
                return nullableConditionalExpressionSynthesizer2;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected final @NonNull Utility getUtility() {
        return this.utility;
    }

    protected @NonNull NavigableEdge getNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        if (targetNode.isNullLiteral()) {
            return this.getNavigationEdgeToNull(sourceNode, source2targetProperty, targetNode, navigationAssignment);
        }
        if (targetNode.isClass() && !targetNode.isOperation()) {
            return this.getNavigationEdgeToClass(sourceNode, source2targetProperty, targetNode, navigationAssignment);
        }
        if (targetNode.isDataType()) {
            return this.getNavigationEdgeToDataType(sourceNode, source2targetProperty, targetNode, navigationAssignment);
        }
        return this.getNavigationEdgeToExpression(sourceNode, source2targetProperty, targetNode, navigationAssignment);
    }

    protected @NonNull NavigableEdge getNavigationEdgeToDataType(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        assert (targetNode.isDataType());
        Type type = source2targetProperty.getType();
        assert (type instanceof DataType);
        NavigableEdge navigationEdge = sourceNode.getOutgoingNavigableEdge(source2targetProperty);
        if (navigationEdge == null) {
            if (!targetNode.isOperation()) {
                navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
            } else {
                ClassDatum propertyClassDatum = this.scheduleManager.getClassDatum((TypedElement)source2targetProperty);
                ClassDatum valueClassDatum = targetNode.getClassDatum();
                if (valueClassDatum == propertyClassDatum) {
                    navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
                } else if (navigationAssignment == null) {
                    Node stepNode = this.createNavigableDataTypeNode(sourceNode, source2targetProperty);
                    navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, stepNode, navigationAssignment);
                    ((RuleAnalysis)((Object)this.context)).createEqualsEdge(this.utility, targetNode, stepNode);
                } else {
                    navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
                }
            }
        } else if (targetNode != navigationEdge.getEdgeTarget()) {
            ((RuleAnalysis)((Object)this.context)).createEqualsEdge(this.getRequiredUtility(navigationEdge.getEdgeTarget()), targetNode, navigationEdge.getEdgeTarget());
        }
        return navigationEdge;
    }

    protected @NonNull NavigableEdge getNavigationEdgeToClass(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        assert (targetNode.isClass());
        NavigableEdge navigationEdge = sourceNode.getOutgoingNavigableEdge(source2targetProperty);
        if (navigationEdge != null) {
            Node target = navigationEdge.getEdgeTarget();
            if (target != targetNode) {
                ((RuleAnalysis)((Object)this.context)).createEqualsEdge(this.getRequiredUtility(targetNode), targetNode, target);
            }
        } else {
            navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
        }
        return navigationEdge;
    }

    protected @NonNull NavigableEdge getNavigationEdgeToExpression(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        assert (targetNode.isExpression());
        if (navigationAssignment != null) {
            NavigableEdge navigationEdge = sourceNode.getOutgoingNavigableEdge(source2targetProperty);
            assert (navigationEdge == null);
            navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
            return navigationEdge;
        }
        NavigableEdge navigationEdge = sourceNode.getOutgoingNavigableEdge(source2targetProperty);
        if (navigationEdge != null) {
            Node valueNode = navigationEdge.getEdgeTarget();
            assert (valueNode.isRealized());
            Type type = source2targetProperty.getType();
            Edge equalsEdge = ((RuleAnalysis)((Object)this.context)).createEqualsEdge(this.utility, targetNode, valueNode);
            if (type instanceof DataType) assert (equalsEdge.isRealized());
            return navigationEdge;
        }
        navigationEdge = this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
        return navigationEdge;
    }

    protected @NonNull NavigableEdge getNavigationEdgeToNull(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable NavigationAssignment navigationAssignment) {
        assert (targetNode.isNullLiteral());
        return this.createNavigationOrRealizedEdge(sourceNode, source2targetProperty, targetNode, navigationAssignment);
    }

    protected final @NonNull Utility getNonNullUtility() {
        boolean isConditional = this.utility.isConditional();
        return isConditional ? Utility.NON_NULL_CONDITIONAL : Utility.NON_NULL_MATCHED;
    }

    protected final @NonNull Utility getNullableUtility() {
        boolean isConditional = this.utility.isConditional();
        return isConditional ? Utility.NULLABLE_CONDITIONAL : Utility.NULLABLE_MATCHED;
    }

    public @NonNull ExpressionSynthesizer getRequiredExpressionSynthesizer(boolean isRequired) {
        return this.getExpressionSynthesizer(this.getRequiredUtility(isRequired));
    }

    public @NonNull Utility getRequiredUtility(boolean isRequired) {
        return isRequired ? this.getNonNullUtility() : this.getNullableUtility();
    }

    public @NonNull Utility getRequiredUtility(@NonNull TypedElement typedElement) {
        return this.getRequiredUtility(typedElement.isIsRequired());
    }

    protected @NonNull Utility getRequiredUtility(@NonNull Utility utility) {
        boolean isConditional = this.utility.isConditional();
        boolean isNullable = utility.isNullable();
        if (isConditional) {
            return isNullable ? Utility.NULLABLE_CONDITIONAL : Utility.NON_NULL_CONDITIONAL;
        }
        isNullable = isNullable && this.utility.isNullable();
        return isNullable ? Utility.NULLABLE_MATCHED : Utility.NON_NULL_MATCHED;
    }

    protected @NonNull Utility getRequiredUtility(@NonNull Node node) {
        return this.getRequiredUtility(node.getUtility());
    }

    private void instantiate(@NonNull Node instantiatedNode, @NonNull Node referenceNode) {
        for (Edge referenceEdge : QVTscheduleUtil.getOutgoingEdges((Node)referenceNode)) {
            NavigationEdge navigationEdge;
            if (!(referenceEdge instanceof NavigationEdge) || (navigationEdge = (NavigationEdge)referenceEdge).isSecondary()) continue;
            Node referenceTargetNode = navigationEdge.getEdgeTarget();
            String name = QVTscheduleUtil.getName((Nameable)referenceTargetNode);
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)referenceTargetNode);
            Node instantiatedTargetNode = this.createDependencyNode(name, classDatum);
            this.createNavigationEdge(instantiatedNode, QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge), instantiatedTargetNode, false);
            this.instantiate(instantiatedTargetNode, referenceTargetNode);
        }
    }

    public @NonNull Node rewriteCastEdgeAsOclAsType(@NonNull CastEdge castEdge) {
        Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)castEdge);
        Node targetNode = QVTscheduleUtil.getTargetNode((Edge)castEdge);
        OperationCallExp operationCallExp = (OperationCallExp)targetNode.getOriginatingElement();
        Operation referredOperation = PivotUtil.getReferredOperation((CallExp)operationCallExp);
        OCLExpression ownedSource = PivotUtil.getOwnedSource((CallExp)operationCallExp);
        Type sourceType = PivotUtil.getType((TypedElement)ownedSource);
        TypeExp typeArgument = (TypeExp)PivotUtil.getOwnedArgument((OperationCallExp)operationCallExp, (int)0);
        TypeLiteralNode typeNode = this.createTypeLiteralNode(PivotUtil.getReferredType((TypeExp)typeArgument), typeArgument);
        ExpressionSynthesizer nestedAnalyzer = this;
        Node[] sourceAndArgumentNodes = new Node[]{sourceNode, typeNode};
        Node operationNode = this.findOperationNode(referredOperation, sourceAndArgumentNodes);
        if (operationNode == null) {
            operationNode = nestedAnalyzer.createOperationCallNode((CallExp)operationCallExp, referredOperation, sourceAndArgumentNodes);
            nestedAnalyzer.createOperationSelfEdge(sourceNode, sourceType, operationNode);
            Parameter parameter = QVTbaseUtil.getOwnedParameter((Operation)referredOperation, (int)0);
            nestedAnalyzer.createOperationParameterEdge((Node)typeNode, parameter, -1, operationNode);
        }
        CompilerUtil.migrateCastEdgeTargetContents(castEdge, operationNode);
        return operationNode;
    }

    public @NonNull Node synthesize(Visitable element) {
        Node accept = (Node)element.accept((Visitor)this);
        assert (accept != null);
        return accept;
    }

    private @Nullable Node synthesizeOperationCallExp_equals(@NonNull OperationCallExp operationCallExp) {
        Node targetNode;
        Node sourceNode;
        OCLExpression asSource = QVTbaseUtil.getOwnedSource((CallExp)operationCallExp);
        OCLExpression asTarget = QVTbaseUtil.getOwnedArgument((OperationCallExp)operationCallExp, (int)0);
        if (asSource instanceof VariableExp) {
            VariableDeclaration referredVariable = QVTbaseUtil.getReferredVariable((VariableExp)((VariableExp)asSource));
            RuleRegion ruleRegion = (RuleRegion)((RuleAnalysis)((Object)this.context)).getRegion();
            sourceNode = ruleRegion.getNode((TypedElement)referredVariable);
            if (sourceNode != null) {
                Map<@NonNull OCLExpression, @NonNull Node> expression2knownNode2 = this.expression2knownNode;
                if (expression2knownNode2 == null) {
                    this.expression2knownNode = expression2knownNode2 = new HashMap<OCLExpression, Node>();
                }
                expression2knownNode2.put(asTarget, sourceNode);
            }
            if ((targetNode = this.synthesize((Visitable)asTarget)) == sourceNode) {
                return null;
            }
            sourceNode = this.synthesize((Visitable)asSource);
        } else if (asTarget instanceof VariableExp) {
            VariableDeclaration referredVariable = QVTbaseUtil.getReferredVariable((VariableExp)((VariableExp)asTarget));
            RuleRegionImpl ruleRegion = (RuleRegionImpl)((RuleAnalysis)((Object)this.context)).getRegion();
            targetNode = ruleRegion.getNode((TypedElement)referredVariable);
            if (targetNode != null) {
                Map<@NonNull OCLExpression, @NonNull Node> expression2knownNode2 = this.expression2knownNode;
                if (expression2knownNode2 == null) {
                    this.expression2knownNode = expression2knownNode2 = new HashMap<OCLExpression, Node>();
                }
                expression2knownNode2.put(asSource, targetNode);
            }
            if (targetNode == (sourceNode = this.synthesize((Visitable)asSource))) {
                return null;
            }
            targetNode = this.synthesize((Visitable)asTarget);
        } else if (asSource instanceof NavigationCallExp) {
            targetNode = this.synthesize((Visitable)asTarget);
            if (!targetNode.isDataType()) {
                Map<@NonNull OCLExpression, @NonNull Node> expression2knownNode2 = this.expression2knownNode;
                if (expression2knownNode2 == null) {
                    this.expression2knownNode = expression2knownNode2 = new HashMap<OCLExpression, Node>();
                }
                expression2knownNode2.put(asSource, targetNode);
            }
            if (targetNode == (sourceNode = this.synthesize((Visitable)asSource))) {
                return null;
            }
        } else {
            sourceNode = this.synthesize((Visitable)asSource);
            if (!sourceNode.isDataType()) {
                Map<@NonNull OCLExpression, @NonNull Node> expression2knownNode2 = this.expression2knownNode;
                if (expression2knownNode2 == null) {
                    this.expression2knownNode = expression2knownNode2 = new HashMap<OCLExpression, Node>();
                }
                expression2knownNode2.put(asTarget, sourceNode);
            }
            if ((targetNode = this.synthesize((Visitable)asTarget)) == sourceNode) {
                return null;
            }
        }
        this.createEqualsEdge(targetNode, sourceNode);
        return null;
    }

    private @Nullable Node synthesizeOperationCallExp_includes(@NonNull Node sourceNode, @NonNull OperationCallExp operationCallExp) {
        Node targetNode = this.synthesize((Visitable)operationCallExp.getOwnedArguments().get(0));
        String name = operationCallExp.getReferredOperation().getName();
        this.createPredicateEdge(this.utility, sourceNode, "\u00ab" + name + "\u00bb", targetNode);
        if (sourceNode.isDataType()) {
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)sourceNode)) {
                NavigationEdge navigationEdge;
                Property property;
                Property oppositeProperty;
                if (!(edge instanceof NavigationEdge) || (oppositeProperty = (property = (navigationEdge = (NavigationEdge)edge).getReferredProperty()).getOpposite()) == null || oppositeProperty.isIsMany()) continue;
                this.createNavigationEdge(targetNode, oppositeProperty, QVTscheduleUtil.getSourceNode((Edge)navigationEdge), false);
            }
        }
        return null;
    }

    private @NonNull Node synthesizeOperationCallExp_oclAsType(@NonNull Node sourceNode, @NonNull OperationCallExp operationCallExp) {
        ClassDatum castClassDatum = this.scheduleManager.getClassDatum((TypedElement)operationCallExp);
        boolean castIsRequired = operationCallExp.isIsRequired();
        ClassDatum predicatedClassDatum = QVTscheduleUtil.getClassDatum((Node)sourceNode);
        boolean sourceIsRequired = sourceNode.isRequired();
        if (QVTscheduleUtil.conformsTo((ClassDatum)predicatedClassDatum, (ClassDatum)castClassDatum) && (sourceIsRequired || !castIsRequired)) {
            sourceNode.addOriginatingElement((Element)operationCallExp);
            return sourceNode;
        }
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)sourceNode)) {
            Node targetNode;
            if (!(edge instanceof CastEdge) || !QVTscheduleUtil.conformsTo((ClassDatum)(predicatedClassDatum = QVTscheduleUtil.getClassDatum((Node)(targetNode = edge.getEdgeTarget()))), (ClassDatum)castClassDatum)) continue;
            targetNode.addOriginatingElement((Element)operationCallExp);
            return targetNode;
        }
        Type castType = QVTbaseUtil.getType((TypedElement)operationCallExp);
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)sourceNode)) {
            CastEdge castEdge;
            if (!(edge instanceof CastEdge) || castClassDatum != (castEdge = (CastEdge)edge).getReferredClassDatum()) continue;
            Node castNode = castEdge.getEdgeTarget();
            castNode.addOriginatingElement((Element)operationCallExp);
            return castNode;
        }
        String name = "a" + castType.getName();
        Node castNode = this.createStepNode(name, (CallExp)operationCallExp, sourceNode);
        this.createCastEdge(sourceNode, castClassDatum, castNode);
        OCLExpression argument = (OCLExpression)operationCallExp.getOwnedArguments().get(0);
        if (!(argument instanceof TypeExp)) {
            Node argumentNode = this.synthesize((Visitable)argument);
            Operation referredOperation = QVTbaseUtil.getReferredOperation((CallExp)operationCallExp);
            Parameter firstParameter = QVTbaseUtil.getOwnedParameter((Operation)referredOperation, (int)0);
            this.createOperationParameterEdge(argumentNode, firstParameter, -1, castNode);
        }
        return castNode;
    }

    private @NonNull Node synthesizeOperationCallExp_oclContainer(@NonNull Node sourceNode, @NonNull OperationCallExp operationCallExp) {
        Property oclContainerProperty = this.standardLibraryHelper.getOclContainerProperty();
        Edge oclContainerEdge = sourceNode.getOutgoingPredicateEdge(oclContainerProperty);
        if (oclContainerEdge != null) {
            return oclContainerEdge.getEdgeTarget();
        }
        String name = QVTbaseUtil.getName((NamedElement)QVTbaseUtil.getReferredOperation((CallExp)operationCallExp));
        Node oclContainerNode = this.createStepNode(name, (CallExp)operationCallExp, sourceNode);
        oclContainerEdge = this.createNavigationEdge(sourceNode, oclContainerProperty, oclContainerNode, false);
        return oclContainerNode;
    }

    public String toString() {
        String name = ((Object)((Object)this)).getClass().getName();
        int index = name.lastIndexOf(46);
        return this.utility + " " + (index < 0 ? name : name.substring(index + 1));
    }

    public @NonNull Node visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    public @NonNull Node visitBooleanLiteralExp(@NonNull BooleanLiteralExp booleanLiteralExp) {
        boolean booleanValue = booleanLiteralExp.isBooleanSymbol();
        Node operationNode = this.createBooleanLiteralNode(booleanValue, booleanLiteralExp);
        return operationNode;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Node visitCollectionLiteralExp(@NonNull CollectionLiteralExp collectionLiteralExp) {
        @NonNull List ownedParts = QVTbaseUtil.Internal.getOwnedPartsList((CollectionLiteralExp)collectionLiteralExp);
        int iSize = ownedParts.size();
        @NonNull Node[] partNodes = new Node[iSize];
        @NonNull CollectionLiteralPart[] collectionParts = new CollectionLiteralPart[iSize];
        int i = 0;
        while (i < iSize) {
            CollectionLiteralPart collectionPart = (CollectionLiteralPart)ownedParts.get(i);
            partNodes[i] = this.synthesize((Visitable)collectionPart);
            collectionParts[i] = collectionPart;
            ++i;
        }
        boolean isRequired = collectionLiteralExp.isIsRequired();
        ExpressionSynthesizer nestedAnalyzer = this.getRequiredExpressionSynthesizer(isRequired);
        return nestedAnalyzer.createCollectionLiteral(collectionLiteralExp, collectionParts, partNodes);
    }

    public @NonNull Node visitCollectionItem(@NonNull CollectionItem collectionItem) {
        return this.synthesize((Visitable)collectionItem.getOwnedItem());
    }

    public @NonNull Node visitCollectionRange(@NonNull CollectionRange collectionRange) {
        Node firstNode = this.synthesize((Visitable)collectionRange.getOwnedFirst());
        Node lastNode = this.synthesize((Visitable)collectionRange.getOwnedLast());
        boolean isRequired = collectionRange.isIsRequired();
        ExpressionSynthesizer nestedAnalyzer = this.getRequiredExpressionSynthesizer(isRequired);
        return nestedAnalyzer.createCollectionRange(this.utility, collectionRange, firstNode, lastNode);
    }

    public @NonNull Node visitElement(@NonNull Element element) {
        Class oclInvalidType = this.scheduleManager.getStandardLibrary().getOclInvalidType();
        ClassDatum classDatum = this.scheduleManager.getClassDatum(this.scheduleManager.getDomainUsageAnalysis().getPrimitiveTypedModel(), oclInvalidType);
        Node errorNode = this.createErrorNode("\u00aberror\u00bb", classDatum);
        int parameterIndex = 0;
        for (EObject eObject : element.eContents()) {
            Node node = this.synthesize((Visitable)((Element)eObject));
            this.createOperationParameterEdge(node, this.qvtbaseLibraryHelper.getErrorElementsParameter(), parameterIndex++, errorNode);
        }
        return errorNode;
    }

    public @NonNull Node visitEnumLiteralExp(@NonNull EnumLiteralExp enumLiteralExp) {
        EnumerationLiteral referredEnumerationLiteral = QVTbaseUtil.getReferredLiteral((EnumLiteralExp)enumLiteralExp);
        EnumLiteralNode operationNode = this.createEnumLiteralNode(referredEnumerationLiteral, enumLiteralExp);
        return operationNode;
    }

    public @NonNull Node visitIfExp(@NonNull IfExp ifExp) {
        ExpressionSynthesizer conditionalExpressionSynthesizer = this.getExpressionSynthesizer(this.utility.getConditionalUtility());
        Node selfNode = this.synthesize((Visitable)ifExp.getOwnedCondition());
        Node thenNode = conditionalExpressionSynthesizer.synthesize((Visitable)ifExp.getOwnedThen());
        Node elseNode = conditionalExpressionSynthesizer.synthesize((Visitable)ifExp.getOwnedElse());
        Operation ifOperation = this.qvtbaseLibraryHelper.getIfOperation();
        Node[] sourceAndArgumentNodes = new Node[]{selfNode, thenNode, elseNode};
        Node reusedNode = this.findOperationNode(ifOperation, sourceAndArgumentNodes);
        if (reusedNode != null) {
            return reusedNode;
        }
        String nodeName = CompilerUtil.recoverVariableName((NamedElement)ifExp);
        if (nodeName == null) {
            nodeName = QVTbaseUtil.getName((NamedElement)ifOperation);
        }
        IfNode operationNode = this.createIfNode(ifExp, nodeName, sourceAndArgumentNodes);
        Parameter conditionParameter = this.qvtbaseLibraryHelper.getIfConditionParameter();
        Parameter thenParameter = this.qvtbaseLibraryHelper.getIfThenParameter();
        Parameter elseParameter = this.qvtbaseLibraryHelper.getIfElseParameter();
        this.createOperationParameterEdge(selfNode, conditionParameter, -1, (Node)operationNode);
        conditionalExpressionSynthesizer.createOperationParameterEdge(thenNode, thenParameter, -1, (Node)operationNode);
        conditionalExpressionSynthesizer.createOperationParameterEdge(elseNode, elseParameter, -1, (Node)operationNode);
        return operationNode;
    }

    public @NonNull Node visitIntegerLiteralExp(@NonNull IntegerLiteralExp integerLiteralExp) {
        Number numberValue = (Number)ClassUtil.nonNullState((Object)integerLiteralExp.getIntegerSymbol());
        Node operationNode = this.createNumericLiteralNode(numberValue, (NumericLiteralExp)integerLiteralExp);
        return operationNode;
    }

    public @NonNull Node visitLetExp(@NonNull LetExp letExp) {
        ClassDatum variableClassDatum;
        Variable ownedVariable = letExp.getOwnedVariable();
        Node initNode = this.synthesize((Visitable)ownedVariable.getOwnedInit());
        assert (initNode != null);
        ClassDatum actualClassDatum = QVTscheduleUtil.getClassDatum((Node)initNode);
        if (QVTscheduleUtil.conformsTo((ClassDatum)actualClassDatum, (ClassDatum)(variableClassDatum = this.scheduleManager.getClassDatum((TypedElement)ownedVariable)))) {
            ((RuleRegion)((RuleAnalysis)((Object)this.context)).getRegion()).addVariableNode((VariableDeclaration)ownedVariable, initNode);
            initNode.setOriginatingVariable((VariableDeclaration)ownedVariable);
        } else {
            Node varNode = this.createLetNode(ownedVariable, initNode);
            this.createCastEdge(initNode, variableClassDatum, varNode);
        }
        return this.synthesize((Visitable)letExp.getOwnedIn());
    }

    public @NonNull Node visitLoopExp(@NonNull LoopExp loopExp) {
        Node sourceNode = this.synthesize((Visitable)loopExp.getOwnedSource());
        Node loopNode = this.doLoopExp(loopExp, sourceNode);
        boolean isSafe = loopExp.isIsSafe();
        if (isSafe) {
            loopNode = this.doSafeNavigation((CallExp)loopExp, sourceNode, loopNode);
        }
        return loopNode;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Node visitMapLiteralExp(@NonNull MapLiteralExp mapLiteralExp) {
        @NonNull List ownedParts = QVTbaseUtil.Internal.getOwnedPartsList((MapLiteralExp)mapLiteralExp);
        int iSize = ownedParts.size();
        @NonNull Node[] partNodes = new Node[iSize];
        @NonNull MapLiteralPart[] mapParts = new MapLiteralPart[iSize];
        int i = 0;
        while (i < iSize) {
            MapLiteralPart mapPart = (MapLiteralPart)ownedParts.get(i);
            partNodes[i] = this.synthesize((Visitable)mapPart);
            mapParts[i] = mapPart;
            ++i;
        }
        boolean isRequired = mapLiteralExp.isIsRequired();
        ExpressionSynthesizer nestedAnalyzer = this.getRequiredExpressionSynthesizer(isRequired);
        return nestedAnalyzer.createMapLiteral(mapLiteralExp, mapParts, partNodes);
    }

    public @NonNull Node visitMapLiteralPart(@NonNull MapLiteralPart mapLiteralPart) {
        Node keyNode = this.synthesize((Visitable)QVTbaseUtil.getOwnedKey((MapLiteralPart)mapLiteralPart));
        Node valueNode = this.synthesize((Visitable)QVTbaseUtil.getOwnedValue((MapLiteralPart)mapLiteralPart));
        OCLExpression key = QVTbaseUtil.getOwnedKey((MapLiteralPart)mapLiteralPart);
        OCLExpression value = QVTbaseUtil.getOwnedValue((MapLiteralPart)mapLiteralPart);
        boolean isRequired = key.isIsRequired() && value.isIsRequired();
        ExpressionSynthesizer nestedAnalyzer = this.getRequiredExpressionSynthesizer(isRequired);
        return nestedAnalyzer.createMapPart(mapLiteralPart, keyNode, valueNode);
    }

    public @NonNull Node visitNavigationCallExp(@NonNull NavigationCallExp navigationCallExp) {
        OCLExpression ownedSource = QVTbaseUtil.getOwnedSource((CallExp)navigationCallExp);
        Node sourceNode = this.synthesize((Visitable)ownedSource);
        Node navigationNode = this.doNavigationCallExp(navigationCallExp, sourceNode);
        boolean isSafe = navigationCallExp.isIsSafe();
        if (isSafe) {
            navigationNode = this.doSafeNavigation((CallExp)navigationCallExp, sourceNode, navigationNode);
        }
        return navigationNode;
    }

    public @NonNull Node visitNullLiteralExp(@NonNull NullLiteralExp nullLiteralExp) {
        return this.createNullLiteralNode(nullLiteralExp);
    }

    public @NonNull Node visitOCLExpression(@NonNull OCLExpression oclExpression) {
        return ((RuleAnalysis)((Object)this.context)).getUnknownNode((TypedElement)oclExpression);
    }

    public @Nullable Node visitOperationCallExp(@NonNull OperationCallExp operationCallExp) {
        boolean isRequired;
        boolean bl = isRequired = !this.utility.isConditional() || operationCallExp.isIsRequired();
        if (!this.utility.isConditional() && !isRequired) {
            return this.getExpressionSynthesizer(this.utility.getConditionalUtility()).visitOperationCallExp(operationCallExp);
        }
        OCLExpression ownedSource = operationCallExp.getOwnedSource();
        if (ownedSource instanceof VariableExp) {
            Transformation transformation = QVTbaseUtil.getContainingTransformation((EObject)operationCallExp);
            Parameter thisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)this.scheduleManager.getStandardLibrary(), (Transformation)transformation);
            if (((VariableExp)ownedSource).getReferredVariable() == thisVariable) {
                ownedSource = null;
            }
        }
        Node sourceNode = ownedSource != null ? this.synthesize((Visitable)ownedSource) : null;
        Node operationNode = this.doOperationCallExp(operationCallExp, sourceNode);
        boolean isSafe = operationCallExp.isIsSafe();
        if (isSafe && sourceNode != null && operationNode != null) {
            operationNode = this.doSafeNavigation((CallExp)operationCallExp, sourceNode, operationNode);
        }
        return operationNode;
    }

    public @NonNull Node visitRealLiteralExp(@NonNull RealLiteralExp realLiteralExp) {
        Number numberValue = (Number)ClassUtil.nonNullState((Object)realLiteralExp.getRealSymbol());
        Node operationNode = this.createNumericLiteralNode(numberValue, (NumericLiteralExp)realLiteralExp);
        return operationNode;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Node visitShadowExp(@NonNull ShadowExp shadowExp) {
        @NonNull List ownedParts = QVTbaseUtil.Internal.getOwnedPartsList((ShadowExp)shadowExp);
        int iSize = ownedParts.size();
        @NonNull Node[] partNodes = new Node[iSize];
        @NonNull ShadowPart[] shadowParts = new ShadowPart[iSize];
        int i = 0;
        while (i < iSize) {
            ShadowPart shadowPart = (ShadowPart)ownedParts.get(i);
            partNodes[i] = this.synthesize((Visitable)shadowPart);
            shadowParts[i] = shadowPart;
            ++i;
        }
        boolean isRequired = shadowExp.isIsRequired();
        ExpressionSynthesizer nestedAnalyzer = this.getRequiredExpressionSynthesizer(isRequired);
        return nestedAnalyzer.createShadow(shadowExp, shadowParts, partNodes);
    }

    public @NonNull Node visitShadowPart(@NonNull ShadowPart shadowPart) {
        return this.synthesize((Visitable)shadowPart.getOwnedInit());
    }

    public @NonNull Node visitStringLiteralExp(@NonNull StringLiteralExp stringLiteralExp) {
        String stringValue = (String)ClassUtil.nonNullState((Object)stringLiteralExp.getStringSymbol());
        Node operationNode = this.createStringLiteralNode(stringValue, stringLiteralExp);
        return operationNode;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Node visitTupleLiteralExp(@NonNull TupleLiteralExp tupleLiteralExp) {
        @NonNull List ownedParts = QVTbaseUtil.Internal.getOwnedPartsList((TupleLiteralExp)tupleLiteralExp);
        int iSize = ownedParts.size();
        @NonNull Node[] partNodes = new Node[iSize];
        @NonNull TupleLiteralPart[] tupleParts = new TupleLiteralPart[iSize];
        int i = 0;
        while (i < iSize) {
            TupleLiteralPart tuplePart = (TupleLiteralPart)ownedParts.get(i);
            partNodes[i] = this.synthesize((Visitable)tuplePart);
            tupleParts[i] = tuplePart;
            ++i;
        }
        boolean isRequired = tupleLiteralExp.isIsRequired();
        ExpressionSynthesizer nestedAnalyzer = this.getRequiredExpressionSynthesizer(isRequired);
        return nestedAnalyzer.createTupleLiteral(tupleLiteralExp, tupleParts, partNodes);
    }

    public @NonNull Node visitTupleLiteralPart(@NonNull TupleLiteralPart tupleLiteralPart) {
        return this.synthesize((Visitable)tupleLiteralPart.getOwnedInit());
    }

    public @NonNull Node visitTypeExp(@NonNull TypeExp typeExp) {
        Type referredType = QVTbaseUtil.getReferredType((TypeExp)typeExp);
        TypeLiteralNode operationNode = this.createTypeLiteralNode(referredType, typeExp);
        return operationNode;
    }

    public @NonNull Node visitVariableDeclaration(@NonNull VariableDeclaration variableDeclaration) {
        return ((RuleAnalysis)((Object)this.context)).getReferenceNode(variableDeclaration);
    }

    public @NonNull Node visitVariableExp(@NonNull VariableExp variableExp) {
        VariableDeclaration referredVariable = QVTbaseUtil.getReferredVariable((VariableExp)variableExp);
        return ((RuleAnalysis)((Object)this.context)).getReferenceNode(referredVariable);
    }
}

