/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.fields.FieldEditor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.osgi.service.prefs.BackingStoreException;

public class ComboFieldEditor
extends FieldEditor {
    private Combo fCombo = null;
    private String fValue = null;
    private List<String> fEntryLabels;
    private List<String> fEntryValues;
    private int fNumColumns;

    public ComboFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, String[] values, String[] labels, int numColumns, Composite parent, boolean isEnabled, boolean isRemovable) {
        Assert.isTrue((values.length == labels.length ? 1 : 0) != 0);
        this.init(name, labelText);
        this.preferencesService = service;
        this.preferencesLevel = level;
        this.parent = parent;
        this.prefPage = page;
        this.setPage((DialogPage)this.prefPage);
        this.prefTab = tab;
        this.fEntryLabels = new ArrayList<String>(labels.length);
        this.fEntryValues = new ArrayList<String>(values.length);
        int i = 0;
        while (i < labels.length) {
            this.fEntryLabels.add(labels[i]);
            this.fEntryValues.add(values[i]);
            ++i;
        }
        this.fNumColumns = numColumns;
        this.createControl(parent);
        this.isRemovable = isRemovable;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        ((GridData)this.fCombo.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl();
        gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected void doSetToolTip() {
        if (this.toolTipText != null) {
            this.getComboBoxControl().setToolTipText(this.toolTipText);
        }
    }

    protected void doLoad() {
        if (this.fCombo != null) {
            String value = null;
            if (this.preferencesLevel != null) {
                value = this.preferencesService.getStringPreference(this.preferencesLevel, this.getPreferenceName());
                this.levelFromWhichLoaded = this.preferencesLevel;
                this.setInherited(false);
            } else {
                value = this.preferencesService.getStringPreference(this.getPreferenceName());
                this.levelFromWhichLoaded = this.preferencesService.getApplicableLevel(this.getPreferenceName(), this.preferencesLevel);
                this.setInherited(true);
            }
            if ("default".equals(this.levelFromWhichLoaded)) {
                this.setPresentsDefaultValue(true);
            }
            this.previousValue = value;
            this.updateComboForValue(value);
        }
    }

    protected void doLoadDefault() {
        if (this.fCombo != null) {
            String value = this.preferencesService.getStringPreference("default", this.getPreferenceName());
            this.updateComboForValue(value);
        }
    }

    protected void doLoadLevel(String level) {
        if (this.fCombo != null) {
            String value = this.preferencesService.getStringPreference(level, this.getPreferenceName());
            this.updateComboForValue(value);
        }
    }

    protected String doLoadWithInheritance() {
        String levelLoaded = null;
        String[] levels = IPreferencesService.levels;
        int fieldLevelIndex = 0;
        String tmpPreferencesLevel = this.preferencesLevel == null ? levels[0] : this.preferencesLevel;
        int i = 0;
        while (i < levels.length) {
            if (tmpPreferencesLevel.equals(levels[i])) {
                fieldLevelIndex = i;
                break;
            }
            ++i;
        }
        String value = null;
        int levelAtWhichFound = -1;
        int level = fieldLevelIndex;
        while (level < levels.length) {
            value = this.preferencesService.getStringPreference(levels[level], this.getPreferenceName());
            if (value != null) {
                levelAtWhichFound = level;
                levelLoaded = levels[levelAtWhichFound];
                break;
            }
            ++level;
        }
        this.levelFromWhichLoaded = levelLoaded;
        this.setInherited(fieldLevelIndex != levelAtWhichFound);
        this.setPresentsDefaultValue("default".equals(this.levelFromWhichLoaded));
        this.updateComboForValue(value);
        this.fieldModified = false;
        this.previousValue = value;
        this.setFieldColors();
        return levelLoaded;
    }

    protected void setFieldColors() {
        Combo comboBox = this.getComboBoxControl();
        Color color = this.isInherited() ? PreferencesUtilities.colorBluish : PreferencesUtilities.colorWhite;
        comboBox.setBackground(color);
    }

    protected void doStore() {
        String value = this.getStringValue();
        this.preferencesService.setStringPreference(this.preferencesLevel, this.getPreferenceName(), value);
        this.fieldModified = false;
        this.levelFromWhichLoaded = this.preferencesLevel;
        this.setFieldColors();
        IEclipsePreferences node = this.preferencesService.getNodeForLevel(this.preferencesLevel);
        try {
            if (node != null) {
                node.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            System.err.println("ComboFieldEditor.doStore():  BackingStoreException flushing node;  node may not have been flushed:\n\tnode path = " + node.absolutePath() + ", preferences level = " + this.preferencesLevel);
        }
    }

    public int getNumberOfControls() {
        return this.fNumColumns;
    }

    public Combo getComboBoxControl() {
        if (this.fCombo == null) {
            this.fCombo = new Combo(this.parent, 8);
            for (String entryName : this.fEntryLabels) {
                this.fCombo.add(entryName);
            }
            this.fCombo.setFont(this.parent.getFont());
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String name = ComboFieldEditor.this.fCombo.getText();
                    ComboFieldEditor.this.fValue = ComboFieldEditor.this.getValueForName(name);
                    ComboFieldEditor.this.setPresentsDefaultValue(false);
                    ComboFieldEditor.this.fieldModified = true;
                    ComboFieldEditor.this.setInherited(false);
                    ComboFieldEditor.this.valueChanged();
                }
            });
        }
        return this.fCombo;
    }

    public Composite getHolder() {
        return this.getComboBoxControl().getParent();
    }

    protected String getValueForName(String name) {
        int idx = this.fEntryLabels.indexOf(name);
        return idx >= 0 ? this.fEntryValues.get(idx) : "";
    }

    protected void updateComboForValue(String value) {
        if (value == null) {
            value = "";
        }
        this.previousValue = this.getStringValue();
        this.setPreviousStringValue(this.getStringValue());
        int idx = this.fEntryValues.indexOf(value);
        if (idx < 0) {
            idx = 0;
        }
        this.fValue = this.fEntryValues.get(idx);
        this.fCombo.setText(this.fEntryLabels.get(idx));
        this.valueChanged();
    }

    protected boolean valueChanged() {
        return this.valueChanged(false);
    }

    protected boolean valueChanged(boolean assertChanged) {
        boolean valueChanged = assertChanged || this.inheritanceChanged();
        String prevValue = this.getPreviousStringValue();
        if (!valueChanged) {
            if (this.fValue != null && prevValue == null || this.fValue == null && prevValue != null) {
                valueChanged = true;
            }
            if (this.fValue != null && prevValue != null && !this.fValue.equals(prevValue)) {
                valueChanged = true;
            }
        }
        if (valueChanged) {
            this.fireValueChanged("field_editor_value", prevValue, this.fValue);
            this.fieldModified = true;
            this.setPreviousStringValue(this.fValue);
            this.setModifiedMarkOnLabel();
        }
        return valueChanged;
    }

    protected String getPreviousStringValue() {
        return (String)this.previousValue;
    }

    protected void setPreviousStringValue(String value) {
        this.previousValue = value;
    }

    public void setFieldValueFromOutside(String newValue) {
        this.setPreviousStringValue(this.getStringValue());
        this.setInherited(false);
        this.setPresentsDefaultValue(false);
        this.levelFromWhichLoaded = null;
        this.updateComboForValue(newValue);
    }

    public String getStringValue() {
        return this.fValue;
    }

    public String getSpecialStringValue() {
        if (!this.hasSpecialValue) {
            throw new IllegalStateException("ComboFieldEditor.getSpecialValue():  field does not have a special value");
        }
        return (String)this.specialValue;
    }

    public void setSpecialValue(String specialValue) {
        throw new IllegalStateException("ComboField.setSpecialValue(String):  field has no special value");
    }
}

