/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.internal.qvt.oml.common.ui.FolderSelectionDialog;
import org.eclipse.m2m.internal.qvt.oml.common.ui.TypedElementSelectionValidator;
import org.eclipse.m2m.internal.qvt.oml.common.ui.TypedViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ChooseProjectFolderDialog
extends FolderSelectionDialog {
    public ChooseProjectFolderDialog(IProject project, IContainer initialContainer, Shell shell, String title, String message) {
        super(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        IProject[] allProjects = root.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)project)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        IResource initSelection = null;
        if (initialContainer != null) {
            initSelection = root.findMember(initialContainer.getFullPath());
        }
        this.setTitle(title);
        this.setValidator(new ISelectionStatusValidator(acceptedClasses){
            ISelectionStatusValidator validator;
            {
                this.validator = new TypedElementSelectionValidator(classArray, false);
            }

            public IStatus validate(Object[] selection) {
                IStatus typedStatus = this.validator.validate(selection);
                if (!typedStatus.isOK()) {
                    return typedStatus;
                }
                return new Status(0, "org.eclipse.m2m.qvt.oml.ui", 0, "", null);
            }
        });
        this.setMessage(message);
        this.addFilter((ViewerFilter)filter);
        this.setInput(root);
        this.setInitialSelection(initSelection);
        this.setComparator((ViewerComparator)new ResourceComparator(1));
    }
}

