/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper.property;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pannotation.Inheritance;
import org.eclipse.emf.teneo.annotations.pannotation.InheritanceType;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.AbstractMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class InheritanceMapper
extends AbstractMapper
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(InheritanceMapper.class);

    public void map(PAnnotatedEClass aClass, Element classElement) {
        this.mappingContext.setForceOptional(false);
        Inheritance inheritance = this.getInheritance(aClass);
        if (aClass.getMappedSuperclass() != null) {
            Element inheritanceElement = classElement.addElement("inheritance");
            inheritanceElement.addAttribute("strategy", "subclass-table");
        } else if (inheritance.getStrategy().equals((Object)InheritanceType.JOINED)) {
            log.debug((Object)("Inheritance mapping " + inheritance.getStrategy().getName()));
            Element inheritanceElement = classElement.addElement("inheritance");
            inheritanceElement.addAttribute("strategy", "new-table");
        } else if (inheritance.getStrategy().equals((Object)InheritanceType.SINGLE_TABLE)) {
            log.debug((Object)("Inheritance mapping " + inheritance.getStrategy().getName()));
            if (aClass.getPaSuperEntity() != null && aClass.getPaSuperEntity().getMappedSuperclass() == null) {
                log.debug((Object)"Has superclasses therefore: superclass-table");
                Element inheritanceElement = classElement.addElement("inheritance");
                inheritanceElement.addAttribute("strategy", "superclass-table");
                this.mappingContext.setForceOptional(true);
                if (aClass.getDiscriminatorValue() != null) {
                    Element discriminator = inheritanceElement.addElement("discriminator");
                    discriminator.addAttribute("value", aClass.getDiscriminatorValue().getValue());
                }
            } else {
                log.debug((Object)"Has no superclasses therefore: new-table");
                Element inheritanceElement = classElement.addElement("inheritance");
                inheritanceElement.addAttribute("strategy", "new-table");
                String colName = "CLASS_DISCRIMINATOR";
                if (aClass.getDiscriminatorColumn() != null) {
                    colName = aClass.getDiscriminatorColumn().getName();
                }
                Element discriminator = inheritanceElement.addElement("discriminator");
                discriminator.addAttribute("column", colName);
                if (aClass.getDiscriminatorValue() != null) {
                    discriminator.addAttribute("strategy", "value-map").addAttribute("value", aClass.getDiscriminatorValue().getValue());
                } else {
                    discriminator.addAttribute("strategy", "class-name");
                }
                log.debug((Object)("Added discrimnator with colname " + colName));
            }
        } else {
            throw new StoreMappingException("Inheritance type: " + inheritance.getStrategy().getName() + " not supported");
        }
    }

    private Inheritance getInheritance(PAnnotatedEClass childPA) {
        if (childPA.getInheritance() != null) {
            return childPA.getInheritance();
        }
        if (childPA.getPaSuperEntity() != null) {
            return this.getInheritance(childPA.getPaSuperEntity());
        }
        return null;
    }
}

