/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapping;

import javax.jdo.spi.PersistenceCapable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.jpox.JpoxStoreException;
import org.eclipse.emf.teneo.jpox.mapping.JPOXSimpleAnyTypeImpl;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.OID;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.SingleFieldMultiMapping;

public class EObjectMapping
extends SingleFieldMultiMapping
implements MappingCallbacks {
    private static Log log = LogFactory.getLog(EObjectMapping.class);

    public void initialize(DatastoreAdapter dba, AbstractPropertyMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.addDatastoreField(ClassNameConstants.JAVA_LANG_STRING);
        this.addDatastoreField(ClassNameConstants.JAVA_LANG_STRING);
    }

    public Class getJavaType() {
        return EObject.class;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        JPOXSimpleAnyTypeImpl anyTypeImpl = new JPOXSimpleAnyTypeImpl();
        anyTypeImpl.setInstanceType(XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text().getEAttributeType());
        anyTypeImpl.setValue((Object)"Sample Value");
        return anyTypeImpl;
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean includeInUpdateStatement() {
        return true;
    }

    public boolean includeInInsertStatement() {
        return true;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return null;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return null;
    }

    public void setObject(PersistenceManager pm, Object preparedStatement, int[] exprIndex, Object value) {
        EObject eobj = (EObject)value;
        if (eobj == null) {
            this.getDataStoreMapping(0).setString(preparedStatement, exprIndex[0], null);
            this.getDataStoreMapping(1).setString(preparedStatement, exprIndex[1], null);
        } else if (eobj instanceof PersistenceCapable) {
            PersistenceCapable pc = (PersistenceCapable)eobj;
            if (pc.jdoGetObjectId() == null) {
                pm.makePersistent((Object)pc);
            }
            this.getDataStoreMapping(0).setString(preparedStatement, exprIndex[0], "#");
            this.getDataStoreMapping(1).setString(preparedStatement, exprIndex[1], pc.jdoGetObjectId().toString());
        } else if (eobj instanceof SimpleAnyType) {
            SimpleAnyType simpleAnyType = (SimpleAnyType)eobj;
            if (!(simpleAnyType.eContainmentFeature().getEType() instanceof EDataType)) {
                throw new JpoxStoreException("The containing feature (" + simpleAnyType.eContainmentFeature().getName() + ") is not a EDataType but a " + simpleAnyType.eContainmentFeature().getEType().getClass().getName());
            }
            this.getDataStoreMapping(0).setString(preparedStatement, exprIndex[0], StoreUtil.structuralFeatureToString((EStructuralFeature)simpleAnyType.eContainmentFeature()));
            this.getDataStoreMapping(1).setString(preparedStatement, exprIndex[1], simpleAnyType.getRawValue());
        } else {
            throw new JpoxStoreException("The EObjectMapping does not support this class: " + value.getClass().getName());
        }
    }

    public Object getObject(PersistenceManager pm, Object resultSet, int[] exprIndex) {
        String strVal0 = this.getDataStoreMapping(0).getString(resultSet, exprIndex[0]);
        String strVal1 = this.getDataStoreMapping(1).getString(resultSet, exprIndex[1]);
        if (strVal0.startsWith("#")) {
            Object obj = pm.getObjectById((Object)new OID(strVal1), true, true, null);
            if (obj == null) {
                String msg = "EObjectMapping.getObject(): Object with object id: " + strVal1 + " of class: " + strVal0 + " can not be retrieved, is has probably been deleted";
                log.error((Object)msg);
                JPOXSimpleAnyTypeImpl anyTypeImpl = new JPOXSimpleAnyTypeImpl();
                anyTypeImpl.setInstanceType(XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text().getEAttributeType());
                anyTypeImpl.setValue((Object)msg);
                return anyTypeImpl;
            }
            return obj;
        }
        EStructuralFeature feature = StoreUtil.stringToStructureFeature((String)strVal0);
        JPOXSimpleAnyTypeImpl anyTypeImpl = new JPOXSimpleAnyTypeImpl();
        anyTypeImpl.setInstanceType((EDataType)feature.getEType());
        anyTypeImpl.setRawValue(strVal1);
        return anyTypeImpl;
    }

    public void deleteDependent(StateManager sm) {
        EStructuralFeature feature = StoreUtil.getEStructuralFeature((EObject)((InternalEObject)sm.getObject()), (String)this.fmd.getName());
        if (feature instanceof EReference) {
            EReference eref = (EReference)feature;
            sm.isLoaded(sm.getObject(), this.fmd.getAbsoluteFieldNumber());
            Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
            if (eref.isContainment() && value instanceof PersistenceCapable) {
                sm.getPersistenceManager().deletePersistent(value);
            }
        }
    }

    public void postFetch(StateManager sm) {
    }

    public void postInsert(StateManager sm) {
    }

    public void postUpdate(StateManager sm) {
    }

    public void preDelete(StateManager sm) {
    }
}

