/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.type;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.util.StoreUtil;

public abstract class FeatureMapEntry
implements FeatureMap.Entry.Internal,
Serializable {
    private static final long serialVersionUID = 1L;
    private EStructuralFeature eStructuralFeature;
    private String eFeaturePath;
    private Object value;
    private boolean initialized = false;
    private InverseAction inverseAction;
    private FeatureMap.Internal owningMap;

    public FeatureMapEntry() {
    }

    public FeatureMapEntry(EStructuralFeature feature, Object val) {
        this.eStructuralFeature = feature;
        this.value = val;
        this.initialized = true;
        this.initializeSpecificImplementation();
        this.setInverseAction();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.eFeaturePath = StoreUtil.structuralFeatureToString(this.eStructuralFeature);
        this.eStructuralFeature = null;
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.eStructuralFeature = StoreUtil.stringToStructureFeature(this.eFeaturePath);
    }

    private void setInverseAction() {
        EReference eref;
        this.inverseAction = this.eStructuralFeature instanceof EReference ? ((eref = (EReference)this.eStructuralFeature).getEOpposite() != null ? new BidirectionalInverseAction() : (eref.isContainment() ? new ContainmentInverseAction() : new InverseAction(null, null))) : new InverseAction(null, null);
    }

    public void setFeatureMap(FeatureMap.Internal featureMap) {
        this.owningMap = featureMap;
    }

    public void unsetFeatureMap() {
        this.owningMap = null;
    }

    public boolean isFeatureMapSet() {
        return this.owningMap != null;
    }

    public boolean belongsToFeatureMap(FeatureMap.Internal fm) {
        return this.owningMap == fm;
    }

    public void setEntry(FeatureMap.Entry entry) {
        this.eStructuralFeature = entry.getEStructuralFeature();
        this.value = entry.getValue();
        this.initialized = true;
        this.initializeSpecificImplementation();
        this.setInverseAction();
    }

    public void initialize() {
        this.eStructuralFeature = this.retrieveStructuralFeature(this.getStructuralFeatureDBID());
        this.value = this.getValueFromSpecificImplementation(this.eStructuralFeature);
        this.initialized = true;
        this.setInverseAction();
    }

    protected abstract Object getValueFromSpecificImplementation(EStructuralFeature var1);

    protected abstract String getStructuralFeatureDBID();

    protected abstract void initializeSpecificImplementation();

    public void setFields(EStructuralFeature structuralFeature, Object structuralValue) {
        this.eStructuralFeature = structuralFeature;
        this.value = structuralValue;
        this.initialized = true;
        this.initializeSpecificImplementation();
        this.setInverseAction();
    }

    public EStructuralFeature getEStructuralFeature() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.eStructuralFeature;
    }

    public Object getValue() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.value;
    }

    protected String createStructuralFeatureDBID() {
        return StoreUtil.structuralFeatureToString(this.getEStructuralFeature());
    }

    protected EStructuralFeature retrieveStructuralFeature(String dbid) {
        return StoreUtil.stringToStructureFeature(dbid);
    }

    protected boolean featureForField(String name) {
        if (this.eStructuralFeature.getName().compareTo(name) == 0) {
            return true;
        }
        EStructuralFeature groupFeature = ExtendedMetaData.INSTANCE.getGroup(this.eStructuralFeature);
        if (groupFeature != null && groupFeature.getName().compareTo(name) == 0) {
            return true;
        }
        EStructuralFeature affiliatedFeature = ExtendedMetaData.INSTANCE.getAffiliation(this.eStructuralFeature);
        return affiliatedFeature != null && affiliatedFeature.getName().compareTo(name) == 0;
    }

    public void setContainer(InternalEObject owner) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.value != null && this.value instanceof InternalEObject && this.eStructuralFeature instanceof EReference && ((EReference)this.eStructuralFeature).isContainment()) {
            EContainerRepairControl.setContainer(owner, (InternalEObject)this.value, this.eStructuralFeature);
        }
    }

    public boolean equals(Object that) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this == that) {
            return true;
        }
        if (!(that instanceof FeatureMap.Entry)) {
            return false;
        }
        FeatureMap.Entry entry = (FeatureMap.Entry)that;
        return entry.getEStructuralFeature() == this.eStructuralFeature && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        if (!this.initialized) {
            this.initialize();
        }
        String prefix = this.eStructuralFeature.getEContainingClass().getEPackage().getNsPrefix();
        this.eStructuralFeature.getName();
        return String.valueOf(prefix != null && prefix.length() != 0 ? String.valueOf(prefix) + ":" + this.eStructuralFeature.getName() : this.eStructuralFeature.getName()) + "=" + this.value;
    }

    public FeatureMap.Entry.Internal createEntry(InternalEObject value) {
        return this.createEntry((Object)value);
    }

    public abstract FeatureMap.Entry.Internal createEntry(Object var1);

    public NotificationChain inverseAdd(InternalEObject owner, int featureID, NotificationChain notifications) {
        return this.inverseAction.inverseAdd(owner, featureID, notifications);
    }

    public NotificationChain inverseAdd(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
        return this.inverseAction.inverseAdd(owner, otherEnd, featureID, notifications);
    }

    public NotificationChain inverseRemove(InternalEObject owner, int featureID, NotificationChain notifications) {
        return this.inverseAction.inverseRemove(owner, featureID, notifications);
    }

    public NotificationChain inverseRemove(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
        return this.inverseAction.inverseRemove(owner, otherEnd, featureID, notifications);
    }

    public void validate(Object value) {
        if (value != null && !this.eStructuralFeature.getEType().isInstance(value)) {
            String valueClass = value instanceof EObject ? ((EObject)value).eClass().getName() : value.getClass().getName();
            throw new ClassCastException("The feature '" + this.eStructuralFeature.getName() + "'s type '" + this.eStructuralFeature.getEType().getName() + "' does not permit a value of type '" + valueClass + "'");
        }
    }

    private class BidirectionalInverseAction
    extends InverseAction {
        private BidirectionalInverseAction() {
        }

        public NotificationChain inverseAdd(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return this.inverseAdd(owner, (InternalEObject)FeatureMapEntry.this.value, featureID, notifications);
        }

        public NotificationChain inverseRemove(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return this.inverseRemove(owner, (InternalEObject)FeatureMapEntry.this.value, featureID, notifications);
        }

        private final NotificationChain inverseAdd(InternalEObject owner, InternalEObject otherEnd, int featureID, NotificationChain notifications) {
            if (otherEnd != null) {
                notifications = otherEnd.eInverseAdd(owner, otherEnd.eClass().getFeatureID((EStructuralFeature)((EReference)FeatureMapEntry.this.eStructuralFeature).getEOpposite()), null, notifications);
            }
            return notifications;
        }

        private final NotificationChain inverseRemove(InternalEObject owner, InternalEObject otherEnd, int featureID, NotificationChain notifications) {
            if (otherEnd != null) {
                notifications = otherEnd.eInverseRemove(owner, otherEnd.eClass().getFeatureID((EStructuralFeature)((EReference)FeatureMapEntry.this.eStructuralFeature).getEOpposite()), null, notifications);
            }
            return notifications;
        }
    }

    private class ContainmentInverseAction
    extends InverseAction {
        private ContainmentInverseAction() {
        }

        public NotificationChain inverseAdd(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return this.inverseAdd(owner, (InternalEObject)FeatureMapEntry.this.value, featureID, notifications);
        }

        public NotificationChain inverseRemove(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return this.inverseRemove(owner, (InternalEObject)FeatureMapEntry.this.value, featureID, notifications);
        }

        private NotificationChain inverseAdd(InternalEObject owner, InternalEObject otherEnd, int featureID, NotificationChain notifications) {
            if (otherEnd != null) {
                int containmentFeatureID = owner.eClass().getFeatureID(FeatureMapEntry.this.eStructuralFeature);
                notifications = otherEnd.eInverseAdd(owner, -1 - (containmentFeatureID == -1 ? featureID : containmentFeatureID), null, notifications);
            }
            return notifications;
        }

        private NotificationChain inverseRemove(InternalEObject owner, InternalEObject otherEnd, int featureID, NotificationChain notifications) {
            if (otherEnd != null) {
                int containmentFeatureID = owner.eClass().getFeatureID(FeatureMapEntry.this.eStructuralFeature);
                notifications = otherEnd.eInverseRemove(owner, -1 - (containmentFeatureID == -1 ? featureID : containmentFeatureID), null, notifications);
            }
            return notifications;
        }
    }

    private class InverseAction {
        private InverseAction() {
        }

        public NotificationChain inverseAdd(InternalEObject owner, int featureID, NotificationChain notifications) {
            return this.inverseAdd(owner, FeatureMapEntry.this.value, featureID, notifications);
        }

        public NotificationChain inverseRemove(InternalEObject owner, int featureID, NotificationChain notifications) {
            return this.inverseRemove(owner, FeatureMapEntry.this.value, featureID, notifications);
        }

        public NotificationChain inverseAdd(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return notifications;
        }

        public NotificationChain inverseRemove(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return notifications;
        }

        public void validate(Object value) {
            if (value != null && !FeatureMapEntry.this.eStructuralFeature.getEType().isInstance(value)) {
                String valueClass = value instanceof EObject ? ((EObject)value).eClass().getName() : value.getClass().getName();
                throw new ClassCastException("The feature '" + FeatureMapEntry.this.eStructuralFeature.getName() + "'s type '" + FeatureMapEntry.this.eStructuralFeature.getEType().getName() + "' does not permit a value of type '" + valueClass + "'");
            }
        }

        /* synthetic */ InverseAction(InverseAction inverseAction, InverseAction inverseAction2) {
            this();
        }
    }
}

