/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.Id;
import org.eclipse.emf.teneo.annotations.pannotation.Transient;
import org.eclipse.emf.teneo.hibernate.mapper.FeatureMapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingContext;
import org.eclipse.emf.teneo.simpledom.Element;
import org.eclipse.emf.teneo.util.StoreUtil;

public class FeatureMapMapping {
    private static final Log log = LogFactory.getLog(FeatureMapMapping.class);
    private final PAnnotatedEAttribute paAttribute;
    private final MappingContext hbmContext;

    public FeatureMapMapping(MappingContext hbmContext, PAnnotatedEAttribute paAttribute) {
        log.debug((Object)("Created featuremap mapping instance for " + paAttribute));
        this.hbmContext = hbmContext;
        this.paAttribute = paAttribute;
        EAttribute eattr = paAttribute.getModelEAttribute();
        assert (FeatureMapUtil.isFeatureMap((EStructuralFeature)eattr));
    }

    public String getEntityName() {
        return StoreUtil.getEntityName((EStructuralFeature)this.paAttribute.getModelEAttribute());
    }

    public void process() {
        String entityName = StoreUtil.getEntityName((EStructuralFeature)this.paAttribute.getModelEAttribute());
        log.debug((Object)("Processing feature map feature: " + entityName));
        Element mainElement = this.hbmContext.getCurrent().addElement("class").addAttribute("entity-name", entityName).addAttribute("lazy", "false").addAttribute("table", this.hbmContext.trunc(entityName.toUpperCase(), false));
        mainElement.addElement("meta").addAttribute("attribute", "featureMap").addText(this.hbmContext.getEntityNameStrategy().toEntityName(this.paAttribute.getModelEAttribute().getEContainingClass()));
        FeatureMapper fp = this.hbmContext.getFeatureMapper();
        this.hbmContext.setCurrent(mainElement);
        this.hbmContext.setCurrentElementFeatureMap(true);
        this.hbmContext.setNamePrefix(String.valueOf(this.paAttribute.getModelEAttribute().getName()) + "_");
        mainElement.addElement("id").addAttribute("type", "long").addElement("generator").addAttribute("class", "native");
        if (this.hbmContext.alwaysVersion()) {
            Element versionElement = mainElement.addElement("version").addAttribute("name", this.hbmContext.getVersionColumnName()).addAttribute("access", "org.eclipse.emf.teneo.hibernate.mapping.property.VersionPropertyHandler");
            Element meta = new Element("meta");
            meta.addAttribute("attribute", "syntheticVersion").addText("true");
            versionElement.add(0, meta);
        }
        mainElement.addElement("property").addAttribute("name", "fme_feature").addAttribute("type", "java.lang.String");
        PAnnotatedEClass paClass = this.paAttribute.getPaEClass();
        boolean isMixed = StoreUtil.isMixed((EStructuralFeature)this.paAttribute.getModelEAttribute());
        for (PAnnotatedEStructuralFeature paFeature : paClass.getPaEStructuralFeatures()) {
            EStructuralFeature eFeature = paFeature.getModelEStructuralFeature();
            if ((!isMixed || eFeature.getFeatureID() == this.paAttribute.getModelEAttribute().getFeatureID()) && !StoreUtil.isElementOfGroup((EStructuralFeature)eFeature, (EStructuralFeature)this.paAttribute.getModelEAttribute())) continue;
            log.debug((Object)("Feature " + StoreUtil.toString((EStructuralFeature)eFeature) + " belongs to this featuremap"));
            Id id = null;
            if (paFeature instanceof PAnnotatedEAttribute && ((PAnnotatedEAttribute)paFeature).getId() != null) {
                id = ((PAnnotatedEAttribute)paFeature).getId();
                ((PAnnotatedEAttribute)paFeature).setId(null);
            }
            Transient tt = paFeature.getTransient();
            paFeature.setTransient(null);
            try {
                fp.process(paFeature);
            }
            finally {
                paFeature.setTransient(tt);
                if (id != null) {
                    ((PAnnotatedEAttribute)paFeature).setId(id);
                }
            }
        }
        if (isMixed) {
            mainElement.addElement("property").addAttribute("name", "fme_mixed_text").addAttribute("type", "java.lang.String");
            mainElement.addElement("property").addAttribute("name", "fme_mixed_cdata").addAttribute("type", "java.lang.String");
            mainElement.addElement("property").addAttribute("name", "fme_mixed_comment").addAttribute("type", "java.lang.String");
        }
        this.hbmContext.setCurrent(mainElement.getParent());
        this.hbmContext.setCurrentElementFeatureMap(false);
        this.hbmContext.setNamePrefix("");
        log.debug((Object)"Finished processing featuremap");
    }

    public EAttribute getEAttribute() {
        return this.paAttribute.getModelEAttribute();
    }
}

