/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.MappingContext;

public class NamingHandler
implements ExtensionPoint,
ExtensionManagerAware {
    protected static final Log log = LogFactory.getLog(NamingHandler.class);
    protected static final String ORDER_COLUMN_SUFFIX = "_IDX";
    protected static final String ID_COLUMN_SUFFIX = "_ID";
    private ExtensionManager extensionManager;
    protected ArrayList uniqueNames = new ArrayList();

    public String getUniqueIndexColumnName(EStructuralFeature feature) {
        String colName = feature.getName().toUpperCase();
        String ownerName = feature.getEContainingClass().getName().toUpperCase();
        String checkName = String.valueOf(ownerName) + "_" + colName;
        int index = 1;
        while (this.uniqueNames.indexOf(checkName) != -1) {
            checkName = String.valueOf(ownerName) + colName + index++;
        }
        this.uniqueNames.add(checkName);
        return String.valueOf(checkName) + ORDER_COLUMN_SUFFIX;
    }

    public String correctName(Class implClass, EStructuralFeature efeature) {
        Field element;
        Field[] fields;
        String featureName = efeature.getName();
        Field[] fieldArray = fields = implClass.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            element = fieldArray[n2];
            log.debug((Object)(String.valueOf(element.getName()) + "-" + efeature.getName()));
            if (element.getName().compareTo(featureName) == 0) {
                return element.getName();
            }
            ++n2;
        }
        fieldArray = fields;
        n = fields.length;
        n2 = 0;
        while (n2 < n) {
            element = fieldArray[n2];
            log.debug((Object)(String.valueOf(element.getName()) + "-" + efeature.getName()));
            if (element.getName().compareToIgnoreCase(featureName) == 0) {
                return element.getName();
            }
            ++n2;
        }
        featureName = String.valueOf(featureName) + "_";
        fieldArray = fields;
        n = fields.length;
        n2 = 0;
        while (n2 < n) {
            element = fieldArray[n2];
            log.debug((Object)(String.valueOf(element.getName()) + "-" + efeature.getName()));
            if (element.getName().compareToIgnoreCase(featureName) == 0) {
                return element.getName();
            }
            ++n2;
        }
        log.error((Object)("The structural feature: " + efeature.getName() + "/" + efeature.getEContainingClass().getName() + " does not have a corresponding java member in " + implClass.getName()));
        return "";
    }

    public String correctName(MappingContext mc, EStructuralFeature efeature) {
        Class implClass = EModelResolver.instance().getJavaClass((EClassifier)mc.getCurrentAClass().getModelEClass());
        return this.correctName(implClass, efeature);
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

