/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.rental;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RentalBicycleType implements Enumerator
{
    STANDARD(0, "Standard", "Standard"),
    MOUNTAIN_BIKE(1, "MountainBike", "MountainBike");

    public static final int STANDARD_VALUE = 0;
    public static final int MOUNTAIN_BIKE_VALUE = 1;
    private static final RentalBicycleType[] VALUES_ARRAY;
    public static final List<RentalBicycleType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RentalBicycleType[]{STANDARD, MOUNTAIN_BIKE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RentalBicycleType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RentalBicycleType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RentalBicycleType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RentalBicycleType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RentalBicycleType get(int value) {
        switch (value) {
            case 0: {
                return STANDARD;
            }
            case 1: {
                return MOUNTAIN_BIKE;
            }
        }
        return null;
    }

    private RentalBicycleType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

