/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.sample.accounting.impl;

import java.util.Date;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.AccountGroup;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.Accounting;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.AccountingFactory;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.AccountingPackage;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.BalanceAccount;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.JournalGroup;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.JournalStatement;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.PLAccount;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.Report;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.ReportGroup;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.Vat;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.impl.AccountGroupImpl;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.impl.AccountingImpl;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.impl.BalanceAccountImpl;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.impl.JournalGroupImpl;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.impl.JournalStatementImpl;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.impl.PLAccountImpl;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.impl.ReportGroupImpl;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.impl.ReportImpl;
import org.eclipse.emf.teneo.samples.emf.sample.accounting.impl.VatImpl;

public class AccountingFactoryImpl
extends EFactoryImpl
implements AccountingFactory {
    public static AccountingFactory init() {
        try {
            AccountingFactory theAccountingFactory = (AccountingFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/teneo/samples/emf/sample/accounting");
            if (theAccountingFactory != null) {
                return theAccountingFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new AccountingFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createAccountGroup();
            }
            case 2: {
                return this.createAccounting();
            }
            case 3: {
                return this.createBalanceAccount();
            }
            case 4: {
                return this.createJournalGroup();
            }
            case 5: {
                return this.createJournalStatement();
            }
            case 6: {
                return this.createPLAccount();
            }
            case 7: {
                return this.createReport();
            }
            case 8: {
                return this.createReportGroup();
            }
            case 9: {
                return this.createVat();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.createDateFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.convertDateToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public AccountGroup createAccountGroup() {
        AccountGroupImpl accountGroup = new AccountGroupImpl();
        return accountGroup;
    }

    public Accounting createAccounting() {
        AccountingImpl accounting = new AccountingImpl();
        return accounting;
    }

    public BalanceAccount createBalanceAccount() {
        BalanceAccountImpl balanceAccount = new BalanceAccountImpl();
        return balanceAccount;
    }

    public JournalGroup createJournalGroup() {
        JournalGroupImpl journalGroup = new JournalGroupImpl();
        return journalGroup;
    }

    public JournalStatement createJournalStatement() {
        JournalStatementImpl journalStatement = new JournalStatementImpl();
        return journalStatement;
    }

    public PLAccount createPLAccount() {
        PLAccountImpl plAccount = new PLAccountImpl();
        return plAccount;
    }

    public Report createReport() {
        ReportImpl report = new ReportImpl();
        return report;
    }

    public ReportGroup createReportGroup() {
        ReportGroupImpl reportGroup = new ReportGroupImpl();
        return reportGroup;
    }

    public Vat createVat() {
        VatImpl vat = new VatImpl();
        return vat;
    }

    public Date createDateFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : new XMLCalendar(this.collapseWhiteSpace(initialValue), 0).getDate();
    }

    public String convertDateToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        if (instanceValue instanceof Date) {
            return new XMLCalendar((Date)instanceValue, 0).toString();
        }
        return instanceValue.toString();
    }

    public AccountingPackage getAccountingPackage() {
        return (AccountingPackage)this.getEPackage();
    }

    @Deprecated
    public static AccountingPackage getPackage() {
        return AccountingPackage.eINSTANCE;
    }
}

